/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.util;

import java.io.IOException;
import java.util.Stack;
import java.util.function.Predicate;
import net.thevpc.nuts.command.NExecutionException;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementDescribables;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.runtime.standalone.repository.impl.main.DefaultNInstalledRepository;
import net.thevpc.nuts.runtime.standalone.util.NCoreLogUtils;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NIteratorBase;
import net.thevpc.nuts.util.NStream;
import net.thevpc.nuts.util.NUnsupportedOperationException;

public class FolderObjectIterator<T>
extends NIteratorBase<T> {
    private final Stack<PathAndDepth> stack = new Stack();
    private final Predicate<T> filter;
    private final FolderIteratorModel<T> model;
    private final String name;
    private final NPath folder;
    private T last;
    private NPath lastPath;
    private long visitedFoldersCount;
    private long visitedFilesCount;
    private final int maxDepth;

    public FolderObjectIterator(String name, NPath folder, Predicate<T> filter, int maxDepth, FolderIteratorModel<T> model) {
        this.filter = filter;
        this.model = model;
        this.name = name;
        this.maxDepth = maxDepth;
        NAssert.requireNonNull(folder, "folder");
        this.folder = folder;
        this.stack.push(new PathAndDepth(folder, 0));
    }

    @Override
    public NElement describe() {
        return NElement.ofObjectBuilder().name("ScanPath").addParam(NElement.ofString(this.name)).set("path", NElementDescribables.describeResolveOrDestruct(this.folder)).set("maxDepth", this.maxDepth).set("filter", NElementDescribables.describeResolveOrDestruct(this.filter)).build();
    }

    private NLog LOG() {
        return NLog.of(DefaultNInstalledRepository.class);
    }

    @Override
    public boolean hasNext() {
        this.last = null;
        while (!this.stack.isEmpty()) {
            PathAndDepth file = this.stack.pop();
            if (file.path.isDirectory()) {
                boolean deep;
                NSession.of().getTerminal().printProgress(NMsg.ofC("%-8s %s", "browse", NCoreLogUtils.forProgress(file.path)));
                ++this.visitedFoldersCount;
                boolean bl = deep = this.maxDepth < 0 || file.depth < this.maxDepth;
                if (!file.path.isDirectory()) continue;
                try {
                    ((NStream)file.path.stream().filter(pathname -> {
                        try {
                            return deep && pathname.isDirectory() || this.model.isObjectFile((NPath)pathname);
                        }
                        catch (Exception ex) {
                            NLog.of(FolderObjectIterator.class).log(NMsg.ofC("unable to test desk file %s", pathname).asFineFail(ex));
                            return false;
                        }
                    }).redescribe(NElementDescribables.ofDesc("isDirectory || isObjectFile"))).forEach(item -> {
                        if (item.isDirectory()) {
                            if (this.maxDepth < 0 || file.depth < this.maxDepth) {
                                this.stack.push(new PathAndDepth((NPath)item, file.depth + 1));
                            }
                        } else {
                            this.stack.push(new PathAndDepth((NPath)item, file.depth));
                        }
                    });
                }
                catch (Exception ex) {
                    this.LOG().log(NMsg.ofC("unable to parse %s", file.path).asError(ex));
                }
                continue;
            }
            ++this.visitedFilesCount;
            Object t = null;
            try {
                t = this.model.parseObject(file.path);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (t == null || this.filter != null && !this.filter.test(t)) continue;
            this.last = t;
            this.lastPath = file.path;
            break;
        }
        return this.last != null;
    }

    @Override
    public T next() {
        T ret = this.last;
        this.last = null;
        this.lastPath = null;
        return ret;
    }

    @Override
    public void remove() {
        if (this.last == null) {
            throw new NUnsupportedOperationException(NMsg.ofPlain("unsupported remove"));
        }
        this.model.remove(this.last, this.lastPath);
    }

    public long getVisitedFoldersCount() {
        return this.visitedFoldersCount;
    }

    public long getVisitedFilesCount() {
        return this.visitedFilesCount;
    }

    public String toString() {
        return "FolderIterator<" + this.name + ">(folder=" + this.folder + "; depth=" + this.maxDepth + ')';
    }

    public static interface FolderIteratorModel<T> {
        default public void remove(T object, NPath objectPath) throws NExecutionException {
        }

        public boolean isObjectFile(NPath var1);

        public T parseObject(NPath var1) throws IOException;
    }

    private static class PathAndDepth {
        private final NPath path;
        private final int depth;

        public PathAndDepth(NPath path, int depth) {
            this.path = path;
            this.depth = depth;
        }
    }
}

