/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.thevpc.nuts.core.NAddRepositoryOptions;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.DefaultNContentMetadata;
import net.thevpc.nuts.io.NAsk;
import net.thevpc.nuts.io.NContentMetadata;
import net.thevpc.nuts.io.NContentMetadataProvider;
import net.thevpc.nuts.io.NCp;
import net.thevpc.nuts.io.NExecInput;
import net.thevpc.nuts.io.NExecOutput;
import net.thevpc.nuts.io.NIO;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NInputSource;
import net.thevpc.nuts.io.NInputSourceBuilder;
import net.thevpc.nuts.io.NMemoryPrintStream;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NPathExtensionType;
import net.thevpc.nuts.io.NPathOption;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.io.NRedirectType;
import net.thevpc.nuts.io.NTerminalMode;
import net.thevpc.nuts.platform.NStoreType;
import net.thevpc.nuts.runtime.standalone.io.terminal.NTerminalModeOp;
import net.thevpc.nuts.runtime.standalone.text.ExtendedFormatAware;
import net.thevpc.nuts.runtime.standalone.text.ExtendedFormatAwarePrintWriter;
import net.thevpc.nuts.runtime.standalone.text.RawOutputStream;
import net.thevpc.nuts.runtime.standalone.util.DoWhenExist;
import net.thevpc.nuts.runtime.standalone.util.DoWhenNotExists;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.util.PathInfo;
import net.thevpc.nuts.runtime.standalone.xtra.digest.NDigestUtils;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDB;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBTableStore;
import net.thevpc.nuts.runtime.standalone.xtra.web.DefaultNWebCli;
import net.thevpc.nuts.spi.NSystemTerminalBase;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NCollections;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NNameFormat;
import net.thevpc.nuts.util.NNames;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NStream;
import net.thevpc.nuts.util.NStringUtils;
import net.thevpc.nuts.util.NUnsupportedEnumException;

public class CoreIOUtils {
    public static final String MIME_TYPE_SHA1 = "text/sha-1";
    public static String newLineString = null;

    public static final URL urlOf(String any) {
        try {
            return URI.create(any).toURL();
        }
        catch (MalformedURLException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Deprecated
    public static PrintWriter toPrintWriter(Writer writer, NSystemTerminalBase term) {
        if (writer == null) {
            return null;
        }
        if (writer instanceof ExtendedFormatAware && writer instanceof PrintWriter) {
            return (PrintWriter)writer;
        }
        ExtendedFormatAwarePrintWriter s = new ExtendedFormatAwarePrintWriter(writer, term, NWorkspace.of());
        return s;
    }

    public static boolean isValidConfLine(String line) {
        String l = NStringUtils.trimLeftToNull(line);
        if (l == null) {
            return false;
        }
        return l.charAt(0) != '#';
    }

    public static Stream<String> confLines(InputStream stream) {
        return CoreIOUtils.lines(stream).filter(CoreIOUtils::isValidConfLine);
    }

    public static Stream<String> confLines(Reader stream) {
        return CoreIOUtils.lines(stream).filter(CoreIOUtils::isValidConfLine);
    }

    public static Stream<String> lines(InputStream stream) {
        return CoreIOUtils.lines(new InputStreamReader(stream));
    }

    public static Stream<String> lines(final Reader reader) {
        return NCollections.finiteStream(new Supplier<String>(){
            private BufferedReader r;
            {
                this.r = new BufferedReader(reader);
            }

            @Override
            public String get() {
                try {
                    return this.r.readLine();
                }
                catch (IOException e) {
                    throw new NIOException(e);
                }
            }
        });
    }

    @Deprecated
    public static PrintWriter toPrintWriter(OutputStream writer, NSystemTerminalBase term) {
        if (writer == null) {
            return null;
        }
        ExtendedFormatAwarePrintWriter s = new ExtendedFormatAwarePrintWriter(writer, term, NWorkspace.of());
        return s;
    }

    @Deprecated
    public static OutputStream convertOutputStream(OutputStream out, NTerminalMode expected, NSystemTerminalBase term) {
        ExtendedFormatAware a = CoreIOUtils.convertOutputStreamToExtendedFormatAware(out, expected, term);
        return (OutputStream)((Object)a);
    }

    @Deprecated
    public static ExtendedFormatAware convertOutputStreamToExtendedFormatAware(OutputStream out, NTerminalMode expected, NSystemTerminalBase term) {
        if (out == null) {
            return null;
        }
        ExtendedFormatAware aw = null;
        aw = out instanceof ExtendedFormatAware ? (ExtendedFormatAware)((Object)out) : new RawOutputStream(out, term);
        switch (expected) {
            case INHERITED: {
                return aw.convert(NTerminalModeOp.NOP);
            }
            case FORMATTED: {
                return aw.convert(NTerminalModeOp.FORMAT);
            }
            case FILTERED: {
                return aw.convert(NTerminalModeOp.FILTER);
            }
        }
        throw new NIllegalArgumentException(NMsg.ofC("unsupported terminal mode %s", expected));
    }

    public static String resolveRepositoryPath(NAddRepositoryOptions options, Path rootFolder) {
        String loc = options.getLocation();
        String goodName = options.getName();
        if (NBlankable.isBlank(goodName)) {
            goodName = options.getConfig().getName();
        }
        if (NBlankable.isBlank(goodName)) {
            goodName = options.getName();
        }
        if (NBlankable.isBlank(goodName)) {
            goodName = options.isTemporary() ? "temp-" + UUID.randomUUID() : "repo-" + UUID.randomUUID();
        }
        if (NBlankable.isBlank(loc)) {
            if (options.isTemporary()) {
                if (NBlankable.isBlank(goodName)) {
                    goodName = "temp";
                }
                if (goodName.length() < 3) {
                    goodName = goodName + "-repo";
                }
                loc = NPath.ofTempFolder(goodName + "-").toString();
            } else if (NBlankable.isBlank(loc)) {
                if (NBlankable.isBlank(goodName)) {
                    goodName = NNames.pickName(new Random().nextInt(), 2, 3, NNameFormat.KEBAB_CASE) + "-repo";
                }
                loc = goodName;
            }
        }
        return NPath.of(loc).toAbsolute(rootFolder.toString()).toString();
    }

    public static NPrintStream resolveOut() {
        NSession session = NSession.of();
        return session.getTerminal() == null ? NPrintStream.NULL : session.getTerminal().out();
    }

    public static String buildUrl(String url, String path) {
        if (!url.endsWith("/")) {
            if (path.startsWith("/")) {
                return url + path;
            }
            return url + "/" + path;
        }
        if (path.startsWith("/")) {
            return url + path.substring(1);
        }
        return url + path;
    }

    public static String urlEncodeString(String s) {
        if (s == null || s.trim().length() == 0) {
            return "";
        }
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new NIOException(e);
        }
    }

    public static Path resolveLocalPathFromURL(URL url) {
        try {
            return new File(url.toURI()).toPath();
        }
        catch (URISyntaxException e) {
            return new File(url.getPath()).toPath();
        }
    }

    public static URL resolveURLFromResource(Class cls, String urlPath) {
        if (!urlPath.startsWith("/")) {
            throw new NIllegalArgumentException(NMsg.ofC("unable to resolve url from %s", urlPath));
        }
        URL url = cls.getResource(urlPath);
        String urlFile = url.getFile();
        int separatorIndex = urlFile.indexOf("!/");
        if (separatorIndex != -1) {
            String jarFile = urlFile.substring(0, separatorIndex);
            try {
                return CoreIOUtils.urlOf(jarFile);
            }
            catch (Exception ex) {
                if (!jarFile.startsWith("/")) {
                    jarFile = "/" + jarFile;
                }
                try {
                    return CoreIOUtils.urlOf("file:" + jarFile);
                }
                catch (Exception ex2) {
                    throw new NIOException(ex2);
                }
            }
        }
        String encoded = CoreIOUtils.encodePath(urlPath);
        String url_tostring = url.toString();
        if (url_tostring.endsWith(encoded)) {
            try {
                return CoreIOUtils.urlOf(url_tostring.substring(0, url_tostring.length() - encoded.length()));
            }
            catch (Exception ex) {
                throw new NIOException(ex);
            }
        }
        throw new NIllegalArgumentException(NMsg.ofC("unable to resolve url from %s", urlPath));
    }

    private static String encodePath(String path) {
        StringTokenizer st = new StringTokenizer(path, "/", true);
        StringBuilder encoded = new StringBuilder();
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            if (t.equals("/")) {
                encoded.append(t);
                continue;
            }
            try {
                encoded.append(URLEncoder.encode(t, "UTF-8"));
            }
            catch (UnsupportedEncodingException ex) {
                throw new NIllegalArgumentException(NMsg.ofC("unable to encode %s", t), (Throwable)ex);
            }
        }
        return encoded.toString();
    }

    public static File resolveLocalFileFromResource(Class cls, String url) {
        return CoreIOUtils.resolveLocalFileFromURL(CoreIOUtils.resolveURLFromResource(cls, url));
    }

    public static File resolveLocalFileFromURL(URL url) {
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException e) {
            return new File(url.getPath());
        }
    }

    public static InputStream getCachedUrlWithSHA1(String path, String sourceTypeName, boolean ignoreSha1NotFound) {
        NPath p;
        String cachedID;
        long lastModified;
        NPath p2;
        String cachedID2;
        String sha1;
        NPath urlContent;
        block4: {
            NWorkspace workspace = NWorkspace.of();
            NPath cacheBasePath = NPath.ofIdStore(workspace.getRuntimeId(), NStoreType.CACHE);
            urlContent = cacheBasePath.resolve("urls-content");
            sha1 = null;
            try {
                ByteArrayOutputStream t = new ByteArrayOutputStream();
                NCp.of().from(NPath.of(path + ".sha1")).to(t).run();
                sha1 = t.toString().trim();
            }
            catch (NIOException ex) {
                if (ignoreSha1NotFound) break block4;
                throw ex;
            }
        }
        NanoDB cachedDB = NWorkspaceExt.of().store().cacheDB();
        NanoDBTableStore<CachedURL> cacheTable = cachedDB.tableBuilder(CachedURL.class).setNullable(false).addAllFields().addIndices("url").getOrCreate();
        CachedURL old = cacheTable.findByIndex("url", path).findFirst().orNull();
        if (sha1 != null && old != null && sha1.equalsIgnoreCase(old.sha1) && (cachedID2 = old.path) != null && (p2 = urlContent.resolve(cachedID2)).exists()) {
            return p2.getInputStream();
        }
        NPath header = NPath.of(path);
        long size = header.getContentLength();
        Instant lastModifiedInstant = header.getLastModifiedInstant();
        long l = lastModified = lastModifiedInstant == null ? 0L : lastModifiedInstant.toEpochMilli();
        if (sha1 == null && old != null && old.lastModified != -1L && old.lastModified == lastModified && old != null && old.size == size && (cachedID = old.path) != null && (p = urlContent.resolve(cachedID)).exists()) {
            return p.getInputStream();
        }
        String s = UUID.randomUUID().toString();
        NPath outPath = urlContent.resolve(s + "~");
        urlContent.mkdirs();
        OutputStream p3 = outPath.getOutputStream();
        long finalLastModified = lastModified;
        NIO io = NIO.of();
        InputStream ist = NInputSourceBuilder.of(header.getInputStream()).setTee(p3).setCloseAction(() -> {
            if (outPath.exists()) {
                long newSize;
                CachedURL ccu = new CachedURL();
                ccu.url = path;
                ccu.path = s;
                ccu.sha1 = NDigestUtils.evalSHA1Hex(outPath);
                ccu.size = newSize = outPath.getContentLength();
                ccu.lastModified = finalLastModified;
                NPath newLocalPath = urlContent.resolve(s);
                try {
                    Files.move(outPath.toPath().get(), newLocalPath.toPath().get(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
                }
                catch (IOException ex) {
                    throw new NIOException(ex);
                }
                cacheTable.add(ccu);
                cacheTable.flush();
            }
        }).createInputStream();
        return NInputSourceBuilder.of(ist).setMetadata(new DefaultNContentMetadata(path, NMsg.ofNtf(NText.ofStyledPath(path)), size, header.getContentType(), header.getCharset(), sourceTypeName)).createInputStream();
    }

    public static Path toPathInputSource(NInputSource is, List<Path> tempPaths, boolean enforceExtension) {
        List<String> e;
        String ct;
        NPath pp;
        String ext;
        Path sf;
        boolean isPath = is instanceof NPath;
        if (isPath && (sf = ((NPath)is).toPath().orNull()) != null) {
            return sf;
        }
        String name = is.getMetaData().getName().orElse("no-name");
        Path temp = NPath.ofTempFile(name).toPath().get();
        NCp a = NCp.of().removeOptions(NPathOption.SAFE);
        if (isPath) {
            a.from((NPath)is);
        } else {
            a.from(is.getInputStream());
        }
        a.to(temp).run();
        if (enforceExtension && (ext = (pp = NPath.of(temp)).nameParts(NPathExtensionType.SHORT).getExtension()).isEmpty() && (ct = NIO.of().probeContentType(temp)) != null && !(e = NIO.of().findExtensionsByContentType(ct)).isEmpty()) {
            NPath newFile = NPath.ofTempFile(name + "." + e.get(0));
            Path newFilePath = newFile.toPath().get();
            try {
                Files.move(temp, newFilePath, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException ex) {
                throw new NIOException(ex);
            }
            tempPaths.add(newFilePath);
            return newFilePath;
        }
        tempPaths.add(temp);
        return temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getNewLine() {
        if (newLineString != null) return newLineString;
        Class<CoreIOUtils> clazz = CoreIOUtils.class;
        synchronized (CoreIOUtils.class) {
            newLineString = System.getProperty("line.separator");
            // ** MonitorExit[var0] (shouldn't be in output)
            return newLineString;
        }
    }

    public static boolean isObsoletePath(Path path) {
        try {
            return CoreIOUtils.isObsoleteInstant(Files.getLastModifiedTime(path, new LinkOption[0]).toInstant());
        }
        catch (IOException e) {
            return true;
        }
    }

    public static boolean isObsoletePath(NPath path) {
        try {
            Instant i = path.getLastModifiedInstant();
            if (i == null) {
                return false;
            }
            return CoreIOUtils.isObsoleteInstant(i);
        }
        catch (Exception e) {
            return true;
        }
    }

    public static boolean isObsoleteInstant(Instant instant) {
        NSession session = NSession.of();
        if (session.getExpireTime().isPresent()) {
            return instant == null || instant.isBefore(session.getExpireTime().orNull());
        }
        return false;
    }

    public static byte[] loadFileContentLenient(Path out) {
        if (Files.isRegularFile(out, new LinkOption[0])) {
            try {
                return Files.readAllBytes(out);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new byte[0];
    }

    public static boolean Arrays_equals(byte[] a, int aFromIndex, int aToIndex, byte[] b, int bFromIndex, int bToIndex) {
        int aLength = aToIndex - aFromIndex;
        int bLength = bToIndex - bFromIndex;
        if (aLength != bLength) {
            return false;
        }
        for (int i = 0; i < aLength; ++i) {
            if (a[aFromIndex + i] == b[bFromIndex + i]) continue;
            return false;
        }
        return true;
    }

    public static InputStream createBytesStream(byte[] bytes, NMsg message, String contentType, String encoding, String kind) {
        return NInputSourceBuilder.of(new ByteArrayInputStream(bytes)).setMetadata(new DefaultNContentMetadata(message, Long.valueOf(bytes.length), contentType, encoding, kind)).createInputStream();
    }

    public static String betterPath(String path1) {
        String home = System.getProperty("user.home");
        if (path1.startsWith(home + "/") || path1.startsWith(home + "\\")) {
            return "~" + path1.substring(home.length());
        }
        return path1;
    }

    public static String replaceFilePrefixes(String path, Map<String, String> map) {
        for (Map.Entry<String, String> e : map.entrySet()) {
            String v = CoreIOUtils.replaceFilePrefix(path, e.getKey(), e.getValue());
            if (v.equals(path)) continue;
            return v;
        }
        return path;
    }

    public static String replaceFilePrefix(String path, String prefix, String replacement) {
        String path1 = path;
        String fs = File.separator;
        if (!prefix.endsWith(fs)) {
            prefix = prefix + fs;
        }
        if (!path1.endsWith(fs)) {
            path1 = prefix + fs;
        }
        if (path1.equals(prefix)) {
            if (replacement == null) {
                return "";
            }
            return replacement;
        }
        if (path.startsWith(prefix)) {
            if (replacement == null || replacement.isEmpty()) {
                return path1.substring(prefix.length());
            }
            return replacement + fs + path1.substring(prefix.length());
        }
        return path;
    }

    public static String longestCommonParent(String path1, String path2) {
        int latestSlash = -1;
        int len = Math.min(path1.length(), path2.length());
        for (int i = 0; i < len && path1.charAt(i) == path2.charAt(i); ++i) {
            if (path1.charAt(i) != '/') continue;
            latestSlash = i;
        }
        if (latestSlash <= 0) {
            return "";
        }
        return path1.substring(0, latestSlash + 1);
    }

    public static PathInfo.Status tryWriteStatus(byte[] content, NPath out, String rememberMeKey) {
        return CoreIOUtils.tryWrite(content, out, DoWhenExist.IGNORE, DoWhenNotExists.IGNORE, rememberMeKey);
    }

    public static PathInfo.Status tryWrite(byte[] content, NPath out, String rememberMeKey) {
        return CoreIOUtils.tryWrite(content, out, DoWhenExist.ASK, DoWhenNotExists.CREATE, rememberMeKey);
    }

    public static PathInfo.Status tryWrite(byte[] content, NPath out, DoWhenExist doWhenExist, DoWhenNotExists doWhenNotExist, String rememberMeKey) {
        NAssert.requireNonNull(doWhenExist, "doWhenExist");
        NAssert.requireNonNull(doWhenNotExist, "doWhenNotExist");
        out = out.toAbsolute().normalize();
        byte[] old = null;
        if (out.isRegularFile()) {
            try {
                old = out.readBytes();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        NSession session = NSession.of();
        if (old == null) {
            switch (doWhenNotExist) {
                case IGNORE: {
                    return PathInfo.Status.DISCARDED;
                }
                case CREATE: {
                    out.mkParentDirs();
                    out.writeBytes(content, new NPathOption[0]);
                    return PathInfo.Status.CREATED;
                }
                case ASK: {
                    if (NAsk.of().setDefaultValue(true).forBoolean(NMsg.ofC("create %s ?", NText.ofStyled(CoreIOUtils.betterPath(out.toString()), NTextStyle.path()))).getBooleanValue().booleanValue()) {
                        out.mkParentDirs();
                        out.writeBytes(content, new NPathOption[0]);
                        return PathInfo.Status.CREATED;
                    }
                    return PathInfo.Status.DISCARDED;
                }
            }
            throw new NUnsupportedEnumException(doWhenNotExist);
        }
        if (Arrays.equals(old, content)) {
            return PathInfo.Status.DISCARDED;
        }
        switch (doWhenExist) {
            case IGNORE: {
                return PathInfo.Status.DISCARDED;
            }
            case OVERRIDE: {
                out.writeBytes(content, new NPathOption[0]);
                return PathInfo.Status.OVERRIDDEN;
            }
            case ASK: {
                if (NAsk.of().setDefaultValue(true).setRememberMeKey(rememberMeKey == null ? null : "Override." + rememberMeKey).forBoolean(NMsg.ofC("override %s ?", NText.ofStyled(CoreIOUtils.betterPath(out.toString()), NTextStyle.path()))).getBooleanValue().booleanValue()) {
                    out.writeBytes(content, new NPathOption[0]);
                    return PathInfo.Status.OVERRIDDEN;
                }
                return PathInfo.Status.DISCARDED;
            }
        }
        throw new NUnsupportedEnumException(doWhenExist);
    }

    public static Set<CopyOption> asCopyOptions(Set<NPathOption> noptions) {
        HashSet<CopyOption> joptions = new HashSet<CopyOption>();
        for (NPathOption option : noptions) {
            switch (option) {
                case REPLACE_EXISTING: {
                    joptions.add(StandardCopyOption.REPLACE_EXISTING);
                    break;
                }
                case ATOMIC: {
                    joptions.add(StandardCopyOption.ATOMIC_MOVE);
                    break;
                }
                case COPY_ATTRIBUTES: {
                    joptions.add(StandardCopyOption.COPY_ATTRIBUTES);
                }
            }
        }
        return joptions;
    }

    public static NStream<String> safeLines(final byte[] bytes) {
        return NStream.ofIterator(new Iterator<String>(){
            BufferedReader br;
            String line;

            @Override
            public boolean hasNext() {
                if (this.br == null) {
                    this.br = CoreIOUtils.bufferedReaderOf(bytes);
                }
                try {
                    this.line = null;
                    this.line = this.br.readLine();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return this.line != null;
            }

            @Override
            public String next() {
                return this.line;
            }
        });
    }

    public static BufferedReader bufferedReaderOf(byte[] bytes) {
        return new BufferedReader(new InputStreamReader(new ByteArrayInputStream(bytes)));
    }

    public static NExecOutput validateErr(NExecOutput err) {
        NSession session = NSession.of();
        if (err == null) {
            err = NExecOutput.ofStream(session.err());
        }
        if (err.getType() == NRedirectType.INHERIT) {
            err = NIO.of().isStderr(session.err()) ? NExecOutput.ofInherit() : NExecOutput.ofStream(session.err());
        } else if (err.getType() == NRedirectType.STREAM && NIO.of().isStderr(err.getStream())) {
            err = NExecOutput.ofStream(err.getStream());
        }
        return err;
    }

    public static NOptional<InputStream> openStream(URL u) {
        if (u == null) {
            return NOptional.ofNamedEmpty("null url");
        }
        InputStream in = null;
        try {
            in = DefaultNWebCli.prepareGlobalOpenStream(u);
        }
        catch (IOException e) {
            return NOptional.ofNamedEmpty("error stream for " + u);
        }
        if (in == null) {
            return NOptional.ofNamedEmpty("null stream for " + u);
        }
        return NOptional.of(in);
    }

    public static DefaultNContentMetadata defaultNutsInputSourceMetadata(InputStream is) {
        NAssert.requireNonNull(is);
        if (is instanceof NInputSource) {
            return new DefaultNContentMetadata(((NInputSource)((Object)is)).getMetaData());
        }
        return new DefaultNContentMetadata();
    }

    public static NExecInput validateIn(NExecInput in) {
        NSession session;
        if (in == null) {
            session = NSession.of();
            in = NExecInput.ofStream(session.in());
        }
        if (in.getType() == NRedirectType.INHERIT) {
            session = NSession.of();
            in = NIO.of().isStdin(session.in()) ? NExecInput.ofInherit() : NExecInput.ofStream(session.in());
        } else if (in.getType() == NRedirectType.STREAM && NIO.of().isStdin(in.getStream())) {
            in = NExecInput.ofInherit();
        }
        return in;
    }

    public static NExecOutput validateOut(NExecOutput out) {
        NSession session = NSession.of();
        if (out == null) {
            out = NExecOutput.ofStream(session.out());
        }
        if (out.getType() == NRedirectType.INHERIT) {
            out = NIO.of().isStdout(session.out()) ? NExecOutput.ofInherit() : NExecOutput.ofStream(session.out());
        } else if (out.getType() == NRedirectType.STREAM && NIO.of().isStdout(out.getStream())) {
            out = NExecOutput.ofStream(out.getStream());
        }
        return out;
    }

    public static String metadataToString(NContentMetadata md, Object caller) {
        NOptional<String> m2;
        String s;
        NOptional<NMsg> m = md.getMessage();
        if (m.isPresent()) {
            NMemoryPrintStream out = NPrintStream.ofMem(NTerminalMode.FILTERED);
            out.print(m.get());
            s = out.toString();
            if (!NBlankable.isBlank(s)) {
                return s;
            }
        }
        if ((m2 = md.getName()).isPresent() && !NBlankable.isBlank(s = m2.get())) {
            return s;
        }
        if (caller != null) {
            return caller.getClass().getSimpleName();
        }
        return "no-name";
    }

    public static NContentMetadata createContentMetadata(Object ... any) {
        DefaultNContentMetadata md = null;
        if (any != null) {
            for (Object o : any) {
                NContentMetadata md2 = null;
                if (o instanceof NContentMetadata) {
                    md2 = (NContentMetadata)o;
                } else if (o instanceof NContentMetadataProvider) {
                    md2 = ((NContentMetadataProvider)o).getMetaData();
                }
                if (md2 == null) continue;
                if (md == null) {
                    md = new DefaultNContentMetadata(md2);
                    continue;
                }
                if (md.getContentLength().isNotPresent()) {
                    md.setContentLength(md2.getContentLength().orNull());
                }
                if (md.getContentType().isNotPresent()) {
                    md.setContentType(md2.getContentType().orNull());
                }
                if (md.getMessage().isNotPresent()) {
                    md.setMessage(md2.getMessage().orNull());
                }
                if (md.getName().isNotPresent()) {
                    md.setName(md2.getName().orNull());
                }
                if (!md.getKind().isNotPresent()) continue;
                md.setKind(md2.getKind().orNull());
            }
        }
        if (md == null) {
            md = new DefaultNContentMetadata();
        }
        return md;
    }

    public static boolean isHttpUrl(String s) {
        if (s != null) {
            return (s = s.toLowerCase()).startsWith("http://") || s.startsWith("https://");
        }
        return false;
    }

    public static boolean isFileProtocol(String s) {
        if (s != null) {
            s = s.toLowerCase();
            return s.startsWith("file://");
        }
        return false;
    }

    public static String concatPath(String ... all) {
        StringBuilder sb = new StringBuilder();
        if (all != null) {
            for (String s : all) {
                boolean wasSlash;
                if (s != null) {
                    s = s.trim();
                }
                if (s.length() <= 0) continue;
                boolean newSlash = s.length() > 0 && s.charAt(0) == '/';
                boolean bl = wasSlash = sb.length() > 0 && sb.charAt(sb.length() - 1) == '/';
                if (sb.length() > 0) {
                    if (!wasSlash && !newSlash) {
                        sb.append("/");
                        sb.append(s);
                        continue;
                    }
                    sb.append(s);
                    continue;
                }
                sb.append(s);
            }
        }
        return sb.toString();
    }

    public static String ensureLeadingSlash(String s) {
        if (s.length() > 0) {
            if (!s.startsWith("/")) {
                return "/" + s;
            }
            return s;
        }
        return "/";
    }

    public static class CachedURL {
        String url;
        String path;
        String sha1;
        long lastModified;
        long size;
    }
}

