/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.urlpart;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.function.Predicate;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NIOUtils;
import net.thevpc.nuts.runtime.standalone.io.urlpart.URLPart;
import net.thevpc.nuts.runtime.standalone.io.urlpart.URLPartHelper;
import net.thevpc.nuts.runtime.standalone.io.util.ZipUtils;
import net.thevpc.nuts.text.NVisitResult;

class URLPartJar
extends URLPart {
    private URLPart base0;

    public URLPartJar(String path, Object obj, URLPart base0) {
        super(null, URLPart.Type.FS_FILE, path, obj);
        this.base0 = base0;
    }

    @Override
    public URLPart rootSibling(String path) {
        return new URLPartJar(path, this.obj, this.base0);
    }

    @Override
    public InputStream getInputStream() {
        ArrayList found = new ArrayList();
        URLPart pp = (URLPart)this.obj;
        ZipUtils.visitZipStream(pp.getInputStream(), (path, inputStream) -> {
            if (path.equals(this.path)) {
                found.add(new ByteArrayInputStream(NIOUtils.readBytes(inputStream)));
                return NVisitResult.TERMINATE;
            }
            return NVisitResult.CONTINUE;
        });
        if (found.isEmpty()) {
            return null;
        }
        return (InputStream)found.get(0);
    }

    @Override
    public URLPart[] getChildren(boolean includeFolders, boolean deep, Predicate<URLPart> filter) {
        URLPart[] uRLPartArray;
        block8: {
            InputStream is = this.base0.getInputStream();
            try {
                uRLPartArray = URLPartHelper.searchStream(is, s -> new URLPartJar((String)s, this.base0, this.base0), includeFolders, deep, filter);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new NIOException(e);
                }
            }
            is.close();
        }
        return uRLPartArray;
    }
}

