/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.urlpart;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.function.Function;
import java.util.function.Predicate;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.runtime.standalone.io.urlpart.URLPart;
import net.thevpc.nuts.runtime.standalone.io.util.InputStreamVisitor;
import net.thevpc.nuts.runtime.standalone.io.util.ZipUtils;
import net.thevpc.nuts.text.NVisitResult;

public class URLPartHelper {
    static URLPart[] searchStream(InputStream root, final Function<String, URLPart> factory, final boolean includeFolders, final boolean deep, final Predicate<URLPart> filter) {
        final ArrayList ff = new ArrayList();
        ZipUtils.visitZipStream(root, new InputStreamVisitor(){

            @Override
            public NVisitResult visit(String entry, InputStream inputStream) throws IOException {
                URLPart uuu;
                String y = entry;
                if (y.endsWith("/")) {
                    y = y.substring(0, y.length() - 1);
                }
                if (!(!deep && y.indexOf(47) >= 0 || y.length() <= 0 || !includeFolders && entry.endsWith("/") || (uuu = (URLPart)factory.apply(entry)) == null || filter != null && !filter.test(uuu))) {
                    ff.add(uuu);
                }
                return NVisitResult.CONTINUE;
            }
        });
        return ff.toArray(new URLPart[0]);
    }

    static URLPart[] searchFile(File root, final boolean includeFolders, boolean deep, final Predicate<URLPart> filter) {
        if (deep) {
            final ArrayList found = new ArrayList();
            try {
                Files.walkFileTree(root.toPath(), (FileVisitor<? super Path>)new FileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        if (includeFolders) {
                            URLPart url = URLPart.of(dir.toFile());
                            if (filter == null) {
                                found.add(url);
                            } else if (filter.test(url)) {
                                found.add(url);
                            }
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        URLPart url = URLPart.of(file.toFile());
                        if (filter == null) {
                            found.add(url);
                        } else if (filter.test(url)) {
                            found.add(url);
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                throw new NIOException(e);
            }
            return found.toArray(new URLPart[0]);
        }
        File[] listFiles = root.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname.isFile() || includeFolders && pathname.isDirectory()) {
                    return filter == null || filter.test(URLPart.of(pathname));
                }
                return false;
            }
        });
        if (listFiles == null) {
            return new URLPart[0];
        }
        URLPart[] found = new URLPart[listFiles.length];
        for (int j = 0; j < found.length; ++j) {
            found[j] = URLPart.of(listFiles[j]);
        }
        return found;
    }
}

