/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.terminal.history;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.thevpc.nuts.cmdline.NCmdLineHistory;
import net.thevpc.nuts.cmdline.NCmdLineHistoryEntry;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.runtime.standalone.io.terminal.history.NCmdLineHistoryEntryImpl;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NScorableContext;

public class NCmdLineHistoryImpl
implements NCmdLineHistory {
    private NPath path;
    private final List<NCmdLineHistoryEntry> entries = new ArrayList<NCmdLineHistoryEntry>();

    @Override
    public void load() {
        this.entries.clear();
        NAssert.requireNonNull(this.path, "path");
        if (this.path.exists()) {
            try (InputStream in = this.path.getInputStream();){
                this.load(in);
            }
            catch (IOException ex) {
                throw new NIOException(ex);
            }
        }
    }

    @Override
    public void save() {
        NAssert.requireNonNull(this.path, "path");
        this.path.mkParentDirs();
        try (OutputStream out = this.path.getOutputStream();){
            this.save(out);
        }
        catch (IOException ex) {
            throw new NIOException(ex);
        }
    }

    @Override
    public void load(InputStream in) {
        this.entries.clear();
        if (in != null) {
            try (BufferedReader out = new BufferedReader(new InputStreamReader(in));){
                String line = null;
                Instant instant = null;
                int index = 0;
                while ((line = out.readLine()) != null) {
                    if (line.length() <= 0) continue;
                    if (line.startsWith("#")) {
                        if (!line.startsWith("#at:")) continue;
                        instant = Instant.parse(line.substring("#at:".length()).trim());
                        continue;
                    }
                    this.entries.add(new NCmdLineHistoryEntryImpl(index, line, instant));
                }
            }
            catch (IOException ex) {
                throw new NIOException(ex);
            }
        }
    }

    @Override
    public void save(OutputStream outs) {
        try (PrintStream out = new PrintStream(outs);){
            for (NCmdLineHistoryEntry entry : this.entries) {
                out.println("#at:" + entry.getTime().toString());
                out.println(entry.getLine().replace("\n", "\\n").replace("\r", "\\r"));
            }
        }
    }

    @Override
    public NCmdLineHistory setPath(Path path) {
        this.path = path == null ? null : NPath.of(path);
        return this;
    }

    @Override
    public NCmdLineHistory setPath(File path) {
        this.path = path == null ? null : NPath.of(path);
        return this;
    }

    @Override
    public NCmdLineHistory setPath(NPath path) {
        this.path = path;
        return this;
    }

    @Override
    public NPath getPath() {
        return this.path;
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public void purge() {
        this.entries.clear();
        if (this.path.exists()) {
            this.path.delete();
        }
    }

    @Override
    public NCmdLineHistoryEntry getEntry(int index) {
        return this.entries.get(index);
    }

    @Override
    public ListIterator<NCmdLineHistoryEntry> iterator(int index) {
        return this.entries.listIterator(index);
    }

    @Override
    public void add(Instant time, String line) {
        this.entries.add(new NCmdLineHistoryEntryImpl(this.entries.size(), line, time));
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }
}

