/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.terminal;

import java.util.function.Supplier;
import net.thevpc.nuts.core.NConfirmationMode;
import net.thevpc.nuts.io.NAsk;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NAssert;

public class DefaultWriteTypeProcessor {
    private NMsg askMessage;
    private NMsg logMessage;
    private Supplier<RuntimeException> error;
    private NLog log;
    private NConfirmationMode writeType;

    public DefaultWriteTypeProcessor(NConfirmationMode writeType) {
        this.writeType = writeType;
    }

    public static DefaultWriteTypeProcessor of(NConfirmationMode writeType) {
        return new DefaultWriteTypeProcessor(writeType);
    }

    public DefaultWriteTypeProcessor ask(NMsg m) {
        NAssert.requireNonNull(m, "message");
        this.askMessage = m;
        return this;
    }

    public DefaultWriteTypeProcessor withLog(NLog log, NMsg m) {
        NAssert.requireNonNull(log, "log");
        NAssert.requireNonNull(m, "message");
        this.log = log;
        this.logMessage = m;
        return this;
    }

    public DefaultWriteTypeProcessor onError(Supplier<RuntimeException> error) {
        NAssert.requireNonNull(error, "error handler");
        this.error = error;
        return this;
    }

    private NMsg getValidAskMessage() {
        NAssert.requireNonNull(this.askMessage, "message");
        return this.askMessage;
    }

    private NMsg getValidLogMessage() {
        NAssert.requireNonNull(this.logMessage, "log message");
        return this.logMessage;
    }

    private Supplier<RuntimeException> getValidError() {
        NAssert.requireNonNull(this.error, "error handler");
        return this.error;
    }

    private NLog getValidLog() {
        NAssert.requireNonNull(this.log, "log");
        return this.log;
    }

    public boolean process() {
        switch (this.writeType) {
            case ERROR: {
                throw this.getValidError().get();
            }
            case ASK: {
                if (NAsk.of().forBoolean(this.getValidAskMessage()).setDefaultValue(false).getBooleanValue().booleanValue()) break;
                return false;
            }
            case NO: {
                this.getValidLog().log(this.getValidLogMessage().asFineAlert());
                return false;
            }
        }
        this.getValidLog().log(this.getValidLogMessage().asFineAlert());
        return true;
    }
}

