/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.terminal;

import java.io.BufferedReader;
import java.io.Console;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Scanner;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.io.NAsk;
import net.thevpc.nuts.io.NIO;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.io.NSystemTerminal;
import net.thevpc.nuts.io.NTerminal;
import net.thevpc.nuts.runtime.standalone.io.ask.DefaultNAsk;
import net.thevpc.nuts.runtime.standalone.io.terminal.AbstractNTerminal;
import net.thevpc.nuts.runtime.standalone.xtra.time.CProgressBar;
import net.thevpc.nuts.spi.NSystemTerminalBase;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;

public class DefaultNTerminalFromSystem
extends AbstractNTerminal {
    protected NPrintStream out;
    protected NPrintStream err;
    protected InputStream in;
    protected BufferedReader inReader;
    protected NSystemTerminalBase parent;
    protected CProgressBar progressBar;

    public DefaultNTerminalFromSystem(DefaultNTerminalFromSystem other) {
        this.parent = other.parent;
        this.in = other.in;
        this.inReader = other.inReader;
        this.setOut(other.out);
        this.setErr(other.err);
    }

    public DefaultNTerminalFromSystem(NSystemTerminalBase parent) {
        this.parent = parent;
    }

    public BufferedReader getReader() {
        if (this.inReader != null) {
            return this.inReader;
        }
        InputStream _in = this.getIn();
        if (_in != null) {
            this.inReader = new BufferedReader(new InputStreamReader(_in));
        }
        return this.inReader;
    }

    @Override
    public String readLine(NPrintStream out, NMsg message) {
        if (out == null) {
            out = this.out();
        }
        if (out == null) {
            out = NIO.of().stdout();
        }
        if (this.in == null && this.parent != null) {
            if (this.out == null) {
                return this.parent.readLine(out, message);
            }
            return this.parent.readLine(out, message);
        }
        out.print(message);
        out.flush();
        try {
            return this.getReader().readLine();
        }
        catch (IOException e) {
            throw new NIOException(e);
        }
    }

    @Override
    public char[] readPassword(NPrintStream out, NMsg prompt) {
        if (out == null) {
            out = this.out();
        }
        if (out == null) {
            out = NIO.of().stdout();
        }
        if (this.in == null && this.parent != null) {
            if (this.out == null) {
                return this.parent.readPassword(out, prompt);
            }
            return this.parent.readPassword(out, prompt);
        }
        InputStream in = this.getIn();
        Console cons = null;
        char[] passwd = null;
        if (in == null) {
            in = NIO.of().stdin();
        }
        if (in == NIO.of().stdin() && (cons = System.console()) != null) {
            String txt = NText.of(prompt).toString();
            passwd = cons.readPassword("%s", txt);
            if (passwd != null) {
                return passwd;
            }
            return null;
        }
        out.print(prompt);
        out.flush();
        Scanner s = new Scanner(in);
        return s.nextLine().toCharArray();
    }

    @Override
    public InputStream getIn() {
        if (this.in != null) {
            return this.in;
        }
        if (this.parent != null) {
            return this.parent.getIn();
        }
        return null;
    }

    @Override
    public void setIn(InputStream in) {
        this.in = in;
        this.inReader = null;
    }

    @Override
    public NPrintStream getOut() {
        NPrintStream o;
        NSystemTerminalBase p;
        if (this.out == null && (p = this.getParent()) != null && (o = p.getOut()) != null) {
            return o;
        }
        return this.out;
    }

    @Override
    public void setOut(NPrintStream out) {
        this.out = out;
    }

    @Override
    public NPrintStream getErr() {
        NPrintStream o;
        NSystemTerminalBase p;
        if (this.err == null && (p = this.getParent()) != null && (o = p.getErr()) != null) {
            return o;
        }
        return this.err;
    }

    @Override
    public void setErr(NPrintStream err) {
        this.err = err;
    }

    @Override
    public NTerminal copy() {
        DefaultNTerminalFromSystem r = new DefaultNTerminalFromSystem(this.parent);
        r.copyFrom(this);
        return r;
    }

    @Override
    public <T> NAsk<T> ask() {
        return new DefaultNAsk(this, this.out());
    }

    @Override
    public InputStream in() {
        return this.getIn();
    }

    @Override
    public NPrintStream out() {
        return this.getOut();
    }

    @Override
    public NPrintStream err() {
        return this.getErr();
    }

    @Override
    public NTerminal printProgress(float progress, NMsg message) {
        NSession session = NSession.of();
        if (session.isProgress()) {
            if (this.getParent() instanceof NSystemTerminal) {
                ((NSystemTerminal)this.getParent()).printProgress(progress, message);
            } else {
                this.getProgressBar().printProgress(Float.isNaN(progress) ? -1 : (int)(progress * 100.0f), NText.of(message), this.err());
            }
        }
        return this;
    }

    public NSystemTerminalBase getParent() {
        return this.parent;
    }

    public boolean isInOverridden() {
        return this.in != null;
    }

    public boolean isOutOverridden() {
        return this.out != null;
    }

    public boolean isErrOverridden() {
        return this.err != null;
    }

    private CProgressBar getProgressBar() {
        if (this.progressBar == null) {
            this.progressBar = CProgressBar.of();
        }
        return this.progressBar;
    }

    protected void copyFrom(DefaultNTerminalFromSystem other) {
        this.parent = other.parent;
        this.out = other.out;
        this.err = other.err;
        this.in = other.in;
        this.inReader = other.inReader;
    }
}

