/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.terminal;

import java.io.Console;
import java.io.InputStream;
import java.util.Scanner;
import net.thevpc.nuts.boot.NWorkspaceTerminalOptions;
import net.thevpc.nuts.cmdline.NCmdLineAutoCompleteResolver;
import net.thevpc.nuts.cmdline.NCmdLineHistory;
import net.thevpc.nuts.concurrent.NCachedValue;
import net.thevpc.nuts.core.NBootOptions;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NAnsiTermHelper;
import net.thevpc.nuts.io.NIO;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.io.NTerminalMode;
import net.thevpc.nuts.io.NonClosableInputStream;
import net.thevpc.nuts.io.NonClosablePrintStream;
import net.thevpc.nuts.runtime.standalone.io.printstream.NPrintStreamSystem;
import net.thevpc.nuts.runtime.standalone.io.terminal.CoreAnsiTermHelper;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceExt;
import net.thevpc.nuts.spi.NComponentScope;
import net.thevpc.nuts.spi.NScopeType;
import net.thevpc.nuts.spi.NSystemTerminalBase;
import net.thevpc.nuts.spi.NSystemTerminalBaseImpl;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NTerminalCmd;
import net.thevpc.nuts.text.NTextStyles;
import net.thevpc.nuts.time.NDuration;
import net.thevpc.nuts.util.NScorableContext;

@NComponentScope(value=NScopeType.PROTOTYPE)
public class DefaultNSystemTerminalBase
extends NSystemTerminalBaseImpl {
    public static final NDuration EXPIRY_30S = NDuration.ofSeconds(30L);
    NCachedValue<NSystemTerminalBase.Cursor> termCursor;
    NCachedValue<NSystemTerminalBase.Size> termSize;
    private Scanner scanner;
    private NTerminalMode outMode = NTerminalMode.FORMATTED;
    private NTerminalMode errMode = NTerminalMode.FORMATTED;
    private NPrintStream out;
    private NPrintStream err;
    private InputStream in;
    private NCmdLineHistory history;
    private String commandHighlighter;
    private NCmdLineAutoCompleteResolver commandAutoCompleteResolver;
    private Boolean preferConsole;

    public DefaultNSystemTerminalBase(NWorkspace workspace) {
    }

    @Override
    public int getScore(NScorableContext criteria) {
        NBootOptions options = NWorkspace.of().getBootOptions();
        NTerminalMode terminalMode = options.getTerminalMode().orElse(NTerminalMode.DEFAULT);
        NWorkspaceTerminalOptions bootStdFd = NWorkspaceExt.of().getModel().bootModel.getBootTerminal();
        if (terminalMode == NTerminalMode.DEFAULT) {
            terminalMode = options.getBot().orElse(false) != false || !bootStdFd.getFlags().contains("ansi") ? NTerminalMode.FILTERED : NTerminalMode.FORMATTED;
        }
        if (bootStdFd.getFlags().contains("tty")) {
            this.termCursor = NCachedValue.of(() -> CoreAnsiTermHelper.evalCursor()).setExpiry(EXPIRY_30S);
            this.termSize = NCachedValue.of(() -> CoreAnsiTermHelper.evalSize()).setExpiry(EXPIRY_30S);
        } else {
            this.termCursor = NCachedValue.of(() -> null).setExpiry(EXPIRY_30S);
            this.termSize = NCachedValue.of(() -> null).setExpiry(EXPIRY_30S);
        }
        this.out = new NPrintStreamSystem(new NonClosablePrintStream(bootStdFd.getOut()), null, null, bootStdFd.getFlags().contains("ansi"), this).setTerminalMode(terminalMode);
        this.err = new NPrintStreamSystem(new NonClosablePrintStream(bootStdFd.getErr()), null, null, bootStdFd.getFlags().contains("ansi"), this).setTerminalMode(terminalMode);
        this.in = new NonClosableInputStream(bootStdFd.getIn());
        this.scanner = new Scanner(this.in);
        return 10;
    }

    @Override
    public String readLine(NPrintStream out, NMsg message) {
        if (out == null) {
            out = this.getOut();
        }
        if (out == null) {
            out = NIO.of().stdout();
        }
        if (message != null) {
            out.print(message);
            out.flush();
        }
        return this.scanner.nextLine();
    }

    @Override
    public char[] readPassword(NPrintStream out, NMsg message) {
        if (out == null) {
            out = this.getOut();
        }
        if (out == null) {
            out = NIO.of().stdout();
        }
        if (message != null) {
            out.print(message);
            out.flush();
        }
        if (this.preferConsole == null) {
            Console c;
            if (NIO.of().isStdin(this.getIn()) && (c = System.console()) != null) {
                this.preferConsole = true;
            }
            if (this.preferConsole == null) {
                this.preferConsole = false;
            }
        }
        if (this.preferConsole.booleanValue()) {
            return System.console().readPassword();
        }
        return this.scanner.nextLine().toCharArray();
    }

    @Override
    public InputStream getIn() {
        return this.in;
    }

    @Override
    public NPrintStream getOut() {
        return this.out;
    }

    @Override
    public NPrintStream getErr() {
        return this.err;
    }

    @Override
    public NCmdLineAutoCompleteResolver getAutoCompleteResolver() {
        return this.commandAutoCompleteResolver;
    }

    @Override
    public boolean isAutoCompleteSupported() {
        return false;
    }

    @Override
    public NSystemTerminalBase setCommandAutoCompleteResolver(NCmdLineAutoCompleteResolver autoCompleteResolver) {
        this.commandAutoCompleteResolver = autoCompleteResolver;
        return this;
    }

    @Override
    public NCmdLineHistory getCommandHistory() {
        return this.history;
    }

    @Override
    public NSystemTerminalBase setCommandHistory(NCmdLineHistory history) {
        this.history = history;
        return this;
    }

    @Override
    public String getCommandHighlighter() {
        return this.commandHighlighter;
    }

    @Override
    public DefaultNSystemTerminalBase setCommandHighlighter(String commandHighlighter) {
        this.commandHighlighter = commandHighlighter;
        return this;
    }

    @Override
    public Object run(NTerminalCmd command, NPrintStream printStream) {
        switch (command.getName()) {
            case "get-cursor": {
                return this.termCursor.get();
            }
            case "get-size": {
                return this.termSize.get();
            }
        }
        String s = NAnsiTermHelper.of().command(command);
        if (s != null) {
            byte[] bytes = s.getBytes();
            printStream.writeRaw(bytes, 0, bytes.length);
            printStream.flush();
        }
        return null;
    }

    @Override
    public void setStyles(NTextStyles styles, NPrintStream printStream) {
        String s = NAnsiTermHelper.of().styled(styles);
        if (s != null) {
            byte[] bytes = s.getBytes();
            printStream.writeRaw(bytes, 0, bytes.length);
            printStream.flush();
        }
    }
}

