/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.terminal;

import net.thevpc.nuts.command.NExecCmd;
import net.thevpc.nuts.io.NExecInput;
import net.thevpc.nuts.spi.NSystemTerminalBase;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NLiteral;

public class CoreAnsiTermHelper {
    public static String tput(String str, long timeout) {
        return NExecCmd.of().system().addCommand("tput", str).failFast().getGrabbedOutOnlyString().trim();
    }

    public static String stty(String str, long timeout) {
        return NExecCmd.of().system().addCommand("stty", str).failFast().getGrabbedOutOnlyString().trim();
    }

    public static boolean isXTerm() {
        try {
            CoreAnsiTermHelper.tput("cols", 0L);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static NSystemTerminalBase.Size evalSize() {
        String[] u;
        String size = CoreAnsiTermHelper.evalCommand("bash", "-c", "echo $(tput lines) $(tput cols)");
        if (!NBlankable.isBlank(size) && (u = size.split(" ")).length >= 2) {
            Integer l = NLiteral.of(u[0]).asInt().orNull();
            Integer c = NLiteral.of(u[1]).asInt().orNull();
            if (c != null && l != null) {
                return new NSystemTerminalBase.Size(c, l);
            }
        }
        return null;
    }

    public static NSystemTerminalBase.Cursor evalCursor() {
        String c = CoreAnsiTermHelper.evalCommand("tput", "u7");
        if (c != null) {
            return null;
        }
        return null;
    }

    public static String evalCommand(String ... cmd) {
        try {
            String s = NExecCmd.of().system().setIn(NExecInput.ofNull()).addCommand(cmd).failFast().getGrabbedOutOnlyString().trim();
            if (!s.trim().isEmpty()) {
                return s.trim();
            }
            s = NExecCmd.of().system().addCommand(cmd).failFast().setSleepMillis(500L).getGrabbedOutOnlyString().trim();
            if (!s.trim().isEmpty()) {
                return s.trim();
            }
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }
}

