/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.printstream;

import java.io.OutputStream;
import net.thevpc.nuts.io.NContentMetadata;
import net.thevpc.nuts.io.NMemoryPrintStream;
import net.thevpc.nuts.io.NOutputTarget;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.io.NTerminalMode;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.util.NOptional;

public class OutputTargetExt
implements NOutputTarget {
    private OutputStream base;
    private NMsg sourceName;
    private NContentMetadata md;

    public OutputTargetExt(OutputStream base, NContentMetadata md0) {
        this.base = base;
        this.md = CoreIOUtils.createContentMetadata(md0, base);
    }

    @Override
    public OutputStream getOutputStream() {
        return this.base;
    }

    @Override
    public NContentMetadata getMetaData() {
        return this.md;
    }

    public NMsg getSourceName() {
        return this.sourceName;
    }

    public String toString() {
        NMemoryPrintStream out = NPrintStream.ofMem(NTerminalMode.FILTERED);
        NOptional<NMsg> m = this.getMetaData().getMessage();
        if (m.isPresent()) {
            out.print(m.get());
        } else if (this.sourceName != null) {
            out.print(NText.ofStyled(this.sourceName, NTextStyle.path()));
        } else {
            out.print((Object)this.getClass().getSimpleName(), NTextStyle.path());
        }
        return out.toString();
    }
}

