/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.printstream;

import java.io.IOException;
import java.io.OutputStream;
import net.thevpc.nuts.io.NContentMetadata;
import net.thevpc.nuts.io.NContentMetadataProvider;
import net.thevpc.nuts.io.NMemoryPrintStream;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.io.NTerminalMode;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.util.NOptional;

public class OutputStreamExt
extends OutputStream
implements NContentMetadataProvider {
    private OutputStream base;
    private NMsg sourceName;
    private NContentMetadata md;
    private boolean closeBase;
    private Runnable onClose;

    public OutputStreamExt(OutputStream base, NContentMetadata md0, boolean closeBase, Runnable onClose) {
        this.base = base;
        this.closeBase = closeBase;
        this.onClose = onClose;
        this.md = CoreIOUtils.createContentMetadata(md0, base);
    }

    @Override
    public NContentMetadata getMetaData() {
        return this.md;
    }

    @Override
    public void write(int b) throws IOException {
        this.base.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.base.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.base.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.base.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.closeBase) {
            this.base.close();
        }
        if (this.onClose != null) {
            this.onClose.run();
        }
    }

    public String toString() {
        NMemoryPrintStream out = NPrintStream.ofMem(NTerminalMode.FILTERED);
        NOptional<NMsg> m = this.getMetaData().getMessage();
        if (m.isPresent()) {
            out.print(m.get());
        } else if (this.sourceName != null) {
            out.print(NText.ofStyled(this.sourceName, NTextStyle.path()));
        } else {
            out.print((Object)this.getClass().getSimpleName(), NTextStyle.path());
        }
        return out.toString();
    }
}

