/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.printstream;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import net.thevpc.nuts.boot.NWorkspaceTerminalOptions;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.io.NTerminalMode;
import net.thevpc.nuts.runtime.standalone.io.printstream.NPrintStreamBase;
import net.thevpc.nuts.runtime.standalone.io.printstream.NPrintStreamFiltered;
import net.thevpc.nuts.runtime.standalone.io.printstream.NPrintStreamFormatted;
import net.thevpc.nuts.spi.NSystemTerminalBase;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NTerminalCmd;
import net.thevpc.nuts.util.NIllegalArgumentException;

public class NPrintStreamSystem
extends NPrintStreamBase {
    private final OutputStream out;
    private PrintStream base;

    public NPrintStreamSystem(OutputStream out, Boolean autoFlush, String encoding, Boolean ansi, NSystemTerminalBase term) {
        this(out, autoFlush, encoding, ansi, new NPrintStreamBase.Bindings(), term);
    }

    protected NPrintStreamSystem(OutputStream out, PrintStream base, Boolean autoFlush, NTerminalMode mode, NPrintStreamBase.Bindings bindings, NSystemTerminalBase term) {
        super(autoFlush == null || autoFlush != false, mode, bindings, term);
        this.getMetaData().setMessage(NMsg.ofStyledPath("<system-stream>"));
        this.out = out;
        this.base = base;
    }

    public PrintStream getBase() {
        return this.base;
    }

    public NPrintStreamSystem(OutputStream out, Boolean autoFlush, String encoding, Boolean ansi, NPrintStreamBase.Bindings bindings, NSystemTerminalBase term) {
        super(true, NPrintStreamSystem.resolveMode(out, ansi), bindings, term);
        this.getMetaData().setMessage(NMsg.ofStyledPath("<system-stream>"));
        this.out = out;
        if (out instanceof PrintStream) {
            PrintStream ps = (PrintStream)out;
            if (autoFlush == null && encoding == null) {
                this.base = ps;
            }
        }
        if (this.base == null) {
            try {
                this.base = encoding == null ? new PrintStream(out, autoFlush != null && autoFlush != false) : new PrintStream(out, autoFlush != null && autoFlush != false, encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    private static NTerminalMode resolveMode(OutputStream out, Boolean ansi) {
        if (ansi != null) {
            return ansi != false ? NTerminalMode.ANSI : NTerminalMode.INHERITED;
        }
        NWorkspaceTerminalOptions b = NWorkspace.of().getBootTerminal();
        if (b.getFlags().contains("ansi")) {
            return NTerminalMode.ANSI;
        }
        return NTerminalMode.INHERITED;
    }

    @Override
    public NPrintStream flush() {
        this.base.flush();
        return this;
    }

    @Override
    public void close() {
        if (this.getTerminalMode() == NTerminalMode.ANSI) {
            this.print("\u001b[0m".getBytes());
            this.flush();
        }
        this.base.close();
    }

    @Override
    public NPrintStream write(int b) {
        this.base.write(b);
        return this;
    }

    @Override
    public NPrintStream write(byte[] buf, int off, int len) {
        if (buf == null) {
            this.base.print("null");
        } else {
            this.base.write(buf, off, len);
        }
        return this;
    }

    @Override
    public NPrintStream writeRaw(byte[] buf, int off, int len) {
        if (buf == null) {
            this.base.print("null");
        } else {
            this.base.write(buf, off, len);
        }
        return this;
    }

    @Override
    public NPrintStream write(char[] buf, int off, int len) {
        if (buf == null) {
            this.base.print("null");
        } else {
            this.base.print(new String(buf, off, len));
        }
        return this;
    }

    @Override
    protected NPrintStream convertImpl(NTerminalMode other) {
        switch (other) {
            case FORMATTED: {
                return new NPrintStreamFormatted(this, this.bindings);
            }
            case FILTERED: {
                return new NPrintStreamFiltered(this, this.bindings);
            }
        }
        throw new NIllegalArgumentException(NMsg.ofC("unsupported %s -> %s", this.getTerminalMode(), other));
    }

    @Override
    public NPrintStream run(NTerminalCmd command) {
        switch (command.getName()) {
            default: 
        }
        return null;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.out;
    }
}

