/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.printstream;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.io.NTerminalMode;
import net.thevpc.nuts.runtime.standalone.io.printstream.NPrintStreamBase;
import net.thevpc.nuts.runtime.standalone.io.printstream.NPrintStreamFiltered;
import net.thevpc.nuts.runtime.standalone.io.printstream.NPrintStreamFormatted;
import net.thevpc.nuts.spi.NSystemTerminalBase;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NTerminalCmd;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.util.NIllegalArgumentException;

public class NPrintStreamRaw
extends NPrintStreamBase {
    protected OutputStream out;
    private PrintStream base;

    protected NPrintStreamRaw(OutputStream out, PrintStream base, Boolean autoFlush, NTerminalMode mode, NWorkspace workspace, NPrintStreamBase.Bindings bindings, NSystemTerminalBase term) {
        super(autoFlush == null || autoFlush != false, mode, bindings, term);
        this.getMetaData().setMessage(NMsg.ofNtf(NText.ofStyledPath("<raw-stream>")));
        this.out = out;
        this.base = base;
    }

    public NPrintStreamRaw(OutputStream out, Boolean autoFlush, String encoding, NPrintStreamBase.Bindings bindings, NSystemTerminalBase term) {
        this(out, null, autoFlush, encoding, bindings, term);
    }

    public NPrintStreamRaw(OutputStream out, NTerminalMode mode, Boolean autoFlush, String encoding, NPrintStreamBase.Bindings bindings, NSystemTerminalBase term) {
        super(true, mode == null ? NTerminalMode.INHERITED : mode, bindings, term);
        this.getMetaData().setMessage(NMsg.ofNtf(NText.ofStyledPath("<raw-stream>")));
        this.out = out;
        if (out instanceof PrintStream) {
            PrintStream ps = (PrintStream)out;
            if (autoFlush == null && encoding == null) {
                this.base = ps;
            }
        }
        if (this.base == null) {
            try {
                this.base = encoding == null ? new PrintStream(out, autoFlush != null && autoFlush != false) : new PrintStream(out, autoFlush != null && autoFlush != false, encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    public PrintStream getBase() {
        return this.base;
    }

    @Override
    public NPrintStream flush() {
        this.base.flush();
        return this;
    }

    @Override
    public void close() {
        if (this.getTerminalMode() == NTerminalMode.ANSI) {
            this.print("\u001b[0m".getBytes());
            this.flush();
        }
        this.base.close();
    }

    @Override
    public NPrintStream write(int b) {
        this.base.write(b);
        return this;
    }

    @Override
    public NPrintStream write(byte[] buf, int off, int len) {
        if (buf == null) {
            this.base.print("null");
        } else {
            this.base.write(buf, off, len);
        }
        return this;
    }

    @Override
    public NPrintStream write(char[] s, int off, int len) {
        if (s == null) {
            this.base.print("null");
        } else {
            this.base.print(new String(s, off, len));
        }
        return this;
    }

    @Override
    public NPrintStream run(NTerminalCmd command) {
        return this;
    }

    @Override
    protected NPrintStream convertImpl(NTerminalMode other) {
        switch (other) {
            case FORMATTED: {
                return new NPrintStreamFormatted(this, this.bindings);
            }
            case FILTERED: {
                return new NPrintStreamFiltered(this, this.bindings);
            }
            case ANSI: {
                if (this.getTerminalMode() != NTerminalMode.INHERITED) break;
                return this;
            }
        }
        throw new NIllegalArgumentException(NMsg.ofC("unsupported %s -> %s", this.getTerminalMode(), other));
    }

    @Override
    public OutputStream getOutputStream() {
        return this.asOutputStream();
    }

    @Override
    public NPrintStream writeRaw(byte[] buf, int off, int len) {
        if (buf == null) {
            this.base.print("null");
        } else {
            this.base.write(buf, off, len);
        }
        return this;
    }
}

