/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.printstream;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.time.temporal.Temporal;
import java.util.Date;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.DefaultNContentMetadata;
import net.thevpc.nuts.io.NContentMetadata;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.io.NTerminalMode;
import net.thevpc.nuts.runtime.standalone.io.printstream.AnsiNPrintStreamTerminalBase;
import net.thevpc.nuts.runtime.standalone.io.printstream.OutputStreamFromNPrintStream;
import net.thevpc.nuts.runtime.standalone.io.printstream.PrintStreamFromNPrintStream;
import net.thevpc.nuts.runtime.standalone.io.printstream.WriterFromNPrintStream;
import net.thevpc.nuts.spi.NSystemTerminalBase;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NObjectFormat;
import net.thevpc.nuts.text.NTerminalCmd;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextBuilder;
import net.thevpc.nuts.text.NTextList;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.text.NTextStyled;
import net.thevpc.nuts.text.NTextStyles;
import net.thevpc.nuts.text.NTextTransformConfig;
import net.thevpc.nuts.text.NTexts;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NUnsupportedOperationException;

public abstract class NPrintStreamBase
implements NPrintStream {
    private static String LINE_SEP = System.getProperty("line.separator");
    protected Bindings bindings;
    protected OutputStream osWrapper;
    protected PrintStream psWrapper;
    protected Writer writerWrapper;
    protected boolean autoFlash;
    private NTerminalMode mode;
    protected NSystemTerminalBase term;
    private DefaultNContentMetadata md = new DefaultNContentMetadata();

    public NPrintStreamBase(boolean autoFlash, NTerminalMode mode, Bindings bindings, NSystemTerminalBase term) {
        NAssert.requireNonNull(mode, "mode");
        bindings.setOrErr(this, mode);
        this.bindings = bindings;
        this.autoFlash = autoFlash;
        this.mode = mode;
        if (term == null && mode == NTerminalMode.ANSI) {
            term = new AnsiNPrintStreamTerminalBase(this);
        }
        this.term = term;
    }

    @Override
    public NContentMetadata getMetaData() {
        return this.md;
    }

    protected abstract NPrintStream convertImpl(NTerminalMode var1);

    public String toString() {
        return super.toString();
    }

    @Override
    public NPrintStream print(byte[] b) {
        return this.print(b, 0, b.length);
    }

    protected NPrintStream printParsed(NText b) {
        this.print(b.toString());
        return this;
    }

    private NPrintStream printNormalized(NText b) {
        if (b != null) {
            switch (b.type()) {
                case LIST: {
                    for (NText child : ((NTextList)b).getChildren()) {
                        this.printNormalized(child);
                    }
                    break;
                }
                case BUILDER: {
                    for (NText child : ((NTextBuilder)b).getChildren()) {
                        this.printNormalized(child);
                    }
                    break;
                }
                case PLAIN: {
                    this.printParsed(b);
                    break;
                }
                case STYLED: {
                    if (this.isNtf()) {
                        this.printParsed(b);
                        break;
                    }
                    NTextStyled s = (NTextStyled)b;
                    this.printNormalized(s.getChild());
                    break;
                }
                case COMMAND: {
                    if (!this.isNtf()) break;
                    this.printParsed(b);
                    break;
                }
                default: {
                    if (NWorkspace.get().isPresent()) {
                        throw new NUnsupportedOperationException();
                    }
                    throw new UnsupportedOperationException();
                }
            }
        }
        return this;
    }

    @Override
    public NPrintStream print(NText b) {
        if (b == null) {
            return this.printNull();
        }
        NText t = b;
        NText transformed = this.txt().transform(t, new NTextTransformConfig().setNormalize(true).setFlatten(true));
        this.printNormalized(transformed);
        return this;
    }

    @Override
    public NPrintStream print(NMsg b) {
        if (b == null) {
            return this.printNull();
        }
        this.print(this.txt().of(b));
        return this;
    }

    @Override
    public NPrintStream print(boolean b) {
        this.print(this.txt().of(b));
        return this;
    }

    @Override
    public NPrintStream print(Boolean b) {
        if (b == null) {
            return this.printNull();
        }
        if (this.isNtf()) {
            this.print(this.txt().of(b));
        } else {
            this.print(String.valueOf(b));
        }
        return this;
    }

    protected NTexts txt() {
        return NTexts.of();
    }

    @Override
    public NPrintStream print(char c) {
        this.print(String.valueOf(c));
        return this;
    }

    @Override
    public NPrintStream print(int i) {
        if (this.isNtf()) {
            this.print(String.valueOf(i));
        } else {
            this.print(this.txt().of(i));
        }
        return this;
    }

    @Override
    public NPrintStream print(long l) {
        this.print(this.txt().of(l));
        return this;
    }

    @Override
    public NPrintStream print(float f) {
        this.print(this.txt().of(Float.valueOf(f)));
        return this;
    }

    @Override
    public NPrintStream print(double d) {
        this.print(this.txt().of(d));
        return this;
    }

    @Override
    public NPrintStream print(Number d) {
        if (d == null) {
            return this.printNull();
        }
        this.print(this.txt().of(d));
        return this;
    }

    @Override
    public NPrintStream print(Temporal d) {
        if (d == null) {
            return this.printNull();
        }
        this.print(this.txt().of(d));
        return this;
    }

    @Override
    public NPrintStream print(Date d) {
        if (d == null) {
            return this.printNull();
        }
        this.print(this.txt().of(d));
        return this;
    }

    @Override
    public NPrintStream println(Number d) {
        this.print(d);
        this.println();
        return this;
    }

    @Override
    public NPrintStream println(Temporal d) {
        this.print(d);
        this.println();
        return this;
    }

    @Override
    public NPrintStream println(Date d) {
        this.print(d);
        this.println();
        return this;
    }

    @Override
    public NPrintStream print(char[] s) {
        if (s == null) {
            return this.printNull();
        }
        this.print(s, 0, s.length);
        return this;
    }

    @Override
    public NPrintStream print(Object obj) {
        if (obj == null) {
            return this.printNull();
        }
        if (obj instanceof CharSequence) {
            this.print((CharSequence)obj);
        } else if (obj instanceof Number) {
            this.print((Number)obj);
        } else if (obj instanceof Date) {
            this.print((Date)obj);
        } else if (obj instanceof Temporal) {
            this.print((Temporal)obj);
        } else if (obj instanceof NMsg) {
            this.print((NMsg)obj);
        } else if (obj instanceof NText) {
            this.print((NText)obj);
        } else if (obj instanceof char[]) {
            this.print((char[])obj);
        } else if (obj instanceof byte[]) {
            this.print((byte[])obj);
        } else {
            NObjectFormat.of().setValue(obj).print(this);
        }
        return this;
    }

    protected NPrintStream printNull() {
        return this.print("null");
    }

    @Override
    public NPrintStream println() {
        this.print(LINE_SEP);
        if (this.autoFlash) {
            this.flush();
        }
        return this;
    }

    @Override
    public NPrintStream println(boolean x) {
        this.print(x);
        this.println();
        return this;
    }

    @Override
    public NPrintStream println(char x) {
        this.print(x);
        this.println();
        return this;
    }

    @Override
    public NPrintStream println(NText b) {
        this.print(b);
        this.println();
        return this;
    }

    @Override
    public NPrintStream println(NMsg b) {
        this.println(this.txt().of(b));
        return this;
    }

    @Override
    public NPrintStream println(int x) {
        this.print(x);
        this.println();
        return this;
    }

    @Override
    public NPrintStream println(long x) {
        this.print(x);
        this.println();
        return this;
    }

    @Override
    public NPrintStream println(float x) {
        this.print(x);
        this.println();
        return this;
    }

    @Override
    public NPrintStream println(double x) {
        this.print(x);
        this.println();
        return this;
    }

    @Override
    public NPrintStream println(char[] x) {
        this.print(x);
        this.println();
        return this;
    }

    @Override
    public NPrintStream println(String x) {
        this.print(x);
        this.println();
        return this;
    }

    @Override
    public NPrintStream println(Object x) {
        this.print(x);
        this.println();
        return this;
    }

    @Override
    public NPrintStream resetLine() {
        this.run(NTerminalCmd.CLEAR_LINE);
        this.run(NTerminalCmd.MOVE_LINE_START);
        return this;
    }

    @Override
    public void close() {
        this.flush();
    }

    @Override
    public NPrintStream print(CharSequence csq) {
        this.print(csq, 0, csq.length());
        return this;
    }

    @Override
    public NPrintStream print(CharSequence csq, int start, int end) {
        int bufferLength = Math.min(4096, end - start);
        for (int i = start; i < end; i += bufferLength) {
            int e = Math.min(i + bufferLength, end);
            String s = csq.subSequence(i, e).toString();
            this.print(s);
        }
        return this;
    }

    @Override
    public NTerminalMode getTerminalMode() {
        return this.mode;
    }

    @Override
    public boolean isAutoFlash() {
        return this.autoFlash;
    }

    @Override
    public NPrintStream setTerminalMode(NTerminalMode other) {
        if (other == null || other == this.getTerminalMode()) {
            return this;
        }
        NPrintStreamBase o = this.bindings.get(other);
        if (o != null) {
            return o;
        }
        return this.convertImpl(other);
    }

    @Override
    public OutputStream asOutputStream() {
        if (this.osWrapper == null) {
            this.osWrapper = new OutputStreamFromNPrintStream(this);
        }
        return this.osWrapper;
    }

    @Override
    public PrintStream asPrintStream() {
        if (this.psWrapper == null) {
            this.psWrapper = new PrintStreamFromNPrintStream((OutputStreamFromNPrintStream)this.asOutputStream());
        }
        return this.psWrapper;
    }

    @Override
    public Writer asWriter() {
        if (this.writerWrapper == null) {
            this.writerWrapper = new WriterFromNPrintStream(this);
        }
        return this.writerWrapper;
    }

    @Override
    public boolean isNtf() {
        switch (this.getTerminalMode()) {
            case FORMATTED: 
            case FILTERED: {
                return true;
            }
        }
        return false;
    }

    @Override
    public NSystemTerminalBase getTerminal() {
        return this.term;
    }

    @Override
    public NPrintStream print(Object text, NTextStyle style) {
        return this.print(text, NTextStyles.of(style));
    }

    @Override
    public NPrintStream print(Object text, NTextStyles styles) {
        if (text != null) {
            NTexts txt = this.txt();
            if (styles == null || styles.size() == 0) {
                this.print(txt.of(text));
            } else {
                this.print(txt.ofStyled(txt.of(text), styles));
            }
        }
        return this;
    }

    @Override
    public NPrintStream print(String s) {
        if (s == null) {
            return this.printNull();
        }
        char[] chars = s.toCharArray();
        this.write(chars, 0, chars.length);
        return this;
    }

    @Override
    public NPrintStream print(byte[] buf, int off, int len) {
        return this.write(buf, off, len);
    }

    @Override
    public NPrintStream print(char[] buf, int off, int len) {
        return this.write(buf, off, len);
    }

    public static class Bindings {
        protected NPrintStreamBase raw;
        protected NPrintStreamBase filtered;
        protected NPrintStreamBase ansi;
        protected NPrintStreamBase inherited;
        protected NPrintStreamBase formatted;

        public void set(NPrintStreamBase o, NTerminalMode mode) {
            NAssert.requireNonNull(o, "terminal");
            NAssert.requireNonNull(mode, "mode");
            switch (mode) {
                case ANSI: {
                    this.ansi = o;
                    if (this.raw != null) break;
                    this.raw = this.ansi;
                    break;
                }
                case FILTERED: {
                    this.filtered = o;
                    break;
                }
                case FORMATTED: {
                    this.formatted = o;
                    break;
                }
                case INHERITED: {
                    this.inherited = o;
                    if (this.raw != null) break;
                    this.raw = this.ansi;
                    break;
                }
                case DEFAULT: {
                    this.raw = o;
                }
            }
        }

        public NPrintStreamBase get(NTerminalMode mode) {
            NAssert.requireNonNull(mode, "mode");
            switch (mode) {
                case FILTERED: {
                    return this.filtered;
                }
                case ANSI: {
                    return this.ansi;
                }
                case FORMATTED: {
                    return this.formatted;
                }
                case INHERITED: {
                    return this.inherited;
                }
                case DEFAULT: {
                    return this.raw;
                }
            }
            throw new IllegalArgumentException("unexpected");
        }

        public void setOrErr(NPrintStreamBase o, NTerminalMode mode) {
            this.setIfNull(o, mode, true);
        }

        public void setIfNull(NPrintStreamBase o, NTerminalMode mode, boolean err) {
            NAssert.requireNonNull(o, "terminal");
            NAssert.requireNonNull(mode, "mode");
            switch (mode) {
                case ANSI: {
                    if (this.ansi == null) {
                        this.ansi = o;
                        if (this.raw != null) break;
                        this.raw = this.ansi;
                        break;
                    }
                    if (!err) break;
                    throw new IllegalArgumentException("already bound " + mode);
                }
                case FILTERED: {
                    if (this.filtered == null) {
                        this.filtered = o;
                        break;
                    }
                    if (!err) break;
                    throw new IllegalArgumentException("already bound " + mode);
                }
                case FORMATTED: {
                    if (this.formatted == null) {
                        this.formatted = o;
                        break;
                    }
                    if (!err) break;
                    throw new IllegalArgumentException("already bound " + mode);
                }
                case INHERITED: {
                    if (this.inherited == null) {
                        this.inherited = o;
                        if (this.ansi == null) {
                            this.ansi = o;
                        }
                        if (this.raw != null) break;
                        this.raw = this.ansi;
                        break;
                    }
                    if (!err) break;
                    throw new IllegalArgumentException("already bound " + mode);
                }
                case DEFAULT: {
                    if (this.raw == null) {
                        this.raw = o;
                        break;
                    }
                    if (!err) break;
                    throw new IllegalArgumentException("already bound " + mode);
                }
            }
        }
    }
}

