/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.path.spi.htmlfs;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.thevpc.nuts.concurrent.NScoredCallable;
import net.thevpc.nuts.runtime.standalone.io.path.spi.htmlfs.AbstractHtmlfsParser;
import net.thevpc.nuts.text.NMsg;

public class ApacheReposHtmlfsParser
extends AbstractHtmlfsParser {
    @Override
    public NScoredCallable<List<String>> parseHtmlTomcat(byte[] bytes) {
        int expected = 0;
        try (BufferedReader br2 = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(bytes)));){
            String line = null;
            while ((line = br2.readLine()) != null) {
                if (line.contains("<!DOCTYPE HTML PUBLIC")) {
                    ++expected;
                    continue;
                }
                if (line.contains("<h1>Index of ")) {
                    ++expected;
                    continue;
                }
                if (!line.contains("<a href=\"?C=M;O=A\">Last modified</a>")) continue;
                ++expected;
            }
        }
        catch (Exception br2) {
            // empty catch block
        }
        if (expected < 2) {
            Supplier<NMsg> msg = () -> NMsg.ofInvalidValue("apache repo");
            return NScoredCallable.ofInvalid(msg);
        }
        ArrayList<String> found = new ArrayList<String>();
        Pattern pattern = Pattern.compile("<img src=\"/icons/[a-z.]+\" alt=\"\\[[a-zA-Z ]+]\"> +<a href=\"(?<href>[^\"]+)\">(?<hname>[^>]+)</a> +(?<d>[^ ]+) (?<h>[^ ]+) +(?<s>[^ ]+)");
        try (BufferedReader br = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(bytes)));){
            String line = null;
            while ((line = br.readLine()) != null) {
                Matcher m = pattern.matcher(line);
                if (!m.find()) continue;
                found.add(m.group("href"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.toSupported(1, found);
    }
}

