/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.path.spi;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.thevpc.nuts.artifact.NDependencyFilters;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.command.NSearchCmd;
import net.thevpc.nuts.concurrent.NScoredCallable;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NPathOption;
import net.thevpc.nuts.io.NPathPermission;
import net.thevpc.nuts.io.NPathType;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.runtime.standalone.extension.DefaultNClassLoader;
import net.thevpc.nuts.runtime.standalone.io.path.NCompressedPath;
import net.thevpc.nuts.runtime.standalone.io.path.NCompressedPathHelper;
import net.thevpc.nuts.runtime.standalone.io.path.spi.URLPath;
import net.thevpc.nuts.runtime.standalone.io.util.NPathParts;
import net.thevpc.nuts.runtime.standalone.xtra.expr.StringTokenizerUtils;
import net.thevpc.nuts.spi.NFormatSPI;
import net.thevpc.nuts.spi.NPathFactorySPI;
import net.thevpc.nuts.spi.NPathSPI;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextBuilder;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.text.NTexts;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NScorableContext;
import net.thevpc.nuts.util.NStream;

public class NResourcePath
implements NPathSPI {
    private final List<NId> ids;
    private String path;
    private String location;
    private boolean urlPathLookedUp = false;
    private URL[] urls = null;
    private NPath urlPath = null;
    private static String nResourceProtocol = "resource://";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NResourcePath(String path) {
        String idsStr;
        this.path = path;
        if (path.startsWith(nResourceProtocol + "(")) {
            int x2 = path.indexOf(41);
            if (x2 <= 0) throw new NIllegalArgumentException(NMsg.ofC("invalid path %s", path));
            idsStr = path.substring((nResourceProtocol + "(").length(), x2);
            this.location = path.substring(x2 + 1);
        } else {
            if (!path.startsWith(nResourceProtocol)) throw new NIllegalArgumentException(NMsg.ofC("invalid path %s", path));
            int x3 = path.indexOf(47, nResourceProtocol.length());
            if (x3 <= 0) throw new NIllegalArgumentException(NMsg.ofC("invalid path %s", path));
            idsStr = path.substring(nResourceProtocol.length(), x3);
            this.location = path.substring(x3);
        }
        this.ids = StringTokenizerUtils.splitSemiColon(idsStr).stream().map(x -> {
            if ((x = x.trim()).length() > 0) {
                return NId.get(x).get();
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected static String rebuildURL(String location, NId[] ids) {
        StringBuilder sb = new StringBuilder(nResourceProtocol);
        boolean complex = Arrays.stream(ids).map(Object::toString).anyMatch(x -> x.contains(";") || x.contains("/"));
        if (complex) {
            sb.append("(");
            sb.append(Arrays.stream(ids).map(Object::toString).collect(Collectors.joining(";")));
            sb.append(")");
        } else {
            sb.append(Arrays.stream(ids).map(Object::toString).collect(Collectors.joining(";")));
        }
        if (!location.startsWith("/")) {
            sb.append("/");
        }
        sb.append(location);
        return sb.toString();
    }

    protected static NText rebuildURL2(NText location, NId[] ids) {
        NTexts txt = NTexts.of();
        NTextBuilder sb = txt.ofBuilder();
        sb.append((Object)nResourceProtocol, NTextStyle.path());
        boolean complex = Arrays.stream(ids).map(Object::toString).anyMatch(x -> x.contains(";") || x.contains("/"));
        if (complex) {
            sb.append((Object)"(", NTextStyle.separator());
            sb.appendJoined(txt.ofStyled(";", NTextStyle.separator()), Arrays.asList(ids));
            sb.append((Object)")", NTextStyle.separator());
        } else {
            sb.appendJoined(txt.ofStyled(";", NTextStyle.separator()), Arrays.asList(ids));
        }
        if (!location.filteredText().startsWith("/")) {
            sb.append((Object)"/", NTextStyle.path());
        }
        sb.append(location);
        return sb.build();
    }

    public NPath toURLPath() {
        if (!this.urlPathLookedUp) {
            this.urlPathLookedUp = true;
            try {
                URL resource;
                String loc = this.location;
                ClassLoader resultClassLoader = NSearchCmd.of().addIds(this.ids.toArray(new NId[0])).setLatest(true).setDependencyFilter(NDependencyFilters.of().byRunnable()).getResultClassLoader();
                this.urls = ((DefaultNClassLoader)resultClassLoader).getURLs();
                if (loc.length() > 1 && loc.startsWith("/")) {
                    loc = loc.substring(1);
                }
                if ((resource = resultClassLoader.getResource(loc)) != null) {
                    this.urlPath = NPath.of(resource);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.urlPath;
    }

    @Override
    public NStream<NPath> list(NPath basePath) {
        return this.toURLPath().stream();
    }

    @Override
    public NFormatSPI formatter(NPath basePath) {
        return new MyPathFormat(this);
    }

    @Override
    public String getName(NPath basePath) {
        String loc = this.getLocation(basePath);
        return loc == null ? "" : Paths.get(loc, new String[0]).getFileName().toString();
    }

    @Override
    public String getProtocol(NPath basePath) {
        return "resource";
    }

    @Override
    public NPath resolve(NPath basePath, String path) {
        return NPath.of(new NResourcePath(NResourcePath.rebuildURL(NPath.of(this.location).resolve(path).toString(), this.ids.toArray(new NId[0]))));
    }

    @Override
    public NPath resolveSibling(NPath basePath, String path) {
        return NPath.of(new NResourcePath(NResourcePath.rebuildURL(NPath.of(this.location).resolveSibling(path).toString(), this.ids.toArray(new NId[0]))));
    }

    @Override
    public NPath toCompressedForm(NPath basePath) {
        return new NCompressedPath(basePath, new NResourceCompressedPath());
    }

    @Override
    public NOptional<URL> toURL(NPath basePath) {
        NPath up = this.toURLPath();
        if (up != null) {
            return up.toURL();
        }
        throw new NIOException(NMsg.ofC("unable to resolve url from %s", this.toString()));
    }

    @Override
    public NOptional<Path> toPath(NPath basePath) {
        NPath up = this.toURLPath();
        if (up != null) {
            return up.toPath();
        }
        throw new NIOException(NMsg.ofC("unable to resolve file from %s", this.toString()));
    }

    @Override
    public NPathType getType(NPath basePath) {
        NPath u = this.toURLPath();
        if (u != null) {
            return u.type();
        }
        return NPathType.NOT_FOUND;
    }

    @Override
    public boolean isLocal(NPath basePath) {
        NPath u = this.toURLPath();
        return u != null && u.isLocal();
    }

    @Override
    public boolean exists(NPath basePath) {
        NPath up = this.toURLPath();
        if (up == null) {
            return false;
        }
        return up.exists();
    }

    @Override
    public long getContentLength(NPath basePath) {
        NPath up = this.toURLPath();
        if (up == null) {
            return -1L;
        }
        return up.getContentLength();
    }

    @Override
    public String getContentEncoding(NPath basePath) {
        NPath up = this.toURLPath();
        if (up != null) {
            return up.contentEncoding();
        }
        return null;
    }

    @Override
    public String getContentType(NPath basePath) {
        NPath up = this.toURLPath();
        if (up != null) {
            return up.getContentType();
        }
        return null;
    }

    @Override
    public String getCharset(NPath basePath) {
        NPath up = this.toURLPath();
        if (up != null) {
            return up.getCharset();
        }
        return null;
    }

    @Override
    public String getLocation(NPath basePath) {
        return this.location;
    }

    @Override
    public InputStream getInputStream(NPath basePath, NPathOption ... options) {
        NPath up = this.toURLPath();
        if (up == null) {
            throw new NIOException(NMsg.ofC("unable to resolve input stream %s", this.toString()));
        }
        return up.getInputStream();
    }

    @Override
    public OutputStream getOutputStream(NPath basePath, NPathOption ... options) {
        NPath up = this.toURLPath();
        if (up == null) {
            throw new NIOException(NMsg.ofC("unable to resolve output stream %s", this.toString()));
        }
        return up.getOutputStream();
    }

    @Override
    public void delete(NPath basePath, boolean recurse) {
        NPath up = this.toURLPath();
        if (up == null) {
            throw new NIOException(NMsg.ofC("unable to delete %s", this.toString()));
        }
        up.delete(recurse);
    }

    @Override
    public void mkdir(boolean parents, NPath basePath) {
        NPath up = this.toURLPath();
        if (up == null) {
            throw new NIOException(NMsg.ofC("unable to mkdir %s", this.toString()));
        }
        up.mkdir(parents);
    }

    @Override
    public Instant getLastModifiedInstant(NPath basePath) {
        NPath up = this.toURLPath();
        if (up == null) {
            return null;
        }
        return up.getLastModifiedInstant();
    }

    @Override
    public Instant getLastAccessInstant(NPath basePath) {
        NPath up = this.toURLPath();
        return up != null ? up.getLastAccessInstant() : null;
    }

    @Override
    public Instant getCreationInstant(NPath basePath) {
        NPath up = this.toURLPath();
        return up != null ? up.getCreationInstant() : null;
    }

    @Override
    public NPath getParent(NPath basePath) {
        String ppath = URLPath.getURLParentPath(this.location);
        if (ppath == null) {
            return null;
        }
        return NPath.of(NResourcePath.rebuildURL(ppath, this.ids.toArray(new NId[0])));
    }

    @Override
    public NPath toAbsolute(NPath basePath, NPath rootPath) {
        return basePath;
    }

    @Override
    public NPath normalize(NPath basePath) {
        return basePath;
    }

    @Override
    public boolean isAbsolute(NPath basePath) {
        return true;
    }

    @Override
    public String getOwner(NPath basePath) {
        NPath up = this.toURLPath();
        return up != null ? up.owner() : null;
    }

    @Override
    public String getGroup(NPath basePath) {
        NPath up = this.toURLPath();
        return up != null ? up.group() : null;
    }

    @Override
    public Set<NPathPermission> getPermissions(NPath basePath) {
        NPath up = this.toURLPath();
        return up != null ? up.getPermissions() : new LinkedHashSet<NPathPermission>();
    }

    @Override
    public void setPermissions(NPath basePath, NPathPermission ... permissions) {
    }

    @Override
    public void addPermissions(NPath basePath, NPathPermission ... permissions) {
    }

    @Override
    public void removePermissions(NPath basePath, NPathPermission ... permissions) {
    }

    @Override
    public Boolean isName(NPath basePath) {
        return false;
    }

    @Override
    public Integer getNameCount(NPath basePath) {
        String location = this.getLocation(basePath);
        if (NBlankable.isBlank(location)) {
            return 0;
        }
        return NPath.of(location).getNameCount();
    }

    @Override
    public Boolean isRoot(NPath basePath) {
        String loc = this.getLocation(basePath);
        if (NBlankable.isBlank(loc)) {
            return false;
        }
        switch (loc) {
            case "/": 
            case "\\\\": {
                return true;
            }
        }
        return NPath.of(loc).isRoot();
    }

    @Override
    public NPath getRoot(NPath basePath) {
        if (this.isRoot(basePath).booleanValue()) {
            return basePath;
        }
        return basePath.getParent().getRoot();
    }

    @Override
    public NStream<NPath> walk(NPath basePath, int maxDepth, NPathOption[] options) {
        return this.toURLPath().walk(maxDepth, options);
    }

    @Override
    public NPath subpath(NPath basePath, int beginIndex, int endIndex) {
        return NPath.of(new NResourcePath(NResourcePath.rebuildURL(NPath.of(this.location).subpath(beginIndex, endIndex).toString(), this.ids.toArray(new NId[0]))));
    }

    @Override
    public List<String> getNames(NPath basePath) {
        return NPath.of(this.location).getNames();
    }

    @Override
    public boolean moveTo(NPath basePath, NPath other, NPathOption ... options) {
        throw new NIOException(NMsg.ofC("unable to move %s", this));
    }

    public int hashCode() {
        return Objects.hash(this.path);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NResourcePath that = (NResourcePath)o;
        return this.urlPathLookedUp == that.urlPathLookedUp && Objects.equals(this.path, that.path) && Objects.equals(this.ids, that.ids) && Objects.equals(this.location, that.location) && Objects.equals(this.urlPath, that.urlPath);
    }

    @Override
    public String toString() {
        return String.valueOf(this.path);
    }

    private static class MyPathFormat
    implements NFormatSPI {
        private NResourcePath p;

        public MyPathFormat(NResourcePath p) {
            this.p = p;
        }

        @Override
        public String getName() {
            return "path";
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public NText asFormattedString() {
            String path = this.p.path;
            NTexts text = NTexts.of();
            NTextBuilder tb = text.ofBuilder();
            tb.append((Object)"resource://", NTextStyle.primary1());
            if (path.startsWith("resource://(")) {
                tb.append((Object)"(", NTextStyle.separator());
                int x = path.indexOf(41);
                if (x <= 0) return text.of(path);
                String idsStr = path.substring("resource://(".length(), x);
                tb.appendJoined(NText.ofStyled(";", NTextStyle.separator()), StringTokenizerUtils.splitSemiColon(idsStr).stream().map(xi -> {
                    if (!(xi = xi.trim()).isEmpty()) {
                        NId pp = NId.get(xi).get();
                        if (pp == null) {
                            return xi;
                        }
                        return pp;
                    }
                    return null;
                }).filter(Objects::nonNull).collect(Collectors.toList()));
                tb.append((Object)")", NTextStyle.separator());
                tb.append((Object)path.substring(x + 1), NTextStyle.path());
                return tb.build();
            } else {
                if (!path.startsWith("resource://")) return text.of(path);
                int x = path.indexOf(47, "resource://".length());
                if (x <= 0) return text.of(path);
                String sid = path.substring("resource://".length(), x);
                NId ii = NId.get(sid).get();
                if (ii == null) {
                    tb.append(sid);
                } else {
                    tb.append(ii);
                }
                tb.append((Object)path.substring(x), NTextStyle.path());
            }
            return tb.build();
        }

        @Override
        public void print(NPrintStream out) {
            out.print(this.asFormattedString());
        }

        @Override
        public boolean configureFirst(NCmdLine cmdLine) {
            return false;
        }
    }

    private class NResourceCompressedPath
    implements NCompressedPathHelper {
        private NResourceCompressedPath() {
        }

        @Override
        public NText toCompressedString(NPath base) {
            return NResourcePath.rebuildURL2(NPathParts.compressPath(NResourcePath.this.location), (NId[])NResourcePath.this.ids.stream().map(x -> NId.get(x.getArtifactId()).get()).toArray(NId[]::new));
        }
    }

    public static class NResourceFactory
    implements NPathFactorySPI {
        @Override
        public NScoredCallable<NPathSPI> createPath(String path, String protocol, ClassLoader classLoader) {
            try {
                if (path.startsWith("resource:")) {
                    return NScoredCallable.of(10, () -> new NResourcePath(path));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        @Override
        public int getScore(NScorableContext context) {
            String path = (String)context.getCriteria();
            if (path.startsWith("resource:")) {
                return 10;
            }
            return -1;
        }
    }
}

