/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.path.spi;

import java.util.Stack;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElements;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NPathOption;
import net.thevpc.nuts.text.NTreeVisitResult;
import net.thevpc.nuts.text.NTreeVisitor;
import net.thevpc.nuts.util.NIteratorBase;
import net.thevpc.nuts.util.NStream;

public class NPathSPIHelper {
    public static NStream<NPath> walk(NPath basePath, int maxDepth, NPathOption[] options) {
        boolean noMax = maxDepth <= 0 || maxDepth == Integer.MAX_VALUE;
        NPathIterator it = new NPathIterator(basePath, noMax, maxDepth);
        return NStream.ofIterator(it);
    }

    public static void walkDfs(NPath basePath, NTreeVisitor<NPath> visitor, int maxDepth, NPathOption ... options) {
        boolean noMax = maxDepth <= 0 || maxDepth == Integer.MAX_VALUE;
        Stack<Data> stack = new Stack<Data>();
        stack.push(new Data(basePath, 0, true));
        while (!stack.isEmpty()) {
            Data i = (Data)stack.peek();
            if (i.folder) {
                NTreeVisitResult r;
                if (!i.visited) {
                    i.visited = true;
                    r = visitor.preVisitDirectory(i.p);
                    switch (r) {
                        case TERMINATE: {
                            return;
                        }
                        case SKIP_SUBTREE: {
                            break;
                        }
                        case SKIP_SIBLINGS: 
                        case CONTINUE: {
                            if (!noMax && i.depth >= maxDepth) break;
                            for (NPath c : i.p.stream()) {
                                stack.push(new Data(c, i.depth + 1, c.isDirectory()));
                            }
                            break;
                        }
                    }
                    continue;
                }
                stack.pop();
                r = visitor.postVisitDirectory(i.p, null);
                switch (r) {
                    case TERMINATE: {
                        return;
                    }
                    case SKIP_SUBTREE: {
                        break;
                    }
                }
                continue;
            }
            stack.pop();
        }
    }

    private static class NPathIterator
    extends NIteratorBase<NPath> {
        private final boolean noMax;
        private final int maxDepth;
        private final NPath basePath;
        Stack<Data> stack;

        public NPathIterator(NPath basePath, boolean noMax, int maxDepth) {
            this.noMax = noMax;
            this.maxDepth = maxDepth;
            this.basePath = basePath;
            this.stack = new Stack();
            this.stack.push(new Data(basePath, 0, basePath.isDirectory()));
        }

        @Override
        public NElement describe() {
            return NElement.ofObjectBuilder().name("ScanPath").set("path", NElements.of().toElement(this.basePath)).set("maxDepth", this.maxDepth).build();
        }

        @Override
        public boolean hasNext() {
            return !this.stack.isEmpty();
        }

        @Override
        public NPath next() {
            Data i = this.stack.pop();
            if (i.folder && (this.noMax || i.depth < this.maxDepth)) {
                for (NPath c : i.p.stream()) {
                    this.stack.push(new Data(c, i.depth + 1, c.isDirectory()));
                }
            }
            return i.p;
        }
    }

    private static class Data {
        NPath p;
        int depth;
        boolean folder;
        boolean visited;

        public Data(NPath p, int depth, boolean folder) {
            this.p = p;
            this.depth = depth;
            this.folder = folder;
        }
    }
}

