/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.path.spi;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.thevpc.nuts.runtime.standalone.io.path.spi.NPathPart;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NIllegalArgumentException;

public class NPathPartList
implements Iterable<NPathPart> {
    private List<NPathPart> list = new ArrayList<NPathPart>();

    public NPathPartList(List<NPathPart> list) {
        for (int i = 0; i < list.size(); ++i) {
            NPathPart p = list.get(i);
            if (!(p.isName() ? i > 0 : p.isTrailingSeparator() && i != list.size() - 1)) continue;
            throw new NIllegalArgumentException(NMsg.ofC("invalid part %s at %i", p, i));
        }
        this.list.addAll(list);
    }

    public NPathPartList concat(NPathPartList other) {
        return new NPathPartList(this.concat(this.list, other.list));
    }

    private List<NPathPart> concat(List<NPathPart> a, List<NPathPart> b) {
        a = new ArrayList<NPathPart>(a);
        if ((b = new ArrayList<NPathPart>(b)).isEmpty()) {
            return a;
        }
        if (a.isEmpty()) {
            return b;
        }
        if (!a.get(a.size() - 1).isTrailingSeparator()) {
            if (b.get(0).isSeparated()) {
                a.addAll(b);
                return a;
            }
            if (b.get(0).isName()) {
                NPathPart p = b.get(0);
                p = new NPathPart(File.separator, p.getName());
                b.set(0, p);
                a.addAll(b);
                return a;
            }
            return a;
        }
        if (a.size() == 1) {
            if (b.get(0).isSeparated()) {
                return b;
            }
            if (b.get(0).isName()) {
                NPathPart p = b.get(0);
                p = new NPathPart(a.get(0).getSeparator(), p.getName());
                b.set(0, p);
                return b;
            }
            return a;
        }
        if (b.get(0).isSeparated()) {
            a.remove(0);
            a.addAll(b);
            return a;
        }
        if (b.get(0).isName()) {
            NPathPart p = b.get(0);
            p = new NPathPart(a.get(0).getSeparator(), p.getName());
            b.set(0, p);
            a.remove(0);
            a.addAll(b);
            return a;
        }
        return a;
    }

    public int size() {
        return this.list.size();
    }

    public NPathPart get(int i) {
        if (i < 0) {
            return this.list.get(this.list.size() + i);
        }
        return this.list.get(i);
    }

    public NPathPart last() {
        return this.list.get(this.list.size() - 1);
    }

    public NPathPart first() {
        return this.list.get(0);
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public String toString() {
        return this.list.stream().map(NPathPart::toString).collect(Collectors.joining());
    }

    @Override
    public Iterator<NPathPart> iterator() {
        return this.list.iterator();
    }

    public NPathPartList subList(int beginIndex, int endIndex) {
        return new NPathPartList(this.list.subList(beginIndex, endIndex));
    }

    public List<String> toStringList() {
        return this.stream().map(NPathPart::getName).collect(Collectors.toList());
    }

    public String[] toStringArray() {
        return (String[])this.stream().map(NPathPart::getName).toArray(String[]::new);
    }

    public Stream<NPathPart> stream() {
        return this.list.stream();
    }
}

