/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.path.spi;

import java.util.Objects;

public class NPathPart {
    private final String separator;
    private final String name;

    public NPathPart(String prefixSep, String name) {
        if (name == null || prefixSep == null) {
            throw new IllegalArgumentException("null name or prefix");
        }
        if (name.isEmpty() && prefixSep.isEmpty()) {
            throw new IllegalArgumentException("empty part");
        }
        this.separator = prefixSep;
        this.name = name;
    }

    public String getSeparator() {
        return this.separator;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.separator + this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NPathPart part = (NPathPart)o;
        return Objects.equals(this.separator, part.separator) && Objects.equals(this.name, part.name);
    }

    public boolean isSeparated() {
        return !this.separator.isEmpty();
    }

    public boolean isSeparatedName() {
        return !this.name.isEmpty() && !this.separator.isEmpty();
    }

    public boolean isEmpty() {
        return this.name.isEmpty() && this.separator.isEmpty();
    }

    public boolean isName() {
        return !this.name.isEmpty() && this.separator.isEmpty();
    }

    public boolean isTrailingSeparator() {
        return this.name.isEmpty() && !this.separator.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.separator, this.name);
    }
}

