/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.path.spi;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NPathOption;
import net.thevpc.nuts.io.NPathPermission;
import net.thevpc.nuts.io.NPathType;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.runtime.standalone.io.path.spi.URLPath;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.spi.NFormatSPI;
import net.thevpc.nuts.spi.NPathSPI;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NStream;

public class InvalidFilePath
implements NPathSPI {
    private final String value;
    private final NWorkspace workspace;

    public InvalidFilePath(String value, NWorkspace workspace) {
        this.value = value == null ? "" : value;
        this.workspace = workspace;
    }

    @Override
    public NStream<NPath> list(NPath basePath) {
        return NStream.ofEmpty();
    }

    @Override
    public NFormatSPI formatter(NPath basePath) {
        return new MyPathFormat(this);
    }

    @Override
    public String getName(NPath basePath) {
        List<String> pa = this.asPathArray();
        if (pa.size() == 0) {
            return "";
        }
        return pa.get(pa.size() - 1);
    }

    @Override
    public NPathType getType(NPath basePath) {
        return NPathType.NOT_FOUND;
    }

    @Override
    public String getProtocol(NPath basePath) {
        return "";
    }

    public NWorkspace getWorkspace() {
        return this.workspace;
    }

    @Override
    public NPath resolve(NPath basePath, String path) {
        String b = this.value;
        if (b.endsWith("/") || b.endsWith("\\")) {
            return NPath.of(b + path);
        }
        return NPath.of(b + "/" + path);
    }

    @Override
    public NPath resolveSibling(NPath basePath, String path) {
        if (path == null || path.isEmpty()) {
            return this.getParent(basePath);
        }
        if (this.isRoot(basePath).booleanValue()) {
            return NPath.of("/" + path);
        }
        return this.getParent(basePath).resolve(path);
    }

    @Override
    public NPath toCompressedForm(NPath basePath) {
        return null;
    }

    @Override
    public NOptional<URL> toURL(NPath basePath) {
        try {
            if (URLPath.MOSTLY_URL_PATTERN.matcher(this.value).matches()) {
                return NOptional.of(CoreIOUtils.urlOf(this.value));
            }
            return NOptional.of(CoreIOUtils.urlOf("file:" + this.value));
        }
        catch (Exception e) {
            return NOptional.ofNamedError(NMsg.ofC("not an url %s", this.value));
        }
    }

    @Override
    public NOptional<Path> toPath(NPath basePath) {
        try {
            return NOptional.of(Paths.get(this.value, new String[0]));
        }
        catch (Exception ex) {
            return NOptional.ofNamedError(NMsg.ofC("not an path %s", this.value));
        }
    }

    @Override
    public boolean exists(NPath basePath) {
        return false;
    }

    @Override
    public long getContentLength(NPath basePath) {
        return -1L;
    }

    @Override
    public String getContentEncoding(NPath basePath) {
        return null;
    }

    @Override
    public String getContentType(NPath basePath) {
        return null;
    }

    @Override
    public String getCharset(NPath basePath) {
        return null;
    }

    @Override
    public String getLocation(NPath basePath) {
        return this.value;
    }

    @Override
    public InputStream getInputStream(NPath basePath, NPathOption ... options) {
        throw new NIOException(NMsg.ofC("path not found %s", this));
    }

    @Override
    public OutputStream getOutputStream(NPath basePath, NPathOption ... options) {
        throw new NIOException(NMsg.ofC("path not found %s", this));
    }

    @Override
    public void delete(NPath basePath, boolean recurse) {
        throw new NIOException(NMsg.ofC("unable to delete path %s", this));
    }

    @Override
    public void mkdir(boolean parents, NPath basePath) {
        throw new NIOException(NMsg.ofC("unable to create folder out of regular file %s", this));
    }

    @Override
    public Instant getLastModifiedInstant(NPath basePath) {
        return null;
    }

    @Override
    public Instant getLastAccessInstant(NPath basePath) {
        return null;
    }

    @Override
    public Instant getCreationInstant(NPath basePath) {
        return null;
    }

    @Override
    public NPath getParent(NPath basePath) {
        if (this.isRoot(basePath).booleanValue()) {
            return null;
        }
        StringBuilder sb = new StringBuilder(this.value);
        while (sb.length() > 0 && (sb.charAt(sb.length() - 1) == '/' || sb.charAt(sb.length() - 1) == '\\')) {
            sb.delete(sb.length() - 1, sb.length());
        }
        int x = this.value.lastIndexOf(47);
        int y = this.value.lastIndexOf(92);
        if (y < x && y >= 0) {
            x = y;
        }
        if (x >= 0) {
            return NPath.of(sb.substring(0, x));
        }
        return null;
    }

    @Override
    public NPath toAbsolute(NPath basePath, NPath rootPath) {
        return basePath;
    }

    @Override
    public NPath normalize(NPath basePath) {
        return basePath;
    }

    @Override
    public boolean isAbsolute(NPath basePath) {
        return false;
    }

    @Override
    public String getOwner(NPath basePath) {
        return null;
    }

    @Override
    public String getGroup(NPath basePath) {
        return null;
    }

    @Override
    public Set<NPathPermission> getPermissions(NPath basePath) {
        LinkedHashSet p = new LinkedHashSet();
        return Collections.unmodifiableSet(p);
    }

    @Override
    public void setPermissions(NPath basePath, NPathPermission ... permissions) {
    }

    @Override
    public void addPermissions(NPath basePath, NPathPermission ... permissions) {
    }

    @Override
    public void removePermissions(NPath basePath, NPathPermission ... permissions) {
    }

    @Override
    public Boolean isName(NPath basePath) {
        List<String> pa = this.asPathArray();
        if (pa.size() == 0) {
            return true;
        }
        if (pa.size() > 1) {
            return false;
        }
        String v = pa.get(0);
        switch (v) {
            case "/": 
            case "\\": 
            case ".": 
            case "..": {
                return false;
            }
        }
        for (Object c : (String)v.toCharArray()) {
            switch (c) {
                case 47: 
                case 92: {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public Integer getNameCount(NPath basePath) {
        List<String> pa = this.asPathArray();
        return pa.size() == 0 ? 1 : pa.size();
    }

    @Override
    public Boolean isRoot(NPath basePath) {
        return this.asPathArray().size() == 0 && (this.value.contains("/") || this.value.contains("\\"));
    }

    @Override
    public NPath subpath(NPath basePath, int beginIndex, int endIndex) {
        List<String> a = this.asPathArray();
        return NPath.of(String.join((CharSequence)"/", a.subList(beginIndex, endIndex)));
    }

    @Override
    public List<String> getNames(NPath basePath) {
        return this.asPathArray();
    }

    private String[] normalizePath(String[] aa) {
        ArrayList<String> p = new ArrayList<String>(Arrays.asList(aa));
        block8: for (int i = p.size() - 1; i >= 0; --i) {
            switch ((String)p.get(i)) {
                case ".": {
                    p.remove(i);
                    ++i;
                    continue block8;
                }
                case "..": {
                    p.remove(i);
                    if (i <= 0) continue block8;
                    p.remove(i);
                    continue block8;
                }
            }
        }
        return p.toArray(new String[0]);
    }

    private List<String> asPathArray(String s) {
        return Arrays.asList(s);
    }

    private List<String> asPathArray() {
        return this.asPathArray(this.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InvalidFilePath urlPath = (InvalidFilePath)o;
        return Objects.equals(this.value, urlPath.value);
    }

    @Override
    public String toString() {
        return this.value;
    }

    @Override
    public boolean moveTo(NPath basePath, NPath other, NPathOption ... options) {
        throw new NIOException(NMsg.ofC("unable to move %s", this));
    }

    @Override
    public NPath getRoot(NPath basePath) {
        if (this.isRoot(basePath).booleanValue()) {
            return basePath;
        }
        NPath r = basePath.getParent();
        if (r != null) {
            return r.getRoot();
        }
        return null;
    }

    @Override
    public boolean isLocal(NPath basePath) {
        return true;
    }

    private static class MyPathFormat
    implements NFormatSPI {
        private final InvalidFilePath p;

        @Override
        public String getName() {
            return "path";
        }

        public MyPathFormat(InvalidFilePath p) {
            this.p = p;
        }

        public NText asFormattedString() {
            return NText.of(this.p.value);
        }

        @Override
        public void print(NPrintStream out) {
            out.print(this.asFormattedString());
        }

        @Override
        public boolean configureFirst(NCmdLine cmdLine) {
            return false;
        }
    }
}

