/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.path.spi;

import java.io.InputStream;
import java.io.OutputStream;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.concurrent.NScoredCallable;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementDescribables;
import net.thevpc.nuts.elem.NElementParser;
import net.thevpc.nuts.elem.NElements;
import net.thevpc.nuts.io.NCp;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NPathOption;
import net.thevpc.nuts.io.NPathType;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.runtime.standalone.io.path.spi.AbstractPathSPIAdapter;
import net.thevpc.nuts.spi.NFormatSPI;
import net.thevpc.nuts.spi.NPathFactorySPI;
import net.thevpc.nuts.spi.NPathSPI;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextBuilder;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.util.NFunction;
import net.thevpc.nuts.util.NScorableContext;
import net.thevpc.nuts.util.NStream;
import net.thevpc.nuts.util.NStringUtils;
import net.thevpc.nuts.util.NUnsupportedArgumentException;

public class GithubfsPath
extends AbstractPathSPIAdapter {
    public static final String PROTOCOL = "githubfs";
    public static final String PREFIX = "githubfs+";
    private final Info info;
    private Object loaded;

    public GithubfsPath(String url) {
        this(url, null);
    }

    private GithubfsPath(String url, Info info) {
        super(NPath.of(url.substring(PREFIX.length())));
        if (!url.startsWith(PREFIX)) {
            throw new NUnsupportedArgumentException(NMsg.ofC("expected prefix '%s'", PREFIX));
        }
        this.info = info;
    }

    @Override
    public int hashCode() {
        return Objects.hash(PROTOCOL, super.hashCode());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public String toString() {
        return PREFIX + this.ref.toString();
    }

    @Override
    public NStream<NPath> list(NPath basePath) {
        Object q = this.load();
        if (q instanceof Info[]) {
            return NStream.ofArray((Info[])q).map(NFunction.of(x -> NPath.of(new GithubfsPath(PREFIX + this.ref.resolve(x.name).toString(), (Info)x))).redescribe((Supplier)NElementDescribables.ofDesc("GithubfsPath::of")));
        }
        return NStream.ofEmpty();
    }

    @Override
    public NFormatSPI formatter(NPath basePath) {
        return new MyPathFormat(this);
    }

    @Override
    public String getProtocol(NPath basePath) {
        return PROTOCOL;
    }

    @Override
    public NPath resolve(NPath basePath, String path) {
        return NPath.of(PREFIX + this.ref.resolve(path));
    }

    @Override
    public NPath resolveSibling(NPath basePath, String path) {
        return NPath.of(PREFIX + this.ref.resolveSibling(path));
    }

    @Override
    public boolean exists(NPath basePath) {
        if (this.info != null) {
            return true;
        }
        return this.load() != null;
    }

    @Override
    public long getContentLength(NPath basePath) {
        Info o = this._fileInfo();
        if (o != null) {
            return o.size;
        }
        return -1L;
    }

    @Override
    public String getContentEncoding(NPath basePath) {
        NPath p = this.getDownloadPath();
        return p == null ? null : p.contentEncoding();
    }

    @Override
    public String getContentType(NPath basePath) {
        NPath p = this.getDownloadPath();
        return p == null ? null : p.getContentType();
    }

    @Override
    public InputStream getInputStream(NPath basePath, NPathOption ... options) {
        NPath p = this.getDownloadPath();
        if (p != null) {
            return p.getInputStream(options);
        }
        throw new NIOException(NMsg.ofC("not a file %s", basePath));
    }

    @Override
    public OutputStream getOutputStream(NPath basePath, NPathOption ... options) {
        throw new NIOException(NMsg.ofC("not writable %s", basePath));
    }

    @Override
    public Instant getLastModifiedInstant(NPath basePath) {
        NPath p = this.getDownloadPath();
        return p == null ? null : p.getLastModifiedInstant();
    }

    @Override
    public Instant getLastAccessInstant(NPath basePath) {
        NPath p = this.getDownloadPath();
        return p == null ? null : p.getLastAccessInstant();
    }

    @Override
    public Instant getCreationInstant(NPath basePath) {
        NPath p = this.getDownloadPath();
        return p == null ? null : p.getCreationInstant();
    }

    @Override
    public NPath getParent(NPath basePath) {
        if (this.isRoot(basePath).booleanValue()) {
            return null;
        }
        NPath p = this.ref.getParent();
        if (p == null) {
            return null;
        }
        return NPath.of(PREFIX + p);
    }

    @Override
    public NPath toAbsolute(NPath basePath, NPath rootPath) {
        if (this.isAbsolute(basePath)) {
            return basePath;
        }
        return NPath.of(PREFIX + basePath.toAbsolute(rootPath));
    }

    @Override
    public NPath normalize(NPath basePath) {
        return NPath.of(PREFIX + this.ref.normalize());
    }

    @Override
    public Boolean isName(NPath basePath) {
        return false;
    }

    @Override
    public Boolean isRoot(NPath basePath) {
        Info[] infoArray;
        int n;
        int n2;
        Info f = this._fileInfo();
        if (f != null) {
            if (!"dir".equals(f.type)) {
                return false;
            }
            return "".equals(f.path);
        }
        Object a = this.load();
        if (a instanceof Info[] && (n2 = 0) < (n = (infoArray = (Info[])a).length)) {
            Info i = infoArray[n2];
            return !i.path.contains("/");
        }
        return false;
    }

    @Override
    public NPath getRoot(NPath basePath) {
        if (this.isRoot(basePath).booleanValue()) {
            return basePath;
        }
        return NPath.of(PREFIX + this.ref.getRoot());
    }

    @Override
    public boolean copyTo(NPath basePath, NPath other, NPathOption ... options) {
        NPath p = this.getDownloadPath();
        if (p != null) {
            p.copyTo(other, options);
        } else {
            NCp.of().from(basePath).to(other).addOptions(options).run();
        }
        return true;
    }

    private Object load() {
        if (this.loaded == null) {
            this.loaded = this.load(this.ref);
        }
        return this.loaded;
    }

    private Object load(NPath p) {
        NElements elems = NElements.of();
        NElement e = NElementParser.ofJson().parse(this.ref);
        if (e != null) {
            if (e.isArray()) {
                return NStream.ofArray(elems.convert(e, Info[].class)).toArray(Info[]::new);
            }
            if (e.isObject()) {
                return elems.convert(e, Info.class);
            }
        }
        return null;
    }

    private Info _fileInfo() {
        if (this.info != null) {
            return this.info;
        }
        Object o = this.load();
        if (o instanceof Info) {
            return (Info)o;
        }
        return null;
    }

    @Override
    public NPathType getType(NPath basePath) {
        switch (this._type()) {
            case "dir": {
                return NPathType.DIRECTORY;
            }
            case "file": {
                return NPathType.FILE;
            }
            case "symlink": {
                return NPathType.SYMBOLIC_LINK;
            }
            case "": {
                return NPathType.NOT_FOUND;
            }
        }
        return NPathType.OTHER;
    }

    private String _type() {
        if (this.info != null) {
            return NStringUtils.trim(this.info.type);
        }
        Object a = this.load();
        if (a != null) {
            if (a instanceof Info) {
                return NStringUtils.trim(((Info)a).type);
            }
            if (a instanceof Info[]) {
                return "dir";
            }
        }
        return "";
    }

    private NPath getDownloadPath() {
        Info i = this._fileInfo();
        if (i != null && this._type().equals("file")) {
            return NPath.of(i.download_url);
        }
        return null;
    }

    @Override
    public boolean isLocal(NPath basePath) {
        return this.ref.isLocal();
    }

    private static class Info {
        String name;
        String path;
        String target;
        String sha;
        long size;
        String url;
        String html_url;
        String git_url;
        String download_url;
        String type;
        String content;
        String encoding;
        Map<String, String> self;

        private Info() {
        }
    }

    private static class MyPathFormat
    implements NFormatSPI {
        private final GithubfsPath p;

        public MyPathFormat(GithubfsPath p) {
            this.p = p;
        }

        @Override
        public String getName() {
            return "path";
        }

        public NText asFormattedString() {
            NTextBuilder sb = NTextBuilder.of();
            sb.append((Object)GithubfsPath.PROTOCOL, NTextStyle.primary1());
            sb.append((Object)":", NTextStyle.separator());
            sb.append(this.p.ref);
            return sb.build();
        }

        @Override
        public void print(NPrintStream out) {
            out.print(this.asFormattedString());
        }

        @Override
        public boolean configureFirst(NCmdLine cmdLine) {
            return false;
        }
    }

    public static class GithubfsFactory
    implements NPathFactorySPI {
        @Override
        public NScoredCallable<NPathSPI> createPath(String path, String protocol, ClassLoader classLoader) {
            if (path.startsWith(GithubfsPath.PREFIX)) {
                return NScoredCallable.of(10, () -> new GithubfsPath(path));
            }
            return null;
        }

        @Override
        public int getScore(NScorableContext context) {
            String path = (String)context.getCriteria();
            try {
                if (path.startsWith(GithubfsPath.PREFIX)) {
                    return 10;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return -1;
        }
    }
}

