/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.path.spi;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.concurrent.NScoredCallable;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.io.DefaultNPathInfo;
import net.thevpc.nuts.io.NCp;
import net.thevpc.nuts.io.NIO;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NIOUtils;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NPathInfo;
import net.thevpc.nuts.io.NPathOption;
import net.thevpc.nuts.io.NPathPermission;
import net.thevpc.nuts.io.NPathType;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.platform.NOsFamily;
import net.thevpc.nuts.runtime.standalone.io.path.spi.URLPath;
import net.thevpc.nuts.spi.NFormatSPI;
import net.thevpc.nuts.spi.NPathFactorySPI;
import net.thevpc.nuts.spi.NPathSPI;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTreeVisitResult;
import net.thevpc.nuts.text.NTreeVisitor;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NIterator;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NScorableContext;
import net.thevpc.nuts.util.NStream;

public class FilePath
implements NPathSPI {
    private final Path value;

    public FilePath(Path value) {
        if (value == null) {
            throw new NIllegalArgumentException(NMsg.ofPlain("invalid null value"));
        }
        this.value = value;
    }

    private NPath fastPath(Path p) {
        return NPath.of(new FilePath(p));
    }

    @Override
    public NStream<NPath> list(NPath basePath) {
        if (Files.isDirectory(this.value, new LinkOption[0])) {
            NStream<NPath> nStream;
            block9: {
                Stream<Path> files = Files.list(this.value);
                try {
                    nStream = NStream.ofIterable(files.collect(Collectors.toList())).map(x -> this.fastPath((Path)x));
                    if (files == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (files != null) {
                            try {
                                files.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                files.close();
            }
            return nStream;
        }
        return NStream.ofEmpty();
    }

    @Override
    public NFormatSPI formatter(NPath basePath) {
        return new MyPathFormat(this);
    }

    @Override
    public String getName(NPath basePath) {
        Path a = this.value.getFileName();
        return a == null ? null : a.toString();
    }

    @Override
    public String getProtocol(NPath basePath) {
        return "";
    }

    @Override
    public NPath resolve(NPath basePath, String path) {
        if (NBlankable.isBlank(path)) {
            return this.fastPath(this.value);
        }
        try {
            return this.fastPath(this.value.resolve(path));
        }
        catch (Exception ex) {
            return NPath.of(this.value + this.getSep() + path);
        }
    }

    @Override
    public NPath resolveSibling(NPath basePath, String path) {
        if (path == null) {
            return this.getParent(basePath);
        }
        if (path.isEmpty()) {
            return this.getParent(basePath);
        }
        try {
            return this.fastPath(this.value.resolveSibling(path));
        }
        catch (Exception e) {
            Path p = this.value.getParent();
            if (p == null) {
                return NPath.of(path);
            }
            return this.fastPath(p).resolve(path);
        }
    }

    @Override
    public NPath toCompressedForm(NPath basePath) {
        return null;
    }

    @Override
    public NOptional<URL> toURL(NPath basePath) {
        try {
            return NOptional.of(this.value.toUri().toURL());
        }
        catch (MalformedURLException e) {
            return NOptional.ofNamedError(NMsg.ofC("not an url %s", this.value));
        }
    }

    @Override
    public NOptional<Path> toPath(NPath basePath) {
        return NOptional.ofNamed(this.value, "path");
    }

    @Override
    public NPathType getType(NPath basePath) {
        if (Files.isDirectory(this.value, new LinkOption[0])) {
            return NPathType.DIRECTORY;
        }
        if (Files.isRegularFile(this.value, new LinkOption[0])) {
            return NPathType.FILE;
        }
        PosixFileAttributes a = this.getUattr();
        if (a != null) {
            if (a.isSymbolicLink()) {
                return NPathType.SYMBOLIC_LINK;
            }
            if (a.isOther()) {
                return NPathType.OTHER;
            }
        }
        return Files.exists(this.value, new LinkOption[0]) ? NPathType.OTHER : NPathType.NOT_FOUND;
    }

    @Override
    public boolean isLocal(NPath basePath) {
        return true;
    }

    @Override
    public boolean exists(NPath basePath) {
        return Files.exists(this.value, new LinkOption[0]);
    }

    @Override
    public long getContentLength(NPath basePath) {
        try {
            return Files.size(this.value);
        }
        catch (IOException e) {
            return -1L;
        }
    }

    @Override
    public String getContentEncoding(NPath basePath) {
        return null;
    }

    @Override
    public String getContentType(NPath basePath) {
        return NIO.of().probeContentType(this.value);
    }

    @Override
    public String getCharset(NPath basePath) {
        return NIO.of().probeCharset(this.value);
    }

    @Override
    public String getLocation(NPath basePath) {
        return this.value.toString();
    }

    @Override
    public InputStream getInputStream(NPath basePath, NPathOption ... options) {
        try {
            return Files.newInputStream(this.value, FilePath.toOpenOptions(options));
        }
        catch (IOException e) {
            throw new NIOException(e);
        }
    }

    @Override
    public OutputStream getOutputStream(NPath basePath, NPathOption ... options) {
        try {
            return Files.newOutputStream(this.value, FilePath.toOpenOptions(options));
        }
        catch (IOException e) {
            throw new NIOException(e);
        }
    }

    private static OpenOption[] toOpenOptions(NPathOption[] options) {
        ArrayList<Enum> oo = new ArrayList<Enum>();
        if (options != null) {
            block15: for (NPathOption o : options) {
                if (o == null) continue;
                switch (o) {
                    case NOFOLLOW_LINKS: {
                        oo.add(LinkOption.NOFOLLOW_LINKS);
                        continue block15;
                    }
                    case READ: {
                        oo.add(StandardOpenOption.READ);
                        continue block15;
                    }
                    case WRITE: {
                        oo.add(StandardOpenOption.WRITE);
                        continue block15;
                    }
                    case APPEND: {
                        oo.add(StandardOpenOption.APPEND);
                        continue block15;
                    }
                    case TRUNCATE_EXISTING: {
                        oo.add(StandardOpenOption.TRUNCATE_EXISTING);
                        continue block15;
                    }
                    case CREATE: {
                        oo.add(StandardOpenOption.CREATE);
                        continue block15;
                    }
                    case CREATE_NEW: {
                        oo.add(StandardOpenOption.CREATE_NEW);
                        continue block15;
                    }
                    case DELETE_ON_CLOSE: {
                        oo.add(StandardOpenOption.DELETE_ON_CLOSE);
                        continue block15;
                    }
                    case SPARSE: {
                        oo.add(StandardOpenOption.SPARSE);
                        continue block15;
                    }
                    case SYNC: {
                        oo.add(StandardOpenOption.SYNC);
                        continue block15;
                    }
                    case DSYNC: {
                        oo.add(StandardOpenOption.DSYNC);
                        continue block15;
                    }
                    case NOSHARE_READ: {
                        continue block15;
                    }
                    case NOSHARE_DELETE: {
                        continue block15;
                    }
                }
            }
        }
        return oo.toArray(new OpenOption[0]);
    }

    @Override
    public void delete(NPath basePath, boolean recurse) {
        if (Files.isRegularFile(this.value, new LinkOption[0])) {
            try {
                Files.delete(this.value);
            }
            catch (IOException e) {
                throw new NIOException(e);
            }
        } else if (Files.isDirectory(this.value, new LinkOption[0])) {
            if (recurse) {
                NIOUtils.delete(this.value);
            } else {
                try {
                    Files.delete(this.value);
                }
                catch (IOException e) {
                    throw new NIOException(e);
                }
            }
        } else {
            throw new NIOException(NMsg.ofC("unable to delete path %s", this.value));
        }
    }

    @Override
    public void mkdir(boolean parents, NPath basePath) {
        if (Files.isRegularFile(this.value, new LinkOption[0])) {
            throw new NIOException(NMsg.ofC("unable to create folder out of regular file %s", this.value));
        }
        if (Files.isDirectory(this.value, new LinkOption[0])) {
            return;
        }
        try {
            Files.createDirectories(this.value, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new NIOException(NMsg.ofC("unable to create folders %s", this.value));
        }
    }

    @Override
    public Instant getLastModifiedInstant(NPath basePath) {
        FileTime r = null;
        try {
            r = Files.getLastModifiedTime(this.value, new LinkOption[0]);
            if (r != null) {
                return r.toInstant();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Instant getLastAccessInstant(NPath basePath) {
        BasicFileAttributes a = this.getBattr();
        if (a != null) {
            FileTime t = a.lastAccessTime();
            return t == null ? null : Instant.ofEpochMilli(t.toMillis());
        }
        return null;
    }

    @Override
    public Instant getCreationInstant(NPath basePath) {
        BasicFileAttributes a = this.getBattr();
        if (a != null) {
            FileTime t = a.creationTime();
            return t == null ? null : Instant.ofEpochMilli(t.toMillis());
        }
        return null;
    }

    @Override
    public NPath getParent(NPath basePath) {
        Path p = this.value.getParent();
        if (p == null) {
            return null;
        }
        return this.fastPath(p);
    }

    @Override
    public NPath toAbsolute(NPath basePath, NPath rootPath) {
        if (this.isAbsolute(basePath)) {
            return basePath;
        }
        if (rootPath == null) {
            return this.fastPath(this.value.normalize().toAbsolutePath());
        }
        return rootPath.toAbsolute().resolve(this.toString());
    }

    @Override
    public NPath normalize(NPath basePath) {
        return this.fastPath(this.value.normalize());
    }

    @Override
    public boolean isAbsolute(NPath basePath) {
        return this.value.isAbsolute();
    }

    @Override
    public String getOwner(NPath basePath) {
        PosixFileAttributes a = this.getUattr();
        if (a != null) {
            UserPrincipal o = a.owner();
            return o == null ? null : o.getName();
        }
        return null;
    }

    @Override
    public String getGroup(NPath basePath) {
        PosixFileAttributes a = this.getUattr();
        if (a != null) {
            GroupPrincipal o = a.group();
            return o == null ? null : o.getName();
        }
        return null;
    }

    private static Set<NPathPermission> perms(Path path) {
        LinkedHashSet<NPathPermission> p = new LinkedHashSet<NPathPermission>();
        Set<PosixFilePermission> a = null;
        try {
            a = Files.getPosixFilePermissions(path, LinkOption.NOFOLLOW_LINKS);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        File file = path.toFile();
        if (file.canRead()) {
            p.add(NPathPermission.CAN_READ);
        }
        if (file.canWrite()) {
            p.add(NPathPermission.CAN_WRITE);
        }
        if (file.canExecute()) {
            p.add(NPathPermission.CAN_EXECUTE);
        }
        if (a != null) {
            for (PosixFilePermission permission : a) {
                switch (permission) {
                    case OWNER_READ: {
                        p.add(NPathPermission.OWNER_READ);
                    }
                    case OWNER_WRITE: {
                        p.add(NPathPermission.OWNER_WRITE);
                    }
                    case OWNER_EXECUTE: {
                        p.add(NPathPermission.OWNER_EXECUTE);
                    }
                    case GROUP_READ: {
                        p.add(NPathPermission.GROUP_READ);
                    }
                    case GROUP_WRITE: {
                        p.add(NPathPermission.GROUP_WRITE);
                    }
                    case GROUP_EXECUTE: {
                        p.add(NPathPermission.GROUP_EXECUTE);
                    }
                    case OTHERS_READ: {
                        p.add(NPathPermission.OTHERS_READ);
                    }
                    case OTHERS_WRITE: {
                        p.add(NPathPermission.OTHERS_WRITE);
                    }
                    case OTHERS_EXECUTE: {
                        p.add(NPathPermission.OTHERS_EXECUTE);
                    }
                }
            }
        }
        return Collections.unmodifiableSet(p);
    }

    @Override
    public Set<NPathPermission> getPermissions(NPath basePath) {
        return FilePath.perms(this.value);
    }

    @Override
    public void setPermissions(NPath basePath, NPathPermission ... permissions) {
        LinkedHashSet<NPathPermission> add = new LinkedHashSet<NPathPermission>(Arrays.asList(permissions));
        LinkedHashSet<NPathPermission> remove = new LinkedHashSet<NPathPermission>(EnumSet.allOf(NPathPermission.class));
        remove.addAll(add);
        this.setPermissions(add.toArray(new NPathPermission[0]), true);
    }

    @Override
    public void addPermissions(NPath basePath, NPathPermission ... permissions) {
        this.setPermissions(permissions, true);
    }

    @Override
    public void removePermissions(NPath basePath, NPathPermission ... permissions) {
    }

    @Override
    public Boolean isName(NPath basePath) {
        if (this.value.getNameCount() > 1) {
            return false;
        }
        String v = this.value.toString();
        switch (v) {
            case "/": 
            case "\\": 
            case ".": 
            case "..": {
                return false;
            }
        }
        for (Object c : (String)v.toCharArray()) {
            switch (c) {
                case 47: 
                case 92: {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public Integer getNameCount(NPath basePath) {
        return this.value.getNameCount();
    }

    @Override
    public Boolean isRoot(NPath basePath) {
        return this.value.getNameCount() == 0;
    }

    @Override
    public NPath getRoot(NPath basePath) {
        if (this.value.getNameCount() == 0) {
            return basePath;
        }
        Path root = this.value.getRoot();
        if (root == null) {
            return null;
        }
        return NPath.of(root);
    }

    @Override
    public NStream<NPath> walk(NPath basePath, int maxDepth, NPathOption[] options) {
        FileVisitOption[] fileOptions = (FileVisitOption[])Arrays.stream(options).map(x -> {
            if (x == null) {
                return null;
            }
            switch (x) {
                case FOLLOW_LINKS: {
                    return FileVisitOption.FOLLOW_LINKS;
                }
            }
            return null;
        }).filter(Objects::nonNull).toArray(FileVisitOption[]::new);
        if (Files.isDirectory(this.value, new LinkOption[0])) {
            try {
                return NStream.ofStream(Files.walk(this.value, maxDepth, fileOptions).map(x -> this.fastPath((Path)x)));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return NStream.ofEmpty();
    }

    @Override
    public NPathInfo getInfo(NPath basePath) {
        return FilePath.fetchInfo(this.value);
    }

    @Override
    public List<NPathInfo> listInfos(NPath basePath) {
        return null;
    }

    private static NPathInfo fetchInfo(Path path) {
        try {
            NPathType targetType;
            BasicFileAttributes attrs = Files.readAttributes(path, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
            boolean isSymlink = attrs.isSymbolicLink();
            Path target = isSymlink ? Files.readSymbolicLink(path) : null;
            NPathType type = FilePath.determineType(attrs);
            if (isSymlink && Files.exists(path.toRealPath(new LinkOption[0]), new LinkOption[0])) {
                BasicFileAttributes targetAttrs = Files.readAttributes(path.toRealPath(new LinkOption[0]), BasicFileAttributes.class, new LinkOption[0]);
                targetType = FilePath.determineType(targetAttrs);
            } else {
                targetType = null;
            }
            String targetPath = target != null ? path.getParent().resolve(target).toString() : null;
            Instant lastModified = attrs.lastModifiedTime().toInstant();
            Instant lastAccess = attrs.lastAccessTime().toInstant();
            Set<NPathPermission> perms = FilePath.perms(path);
            Instant creationTime = attrs.creationTime().toInstant();
            String owner = null;
            try {
                owner = Files.getOwner(path, LinkOption.NOFOLLOW_LINKS).getName();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String group = null;
            try {
                PosixFileAttributes posix = Files.readAttributes(path, PosixFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                group = posix.group().getName();
            }
            catch (UnsupportedOperationException e) {
                group = "";
            }
            return new DefaultNPathInfo(path.toString(), type, targetType, targetPath, attrs.size(), isSymlink, lastModified, lastAccess, creationTime, perms, owner, group);
        }
        catch (IOException e) {
            return DefaultNPathInfo.ofNotFound(path.toString());
        }
    }

    private static NPathType determineType(BasicFileAttributes attrs) {
        if (attrs.isRegularFile()) {
            return NPathType.FILE;
        }
        if (attrs.isDirectory()) {
            return NPathType.DIRECTORY;
        }
        if (attrs.isSymbolicLink()) {
            return NPathType.SYMBOLIC_LINK;
        }
        return NPathType.OTHER;
    }

    @Override
    public NPath subpath(NPath basePath, int beginIndex, int endIndex) {
        return this.fastPath(this.value.subpath(beginIndex, endIndex));
    }

    @Override
    public List<String> getNames(NPath basePath) {
        int nameCount = this.value.getNameCount();
        String[] names = new String[nameCount];
        for (int i = 0; i < nameCount; ++i) {
            names[i] = this.value.getName(i).toString();
        }
        return Arrays.asList(names);
    }

    @Override
    public boolean moveTo(NPath basePath, NPath other, NPathOption ... options) {
        Path f = other.toPath().orNull();
        if (f != null) {
            try {
                Files.move(this.value, f, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new NIOException(e);
            }
        } else {
            this.copyTo(basePath, other, options);
            this.delete(basePath, true);
        }
        return true;
    }

    @Override
    public boolean copyTo(NPath basePath, NPath other, NPathOption ... options) {
        NCp.of().from(this.fastPath(this.value)).to(other).addOptions(options).run();
        return true;
    }

    @Override
    public boolean walkDfs(NPath basePath, final NTreeVisitor<NPath> visitor, int maxDepth, NPathOption ... options) {
        HashSet<FileVisitOption> foptions = new HashSet<FileVisitOption>();
        for (NPathOption option : options) {
            switch (option) {
                case FOLLOW_LINKS: {
                    foptions.add(FileVisitOption.FOLLOW_LINKS);
                }
            }
        }
        try {
            Files.walkFileTree(this.value, foptions, maxDepth, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    return this.fileVisitResult(visitor.preVisitDirectory(FilePath.this.fastPath(dir)));
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    return this.fileVisitResult(visitor.visitFile(FilePath.this.fastPath(file)));
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return this.fileVisitResult(visitor.visitFileFailed(FilePath.this.fastPath(file), exc));
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    return this.fileVisitResult(visitor.postVisitDirectory(FilePath.this.fastPath(dir), exc));
                }

                private FileVisitResult fileVisitResult(NTreeVisitResult z) {
                    if (z != null) {
                        switch (z) {
                            case CONTINUE: {
                                return FileVisitResult.CONTINUE;
                            }
                            case TERMINATE: {
                                return FileVisitResult.TERMINATE;
                            }
                            case SKIP_SUBTREE: {
                                return FileVisitResult.SKIP_SUBTREE;
                            }
                            case SKIP_SIBLINGS: {
                                return FileVisitResult.SKIP_SIBLINGS;
                            }
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new NIOException(e);
        }
        return true;
    }

    private String getSep() {
        for (char c : this.value.toString().toCharArray()) {
            switch (c) {
                case '/': 
                case '\\': {
                    return String.valueOf(c);
                }
            }
        }
        return "/";
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilePath urlPath = (FilePath)o;
        return Objects.equals(this.value, urlPath.value);
    }

    @Override
    public String toString() {
        return this.value.toString();
    }

    private BasicFileAttributes getBattr() {
        try {
            return Files.readAttributes(this.value, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private PosixFileAttributes getUattr() {
        try {
            return Files.readAttributes(this.value, PosixFileAttributes.class, new LinkOption[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean setPermissions(NPathPermission[] permissions, boolean f) {
        int count = 0;
        block14: for (NPathPermission permission : permissions = permissions == null ? new NPathPermission[]{} : (NPathPermission[])Arrays.stream(permissions).filter(Objects::nonNull).distinct().toArray(NPathPermission[]::new)) {
            switch (permission) {
                case CAN_READ: {
                    boolean b = this.value.toFile().setReadable(f);
                    if (!b) continue block14;
                    ++count;
                    continue block14;
                }
                case CAN_WRITE: {
                    boolean b = this.value.toFile().setWritable(f);
                    if (!b) continue block14;
                    ++count;
                    continue block14;
                }
                case CAN_EXECUTE: {
                    boolean b = this.value.toFile().setExecutable(f);
                    if (!b) continue block14;
                    ++count;
                    continue block14;
                }
                case OWNER_READ: {
                    boolean b = this.value.toFile().setReadable(f);
                    if (!b) continue block14;
                    ++count;
                    continue block14;
                }
                case OWNER_WRITE: {
                    boolean b = this.value.toFile().setWritable(f);
                    if (!b) continue block14;
                    ++count;
                    continue block14;
                }
                case OWNER_EXECUTE: {
                    boolean b = this.value.toFile().setExecutable(f);
                    if (!b) continue block14;
                    ++count;
                    continue block14;
                }
                case GROUP_READ: {
                    boolean b = this.value.toFile().setReadable(f);
                    if (!b) continue block14;
                    ++count;
                    continue block14;
                }
                case GROUP_WRITE: {
                    boolean b = this.value.toFile().setWritable(f);
                    if (!b) continue block14;
                    ++count;
                    continue block14;
                }
                case GROUP_EXECUTE: {
                    boolean b = this.value.toFile().setExecutable(f);
                    if (!b) continue block14;
                    ++count;
                    continue block14;
                }
                case OTHERS_READ: {
                    boolean b = this.value.toFile().setReadable(f);
                    if (!b) continue block14;
                    ++count;
                    continue block14;
                }
                case OTHERS_WRITE: {
                    boolean b = this.value.toFile().setWritable(f);
                    if (!b) continue block14;
                    ++count;
                    continue block14;
                }
                case OTHERS_EXECUTE: {
                    boolean b = this.value.toFile().setExecutable(f);
                    if (!b) continue block14;
                    ++count;
                    continue block14;
                }
            }
        }
        return count == permissions.length;
    }

    @Override
    public NStream<String> reversedLines(NPath basePath, Charset charset) {
        File file;
        File file2 = file = this.value == null ? null : this.value.toFile();
        if (file == null || !file.isFile()) {
            throw new NIOException(new FileNotFoundException(String.valueOf(this.value)));
        }
        Charset actualCharset = charset != null ? charset : Charset.defaultCharset();
        return NStream.ofIterator(new ReverseLineReaderIterator(file, actualCharset, 40960));
    }

    private static class MyPathFormat
    implements NFormatSPI {
        private final FilePath p;

        public MyPathFormat(FilePath p) {
            this.p = p;
        }

        @Override
        public String getName() {
            return "path";
        }

        public NText asFormattedString() {
            return NText.of(this.p.value);
        }

        @Override
        public void print(NPrintStream out) {
            out.print(this.asFormattedString());
        }

        @Override
        public boolean configureFirst(NCmdLine cmdLine) {
            return false;
        }
    }

    private static class ReverseLineReaderIterator
    implements NIterator<String>,
    AutoCloseable {
        private final Charset actualCharset;
        private long pointer;
        private byte[] buffer;
        private String nextLine;
        private long fileLength;
        private RandomAccessFile raf;
        private ByteArrayOutputStream lineBuffer;
        private int bufferSize;

        public ReverseLineReaderIterator(File file, Charset actualCharset, int bufferSize) {
            this.actualCharset = actualCharset;
            this.bufferSize = bufferSize;
            this.buffer = new byte[bufferSize];
            try {
                this.raf = new RandomAccessFile(file, "r");
                this.fileLength = this.raf.length();
            }
            catch (IOException e) {
                throw new NIOException(e);
            }
            this.lineBuffer = new ByteArrayOutputStream();
            this.pointer = this.fileLength;
        }

        private static String decodeReversed(ByteArrayOutputStream reversedBytes, Charset charset) {
            byte[] raw = reversedBytes.toByteArray();
            ReverseLineReaderIterator.reverse(raw);
            return new String(raw, charset);
        }

        private static void reverse(byte[] array) {
            int i = 0;
            for (int j = array.length - 1; i < j; ++i, --j) {
                byte tmp = array[i];
                array[i] = array[j];
                array[j] = tmp;
            }
        }

        @Override
        public void close() {
            if (this.raf != null) {
                try {
                    this.raf.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                this.raf = null;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.raf == null) {
                return false;
            }
            boolean wasNewline = false;
            try {
                while (this.pointer > 0L) {
                    int readSize = (int)Math.min((long)this.bufferSize, this.pointer);
                    this.pointer -= (long)readSize;
                    this.raf.seek(this.pointer);
                    this.raf.readFully(this.buffer, 0, readSize);
                    for (int i = readSize - 1; i >= 0; --i) {
                        byte b = this.buffer[i];
                        if (b == 10) {
                            wasNewline = true;
                            if (this.lineBuffer.size() <= 0) continue;
                            String line = ReverseLineReaderIterator.decodeReversed(this.lineBuffer, this.actualCharset);
                            this.lineBuffer.reset();
                            this.nextLine = line;
                            return true;
                        }
                        if (b == 13) {
                            if (!wasNewline && this.lineBuffer.size() > 0) {
                                String line = ReverseLineReaderIterator.decodeReversed(this.lineBuffer, this.actualCharset);
                                this.lineBuffer.reset();
                                this.nextLine = line;
                                return true;
                            }
                            wasNewline = false;
                            continue;
                        }
                        wasNewline = false;
                        this.lineBuffer.write(b);
                    }
                }
                if (this.lineBuffer.size() > 0) {
                    String line = ReverseLineReaderIterator.decodeReversed(this.lineBuffer, this.actualCharset);
                    this.lineBuffer.reset();
                    this.nextLine = line;
                    return true;
                }
                this.close();
                return false;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public String next() {
            return this.nextLine;
        }

        @Override
        public NIterator<String> redescribe(Supplier<NElement> description) {
            return this;
        }
    }

    public static class FilePathFactory
    implements NPathFactorySPI {
        @Override
        public NScoredCallable<NPathSPI> createPath(String path, String protocol, ClassLoader classLoader) {
            try {
                if (URLPath.MOSTLY_URL_PATTERN.matcher(path).matches()) {
                    return null;
                }
                if (NWorkspace.of().getOsFamily() == NOsFamily.WINDOWS && path.matches("^[\\\\/][a-zA-Z]:([\\\\/].*)?")) {
                    path = path.substring(1);
                }
                Path value = Paths.get(path, new String[0]);
                if (path.matches("^([a-zA-Z][a-zA-Z0-9]+)([+]([a-zA-Z][a-zA-Z0-9]+))*:.*")) {
                    return NScoredCallable.of(5, () -> new FilePath(value));
                }
                return NScoredCallable.of(10, () -> new FilePath(value));
            }
            catch (Exception exception) {
                return null;
            }
        }

        @Override
        public int getScore(NScorableContext context) {
            String path = (String)context.getCriteria();
            try {
                if (URLPath.MOSTLY_URL_PATTERN.matcher(path).matches()) {
                    return -1;
                }
                Path value = Paths.get(path, new String[0]);
                return 10;
            }
            catch (Exception exception) {
                return -1;
            }
        }
    }
}

