/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.outputstream;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NOutputStreamTransparentAdapter;
import net.thevpc.nuts.runtime.standalone.io.outputstream.OutputHelper;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NIllegalArgumentException;

public class OutputStreamHelper
implements OutputHelper {
    private OutputStream rawOutput;
    private OutputStream rawOutput0;
    private PrintStream ps;

    public OutputStreamHelper(OutputStream rawOutput) {
        this.rawOutput = rawOutput;
        this.rawOutput0 = rawOutput;
        for (int loopGard = 100; loopGard > 0 && this.rawOutput0 instanceof NOutputStreamTransparentAdapter; --loopGard) {
            this.rawOutput0 = ((NOutputStreamTransparentAdapter)((Object)this.rawOutput0)).baseOutputStream();
        }
        if (this.rawOutput0 instanceof NOutputStreamTransparentAdapter) {
            throw new NIllegalArgumentException(NMsg.ofPlain("invalid rawOutput"));
        }
    }

    @Override
    public void write(byte[] b, int offset, int len) {
        try {
            this.rawOutput0.write(b, offset, len);
        }
        catch (IOException ex) {
            throw new NIOException(ex);
        }
    }

    public void write(char[] b, int offset, int len) {
        if (this.ps != null) {
            if (offset == 0 && len == b.length) {
                this.ps.print(b);
            } else {
                this.ps.print(Arrays.copyOfRange(b, offset, len));
            }
        } else {
            String s = new String(b, offset, len);
            byte[] bb = s.getBytes();
            try {
                this.rawOutput0.write(bb, 0, bb.length);
            }
            catch (IOException ex) {
                throw new NIOException(ex);
            }
        }
    }

    @Override
    public void flush() {
        try {
            this.rawOutput0.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

