/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.inputstream;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.thevpc.nuts.io.DefaultNContentMetadata;
import net.thevpc.nuts.io.NContentMetadata;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NIOUtils;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NTempOutputStream;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NHex;
import net.thevpc.nuts.util.NStream;

public class NTempOutputStreamImpl
extends NTempOutputStream {
    DefaultNContentMetadata md = new DefaultNContentMetadata();
    boolean mem = true;
    long maxSize = 0xA00000L;
    long contentLength = 0L;
    ByteArrayOutputStream bos = new ByteArrayOutputStream();
    NPath file;
    OutputStream fos;
    Consumer<InputStream> onCompleted;
    boolean closed = false;

    public NTempOutputStreamImpl setOnCompleted(Consumer<InputStream> onCompleted) {
        this.onCompleted = onCompleted;
        return this;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.mem) {
            this.bos.write(b);
            ++this.contentLength;
            this.ensureBucket();
        } else {
            this.fos.write(b);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (this.mem) {
            this.bos.write(b);
            this.contentLength += (long)b.length;
            this.ensureBucket();
        } else {
            this.fos.write(b);
            this.contentLength += (long)b.length;
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.mem) {
            this.bos.write(b, off, len);
            this.contentLength += (long)len;
            this.ensureBucket();
        } else {
            this.fos.write(b);
            this.contentLength += (long)len;
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.mem) {
            this.bos.flush();
        } else {
            this.fos.flush();
        }
    }

    private void ensureBucket() {
        if (this.mem && this.contentLength > this.maxSize) {
            this.file = NPath.ofTempFile();
            byte[] currBytes = this.bos.toByteArray();
            this.bos = null;
            this.mem = false;
            this.fos = this.file.getOutputStream();
            try {
                this.fos.write(currBytes);
            }
            catch (IOException ex) {
                throw new NIOException(ex);
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (this.fos != null) {
            this.fos.close();
            if (this.onCompleted != null) {
                try (InputStream in = this.file.getInputStream();){
                    this.onCompleted.accept(in);
                }
            }
            this.file.delete();
        } else if (this.onCompleted != null) {
            try (ByteArrayInputStream in = new ByteArrayInputStream(this.bos.toByteArray());){
                this.onCompleted.accept(in);
            }
        }
        this.closed = true;
    }

    @Override
    public String getName() {
        return this.getMetaData().getName().orNull();
    }

    @Override
    public String getContentType() {
        return this.getMetaData().getContentType().orNull();
    }

    @Override
    public String getCharset() {
        return this.getMetaData().getCharset().orNull();
    }

    @Override
    public NStream<String> reversedLines(Charset cs) {
        if (this.mem) {
            NStream<String> s = this.lines(cs);
            List list = s.collect(Collectors.toCollection(ArrayList::new));
            Collections.reverse(list);
            return NStream.ofStream(list.stream());
        }
        return this.file.reversedLines(cs);
    }

    @Override
    public NStream<String> reversedLines() {
        return this.reversedLines(null);
    }

    @Override
    public NStream<String> lines() {
        return this.lines(null);
    }

    @Override
    public String readString() {
        return new String(this.readBytes());
    }

    @Override
    public byte[] readBytes() {
        byte[] byArray;
        block8: {
            InputStream in = this.getInputStream();
            try {
                byArray = NIOUtils.readBytes(in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new NIOException(e);
                }
            }
            in.close();
        }
        return byArray;
    }

    @Override
    public BufferedReader getBufferedReader() {
        return this.getBufferedReader(null);
    }

    @Override
    public BufferedReader getBufferedReader(Charset cs) {
        Reader r = this.getReader(cs);
        if (r instanceof BufferedReader) {
            return (BufferedReader)r;
        }
        return new BufferedReader(r);
    }

    @Override
    public List<String> tail(int count, Charset cs) {
        LinkedList<String> lines = new LinkedList<String>();
        BufferedReader br = this.getBufferedReader(cs);
        try {
            String line;
            int count0 = 0;
            while ((line = br.readLine()) != null) {
                lines.add(line);
                if (++count0 <= count) continue;
                lines.remove();
            }
        }
        catch (IOException e) {
            throw new NIOException(e);
        }
        return lines;
    }

    @Override
    public List<String> head(int count) {
        return this.head(count, null);
    }

    @Override
    public List<String> head(int count, Charset cs) {
        return this.lines(cs).limit(count).collect(Collectors.toList());
    }

    @Override
    public List<String> tail(int count) {
        return this.tail(count, null);
    }

    @Override
    public NStream<String> lines(Charset cs) {
        BufferedReader br = this.getBufferedReader(cs);
        try {
            return NStream.ofStream((Stream)br.lines().onClose(() -> {
                try {
                    br.close();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }));
        }
        catch (Error | RuntimeException e) {
            try {
                br.close();
            }
            catch (IOException ex) {
                try {
                    e.addSuppressed(ex);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    @Override
    public Reader getReader() {
        return this.getReader(null);
    }

    @Override
    public Reader getReader(Charset cs) {
        CharsetDecoder decoder = this.nonNullCharset(cs).newDecoder();
        InputStreamReader reader = new InputStreamReader(this.getInputStream(), decoder);
        return new BufferedReader(reader);
    }

    protected Charset nonNullCharset(Charset c) {
        if (c == null) {
            return StandardCharsets.UTF_8;
        }
        return c;
    }

    @Override
    public String getDigestString() {
        return NHex.fromBytes(this.getDigest());
    }

    @Override
    public String getDigestString(String algo) {
        return NHex.fromBytes(this.getDigest(algo));
    }

    @Override
    public byte[] getDigest() {
        return this.getDigest(null);
    }

    @Override
    public byte[] getDigest(String algo) {
        byte[] byArray;
        block14: {
            if (NBlankable.isBlank(algo)) {
                algo = "SHA-1";
            }
            InputStream input = this.getInputStream();
            try {
                MessageDigest sha1 = null;
                try {
                    sha1 = MessageDigest.getInstance(algo);
                }
                catch (NoSuchAlgorithmException ex) {
                    throw new NIOException(ex);
                }
                byte[] buffer = new byte[8192];
                int len = 0;
                try {
                    len = input.read(buffer);
                    while (len != -1) {
                        sha1.update(buffer, 0, len);
                        len = input.read(buffer);
                    }
                }
                catch (IOException e) {
                    throw new NIOException(e);
                }
                byArray = sha1.digest();
                if (input == null) break block14;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new NIOException(e);
                }
            }
            input.close();
        }
        return byArray;
    }

    @Override
    public boolean isMultiRead() {
        return true;
    }

    @Override
    public boolean isKnownContentLength() {
        return true;
    }

    @Override
    public long getContentLength() {
        return this.contentLength;
    }

    @Override
    public NContentMetadata getMetaData() {
        return this.md;
    }

    @Override
    public InputStream getInputStream() {
        try {
            this.flush();
        }
        catch (IOException e) {
            throw new NIOException(e);
        }
        if (this.mem) {
            return new ByteArrayInputStream(this.bos.toByteArray());
        }
        return this.file.getInputStream();
    }

    @Override
    public void dispose() {
        try {
            this.close();
        }
        catch (IOException e) {
            throw new NIOException(e);
        }
    }
}

