/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.cache;

import java.util.Objects;
import java.util.function.Supplier;
import net.thevpc.nuts.core.NLocationKey;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.elem.NElementParser;
import net.thevpc.nuts.elem.NElementWriter;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.platform.NStoreType;
import net.thevpc.nuts.runtime.standalone.io.cache.CachedSupplier;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceExt;
import net.thevpc.nuts.util.NBlankable;

public class DefaultCachedSupplier<T>
implements CachedSupplier<T> {
    private final Supplier<T> supplier;
    private T value;
    private String valueCacheId;
    private boolean evaluated;
    private RuntimeException exception;
    private final Class<T> clazz;
    private final CacheValidator<T> validator;
    private NPath cachePath;
    private NPath cacheIdPath;
    private CachedSupplier.NCacheLevel level;
    private NLocationKey key;

    public static <T> DefaultCachedSupplier<T> ofMem(Supplier<T> supplier, CacheValidator<T> validator) {
        return new DefaultCachedSupplier<Object>(CachedSupplier.NCacheLevel.MEM, Object.class, null, supplier, validator);
    }

    public static <T> DefaultCachedSupplier<T> ofNone(Supplier<T> supplier) {
        return new DefaultCachedSupplier<Object>(CachedSupplier.NCacheLevel.NONE, Object.class, null, supplier, null);
    }

    public static <T> DefaultCachedSupplier<T> ofStore(Class<T> clazz, NLocationKey key, Supplier<T> supplier, CacheValidator<T> validator) {
        return new DefaultCachedSupplier<T>(CachedSupplier.NCacheLevel.STORE, clazz, key, supplier, validator);
    }

    public static <T> DefaultCachedSupplier<T> of(CachedSupplier.NCacheLevel level, Class<T> clazz, NLocationKey key, Supplier<T> supplier, CacheValidator<T> validator) {
        return new DefaultCachedSupplier<T>(level, clazz, key, supplier, validator);
    }

    public DefaultCachedSupplier(CachedSupplier.NCacheLevel level, Class<T> clazz, NLocationKey key, Supplier<T> supplier, CacheValidator<T> validator) {
        this.level = level;
        this.key = key;
        this.clazz = clazz;
        this.validator = validator;
        this.supplier = supplier;
        if (this.level.ordinal() >= CachedSupplier.NCacheLevel.STORE.ordinal()) {
            if (key.getStoreType() != NStoreType.CACHE) {
                throw new IllegalArgumentException("expected cache store");
            }
            NWorkspace ws = NWorkspace.of();
            this.cachePath = ws.getStoreLocation(key.getId(), key.getStoreType(), key.getRepoUuid()).resolve(ws.getDefaultIdFilename(key.getId().builder().setFace(key.getName() + ".value.cache").build()));
            this.cacheIdPath = ws.getStoreLocation(key.getId(), key.getStoreType(), key.getRepoUuid()).resolve(ws.getDefaultIdFilename(key.getId().builder().setFace(key.getName() + ".id.cache").build()));
        }
    }

    @Override
    public T getValue() {
        return this.getValue(this.level);
    }

    @Override
    public T getValue(CachedSupplier.NCacheLevel level) {
        if (level == null) {
            level = this.level;
        }
        if (level.ordinal() > this.level.ordinal()) {
            level = this.level;
        }
        switch (level) {
            case NONE: {
                return this.getNoCacheValue();
            }
            case MEM: {
                return this.getMemValue();
            }
            case STORE: {
                return this.getFileValue();
            }
        }
        throw new IllegalArgumentException("unsupported");
    }

    private T getNoCacheValue() {
        return this.supplier.get();
    }

    private String loadCachedId() {
        try {
            if (this.cachePath.isRegularFile()) {
                return this.cacheIdPath.readString().trim();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private T getFileValue() {
        String currentCacheId = null;
        if (this.validator != null && !NBlankable.isBlank(currentCacheId = this.validator.getCacheId()) && !this.validator.isValidCacheId(this.valueCacheId)) {
            this.evaluated = false;
        }
        if (!this.evaluated) {
            if (currentCacheId != null) {
                String loadCacheId = this.loadCachedId();
                if (this.validator == null || this.validator.isValidCacheId(loadCacheId)) {
                    if (CoreIOUtils.isObsoletePath(this.cachePath)) {
                        if (this.cachePath.isRegularFile()) {
                            this.cachePath.delete();
                        }
                    } else {
                        try {
                            T d = NElementParser.ofJson().parse(this.cachePath, this.clazz);
                            if (d != null) {
                                if (this.validator != null && !this.validator.isValidValue(d) && this.cachePath.isRegularFile()) {
                                    this.cachePath.delete();
                                }
                                this.valueCacheId = currentCacheId;
                                this.value = d;
                                return d;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            if (this.supplier == null) {
                this.value = null;
                this.valueCacheId = null;
                this.cachePath.delete();
                this.cacheIdPath.delete();
            } else {
                this.valueCacheId = null;
                this.value = null;
                try {
                    this.value = this.getNoCacheValue();
                    this.valueCacheId = currentCacheId;
                }
                catch (RuntimeException ex) {
                    this.exception = ex;
                }
                catch (Exception ex) {
                    this.exception = new RuntimeException(ex);
                }
                if (this.value != null) {
                    try {
                        NElementWriter.ofJson().write(this.value, this.cachePath);
                    }
                    catch (Exception exception) {}
                } else if (this.cachePath.isRegularFile()) {
                    this.cachePath.delete();
                }
            }
            this.evaluated = true;
        }
        if (this.exception != null) {
            throw this.exception;
        }
        return this.value;
    }

    private T getMemValue() {
        String currentCacheId = null;
        if (!(this.validator == null || NBlankable.isBlank(currentCacheId = this.validator.getCacheId()) && this.validator.isValidCacheId(currentCacheId))) {
            this.evaluated = false;
        }
        if (!this.evaluated) {
            if (this.supplier == null) {
                this.value = null;
                this.valueCacheId = null;
            } else {
                this.valueCacheId = null;
                try {
                    this.value = this.getNoCacheValue();
                    this.valueCacheId = currentCacheId;
                }
                catch (RuntimeException ex) {
                    this.exception = ex;
                }
                catch (Exception ex) {
                    this.exception = new RuntimeException(ex);
                }
            }
            this.evaluated = true;
        }
        if (this.exception != null) {
            throw this.exception;
        }
        return this.value;
    }

    public static interface CacheValidator<T> {
        public String getCacheId();

        default public boolean isValidCacheId(String cacheId) {
            String id = this.getCacheId();
            return NBlankable.isBlank(id) || Objects.equals(cacheId, id);
        }

        public boolean isValidValue(T var1);
    }

    public static class SimpleCacheValidator<T>
    implements CacheValidator<T> {
        @Override
        public String getCacheId() {
            return NWorkspaceExt.of().getModel().installationDigest;
        }

        @Override
        public boolean isValidCacheId(String cacheId) {
            String id = this.getCacheId();
            return NBlankable.isBlank(id) || Objects.equals(cacheId, id);
        }

        @Override
        public boolean isValidValue(T value) {
            return true;
        }
    }
}

