/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.ask;

import net.thevpc.nuts.cmdline.DefaultNArg;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.io.NAsk;
import net.thevpc.nuts.io.NAskParseContext;
import net.thevpc.nuts.io.NAskParser;
import net.thevpc.nuts.runtime.standalone.util.CoreEnumUtils;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NCancelException;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NUnsupportedArgumentException;

public class DefaultNResponseParser<T>
implements NAskParser<T> {
    private final NSession session;
    private final Class<T> type;

    public DefaultNResponseParser(NSession session, Class<T> type) {
        this.session = session;
        this.type = type;
    }

    @Override
    public T parse(NAskParseContext<T> context) {
        Object response = context.response();
        NAsk<T> question = context.question();
        T defaultValue = question.getDefaultValue();
        if (response == null || response instanceof String && response.toString().length() == 0) {
            response = defaultValue;
        }
        if ("cancel!".equals(response)) {
            throw new NCancelException();
        }
        if (response == null) {
            return null;
        }
        if (this.type.isInstance(response)) {
            return (T)response;
        }
        if (this.type.isEnum()) {
            String s = String.valueOf(response).trim();
            return CoreEnumUtils.parseEnumString(s, this.type, false);
        }
        switch (this.type.getName()) {
            case "java.lang.String": {
                return (T)String.valueOf(response);
            }
            case "int": 
            case "java.lang.Integer": {
                return (T)Integer.valueOf(Integer.parseInt(String.valueOf(response)));
            }
            case "long": 
            case "java.lang.Long": {
                return (T)Long.valueOf(Long.parseLong(String.valueOf(response)));
            }
            case "float": 
            case "java.lang.Float": {
                return (T)Float.valueOf(Float.parseFloat(String.valueOf(response)));
            }
            case "double": 
            case "java.lang.Double": {
                return (T)Double.valueOf(Double.parseDouble(String.valueOf(response)));
            }
            case "boolean": 
            case "java.lang.Boolean": {
                String sReponse;
                DefaultNArg a;
                if (!(response instanceof String)) {
                    response = String.valueOf(response);
                }
                if (!(a = new DefaultNArg(sReponse = response.toString())).isBoolean()) {
                    throw new NIllegalArgumentException(NMsg.ofC("invalid response %s", sReponse));
                }
                return (T)a.asBoolean().get();
            }
        }
        throw new NUnsupportedArgumentException(NMsg.ofC("unsupported type %s", this.type.getName()));
    }
}

