/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.log.NMsgIntent;
import net.thevpc.nuts.runtime.standalone.xtra.web.DefaultNWebCli;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.time.NChronometer;
import net.thevpc.nuts.util.NIllegalArgumentException;

public class NReservedMonitoredURLInputStream
extends FilterInputStream {
    public static final int M = 0x100000;
    private NChronometer chronometer;
    private final long contentLength;
    private final NLog log;
    private final URL url;
    long lastSec = -1L;
    long readCount = 0L;
    boolean preDestroyed = false;

    private NReservedMonitoredURLInputStream(InputStream in, URL url, NChronometer chronometer, long contentLength, NLog log) {
        super(in);
        this.chronometer = chronometer;
        this.url = url;
        this.contentLength = contentLength;
        this.log = log;
    }

    public static NReservedMonitoredURLInputStream of(URL url, NLog log) {
        if (log != null) {
            log.log(NMsg.ofC("download %s", url).asFinest().withIntent(NMsgIntent.START));
        }
        NChronometer chronometer = NChronometer.startNow();
        URLConnection c = null;
        try {
            c = url.openConnection();
        }
        catch (IOException ex) {
            if (log != null) {
                log.log(NMsg.ofC("failed to download %s", url).asFinestFail());
            }
            throw new UncheckedIOException("url not accessible " + url, ex);
        }
        DefaultNWebCli.prepareGlobalConnection(c);
        long contentLength = c.getContentLengthLong();
        try {
            return new NReservedMonitoredURLInputStream(c.getInputStream(), url, chronometer, contentLength, log);
        }
        catch (IOException ex) {
            if (log != null) {
                log.log(NMsg.ofC("failed to download %s", url));
            }
            throw new UncheckedIOException("url not accessible " + url, ex);
        }
    }

    @Override
    public int read() throws IOException {
        int r = super.read();
        if (r >= 0) {
            ++this.readCount;
        } else {
            this.preDestroy();
        }
        return r;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int t = super.read(b, off, len);
        if (t > 0) {
            this.readCount += (long)t;
            this.doLog(false);
        } else {
            this.preDestroy();
        }
        return t;
    }

    @Override
    public long skip(long n) throws IOException {
        long t = super.skip(n);
        if (t > 0L) {
            this.readCount += t;
            this.doLog(false);
        } else {
            this.preDestroy();
        }
        return t;
    }

    @Override
    public void close() throws IOException {
        this.preDestroy();
        super.close();
    }

    private void preDestroy() {
        if (!this.preDestroyed) {
            this.preDestroyed = true;
            this.chronometer.stop();
            this.doLog(true);
            if (this.contentLength >= 0L && this.readCount != this.contentLength) {
                this.log.log(NMsg.ofC("failed to downloaded %s. stream closed unexpectedly", this.url).asFineFail());
                throw new NIllegalArgumentException(NMsg.ofC("failed to downloaded %s. stream closed unexpectedly", this.url));
            }
            if (this.log != null) {
                this.log.log(NMsg.ofC("successfully downloaded %s", this.url).asFine().withIntent(NMsgIntent.SUCCESS));
            }
        }
    }

    private void doLog(boolean force) {
        long sec = this.chronometer.getDuration().toSeconds();
        if (sec == this.lastSec && !force) {
            return;
        }
        this.lastSec = sec;
        if (sec == 0L) {
            if (this.contentLength <= 0L) {
                String v = this.formatSize(this.readCount) + "/s";
                if (this.log != null) {
                    this.log.log(NMsg.ofC("%-8s %s/s", v, this.url).withLevel(Level.FINE).withIntent(NMsgIntent.READ));
                }
            } else {
                float f = (float)((double)this.readCount / (double)this.contentLength * 100.0);
                String v = this.formatSize(this.readCount) + "/s";
                if (this.log != null) {
                    this.log.log(NMsg.ofC("%.2f%% %-8s %s", Float.valueOf(f), v, this.url).withLevel(Level.FINE).withIntent(NMsgIntent.READ));
                }
            }
        } else if (this.contentLength <= 0L) {
            String v = this.formatSize(this.readCount / sec) + "/s";
            if (this.log != null) {
                this.log.log(NMsg.ofC("%-8s %s", v, this.url).withLevel(Level.FINE).withIntent(NMsgIntent.READ));
            }
        } else {
            float f = (float)((double)this.readCount / (double)this.contentLength * 100.0);
            String v = this.formatSize(this.readCount / sec) + "/s";
            if (this.log != null) {
                this.log.log(NMsg.ofC("%.2f%% %-8s %s", Float.valueOf(f), v, this.url).withLevel(Level.FINE).withIntent(NMsgIntent.READ));
            }
        }
    }

    private String formatSize(long s) {
        if (s > 0x100000L) {
            long mega = s / 0x100000L;
            if ((s %= 0x100000L) == 0L) {
                return mega + "M";
            }
            String x = String.valueOf((int)((double)s / 1048576.0 * 100.0));
            if (x.length() < 2) {
                return mega + ".0" + x + "M";
            }
            return mega + "." + x + "M";
        }
        if (s > 1024L) {
            long kilo = s / 1024L;
            if ((s %= 1024L) == 0L) {
                return kilo + "K";
            }
            String x = String.valueOf((int)((double)s / 1024.0 * 100.0));
            if (x.length() < 2) {
                return kilo + ".0" + x + "K";
            }
            return kilo + "." + x + "K";
        }
        return s + "B";
    }
}

