/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.installer;

import java.util.ArrayList;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NDefinitionBuilder;
import net.thevpc.nuts.artifact.NDescriptor;
import net.thevpc.nuts.command.NExecCmd;
import net.thevpc.nuts.command.NExecutionContext;
import net.thevpc.nuts.command.NExecutionType;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.runtime.standalone.definition.DefaultNDefinitionBuilder2;
import net.thevpc.nuts.runtime.standalone.definition.DefaultNInstallInfo;
import net.thevpc.nuts.runtime.standalone.executor.NExecutionContextUtils;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.xtra.expr.StringPlaceHolderParser;
import net.thevpc.nuts.spi.NInstallerComponent;
import net.thevpc.nuts.util.NScorableContext;

public class CommandForIdNInstallerComponent
implements NInstallerComponent {
    NDefinition runnerId;

    public CommandForIdNInstallerComponent(NDefinition runnerId) {
        this.runnerId = runnerId;
    }

    @Override
    public void install(NExecutionContext executionContext) {
        this.runMode(executionContext, "install");
    }

    @Override
    public void update(NExecutionContext executionContext) {
        this.runMode(executionContext, "update");
    }

    @Override
    public void uninstall(NExecutionContext executionContext, boolean deleteData) {
        this.runMode(executionContext, "uninstall");
    }

    public void runMode(NExecutionContext executionContext, String mode) {
        NWorkspaceUtils.of().checkReadOnly();
        if (this.runnerId == null) {
            NDefinition definition = executionContext.getDefinition();
            NDescriptor descriptor = definition.getDescriptor();
            if (descriptor.isNutsApplication()) {
                DefaultNDefinitionBuilder2 def2 = new DefaultNDefinitionBuilder2(definition).setInstallInformation(() -> new DefaultNInstallInfo(definition.getInstallInformation().get()).setInstallStatus(definition.getInstallInformation().get().getInstallStatus().withInstalled(true)));
                NExecCmd cmd = NExecCmd.of().setCommandDefinition(def2.build()).addCommand("--nuts-exec-mode=" + mode);
                if (mode.equals("install")) {
                    cmd.addExecutorOptions("--nuts-auto-install=false");
                } else if (mode.equals("uninstall")) {
                    cmd.addExecutorOptions("--nuts-auto-install=false");
                }
                cmd.addCommand(executionContext.getArguments()).setExecutionType(NWorkspace.of().getBootOptions().getExecutionType().orNull()).failFast().run();
            }
        } else {
            NDefinition definition = this.runnerId;
            NDescriptor descriptor = definition.getDescriptor();
            if (descriptor.isNutsApplication()) {
                NDefinitionBuilder def2 = definition.builder().setInstallInformation(new DefaultNInstallInfo(definition.getInstallInformation().get()).setInstallStatus(definition.getInstallInformation().get().getInstallStatus().withInstalled(true)));
                ArrayList<String> eargs = new ArrayList<String>();
                for (String a : executionContext.getExecutorOptions()) {
                    eargs.add(this.evalString(a, mode, executionContext));
                }
                eargs.addAll(executionContext.getArguments());
                NExecCmd.of().setCommandDefinition(def2.build()).addCommand(eargs).setExecutionType(NWorkspace.of().getBootOptions().getExecutionType().orNull()).setExecutionType("net.thevpc.nsh:nsh".equals(def2.getId().getShortName()) ? NExecutionType.EMBEDDED : NExecutionType.SPAWN).failFast().run();
            }
        }
    }

    @Override
    public int getScore(NScorableContext criteria) {
        return 10;
    }

    private String evalString(String s, String mode, NExecutionContext executionContext) {
        return StringPlaceHolderParser.replaceDollarPlaceHolders(s, executionContext, (key, context) -> {
            if ("NUTS_MODE".equals(key)) {
                return mode;
            }
            return NExecutionContextUtils.EXECUTION_CONTEXT_PLACEHOLDER.get(key, (NExecutionContext)context);
        });
    }
}

