/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.id.filter;

import java.util.Objects;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NIdFilter;
import net.thevpc.nuts.artifact.NVersionFilter;
import net.thevpc.nuts.runtime.standalone.util.filters.CoreFilterUtils;
import net.thevpc.nuts.spi.base.AbstractIdFilter;
import net.thevpc.nuts.util.NFilterOp;
import net.thevpc.nuts.util.NSimplifiable;

public class NVersionIdFilter
extends AbstractIdFilter
implements NIdFilter,
NSimplifiable<NIdFilter> {
    private final NVersionFilter filter;

    public NVersionIdFilter(NVersionFilter filter) {
        super(NFilterOp.CONVERT);
        this.filter = filter;
    }

    @Override
    public boolean acceptId(NId other) {
        if (this.filter == null) {
            return true;
        }
        return this.filter.acceptVersion(other.getVersion());
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + Objects.hashCode(this.filter);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NVersionIdFilter other = (NVersionIdFilter)obj;
        return Objects.equals(this.filter, other.filter);
    }

    @Override
    public NIdFilter simplify() {
        NVersionFilter f2 = CoreFilterUtils.simplify(this.filter);
        if (f2 == null) {
            return null;
        }
        if (f2 == this.filter) {
            return this;
        }
        return new NVersionIdFilter(f2);
    }

    public String toString() {
        return String.valueOf(this.filter);
    }
}

