/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.id.filter;

import java.util.Map;
import java.util.Objects;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NIdFilter;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.spi.base.AbstractIdFilter;
import net.thevpc.nuts.util.NFilterOp;
import net.thevpc.nuts.util.NSimplifiable;

public class NIdIdFilter
extends AbstractIdFilter
implements NIdFilter,
NSimplifiable<NIdFilter> {
    private NLog LOG;
    private final NId filter;

    public NIdIdFilter(NId filter) {
        super(NFilterOp.CUSTOM);
        this.filter = filter;
    }

    @Override
    public boolean acceptId(NId id) {
        if (this.filter == null) {
            return true;
        }
        if (this.LOG == null) {
            this.LOG = NLog.of(NIdIdFilter.class);
        }
        if (id.getShortName().equals(this.filter.getShortName())) {
            if (!this.filter.getVersion().filter().acceptVersion(id.getVersion())) {
                return false;
            }
            Map<String, String> e = this.filter.getProperties();
            Map<String, String> m = id.getProperties();
            for (Map.Entry<String, String> v : e.entrySet()) {
                if (Objects.equals(v.getValue(), m.get(v.getKey()))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + Objects.hashCode(this.filter);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NIdIdFilter other = (NIdIdFilter)obj;
        return Objects.equals(this.filter, other.filter);
    }

    @Override
    public NIdFilter simplify() {
        if (this.filter == null) {
            return null;
        }
        return this;
    }

    public String toString() {
        return String.valueOf(this.filter);
    }
}

