/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.id.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NIdFilter;
import net.thevpc.nuts.runtime.standalone.dependency.util.NComplexExpressionString;
import net.thevpc.nuts.runtime.standalone.id.filter.NExprIdFilter;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.util.filters.CoreFilterUtils;
import net.thevpc.nuts.spi.base.AbstractIdFilter;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NFilter;
import net.thevpc.nuts.util.NFilterOp;
import net.thevpc.nuts.util.NSimplifiable;

public class NIdFilterNone
extends AbstractIdFilter
implements NIdFilter,
NSimplifiable<NIdFilter>,
NExprIdFilter {
    private NIdFilter[] children;

    public NIdFilterNone(NIdFilter ... all) {
        super(NFilterOp.NOT);
        ArrayList<NIdFilter> valid = new ArrayList<NIdFilter>();
        if (all != null) {
            for (NIdFilter filter : all) {
                if (filter == null) continue;
                valid.add(filter);
            }
        }
        this.children = valid.toArray(new NIdFilter[0]);
    }

    public NIdFilter[] getChildren() {
        return Arrays.copyOf(this.children, this.children.length);
    }

    @Override
    public boolean acceptId(NId id) {
        if (this.children.length == 0) {
            return true;
        }
        for (NIdFilter filter : this.children) {
            if (!filter.acceptId(id)) continue;
            return false;
        }
        return true;
    }

    @Override
    public NIdFilter simplify() {
        return CoreFilterUtils.simplifyFilterNone(NIdFilter.class, this, this.children);
    }

    @Override
    public String toExpr() {
        StringBuilder sb = new StringBuilder();
        if (this.children.length == 0) {
            return "true";
        }
        if (this.children.length > 1) {
            sb.append("(");
        }
        for (NIdFilter id : this.children) {
            String expr;
            if (sb.length() > 0) {
                sb.append(" && ");
            }
            if (id instanceof NExprIdFilter) {
                NExprIdFilter b = (NExprIdFilter)((Object)id);
                expr = b.toExpr();
                if (NBlankable.isBlank(expr)) {
                    return null;
                }
            } else {
                return null;
            }
            sb.append("(").append(expr).append("')");
        }
        if (this.children.length > 0) {
            sb.append(")");
        }
        return sb.toString();
    }

    public String toString() {
        return CoreStringUtils.trueOrNone(Arrays.stream(this.children).map(NComplexExpressionString::toString).collect(Collectors.toList()));
    }

    public int hashCode() {
        int hash = 7;
        hash = 11 * hash + Arrays.deepHashCode(this.children);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NIdFilterNone other = (NIdFilterNone)obj;
        return Arrays.deepEquals(this.children, other.children);
    }

    @Override
    public List<NFilter> getSubFilters() {
        return Arrays.asList(this.children);
    }
}

