/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.id.filter;

import java.util.List;
import net.thevpc.nuts.artifact.NDefinitionFilter;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NIdFilter;
import net.thevpc.nuts.artifact.NIdFilters;
import net.thevpc.nuts.artifact.NVersionFilter;
import net.thevpc.nuts.runtime.standalone.id.filter.NDefaultVersionIdFilter;
import net.thevpc.nuts.runtime.standalone.id.filter.NDefinitionIdFilter;
import net.thevpc.nuts.runtime.standalone.id.filter.NIdFilterAnd;
import net.thevpc.nuts.runtime.standalone.id.filter.NIdFilterFalse;
import net.thevpc.nuts.runtime.standalone.id.filter.NIdFilterNone;
import net.thevpc.nuts.runtime.standalone.id.filter.NIdFilterOr;
import net.thevpc.nuts.runtime.standalone.id.filter.NIdFilterParser;
import net.thevpc.nuts.runtime.standalone.id.filter.NIdFilterTrue;
import net.thevpc.nuts.runtime.standalone.id.filter.NIdIdFilter;
import net.thevpc.nuts.runtime.standalone.id.filter.NPatternIdFilter;
import net.thevpc.nuts.runtime.standalone.id.filter.NVersionIdFilter;
import net.thevpc.nuts.runtime.standalone.util.filters.InternalNTypedFilters;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NFilter;
import net.thevpc.nuts.util.NScorableContext;

public class InternalNIdFilters
extends InternalNTypedFilters<NIdFilter>
implements NIdFilters {
    public InternalNIdFilters() {
        super(NIdFilter.class);
    }

    @Override
    public NIdFilter byValue(NId id) {
        return new NIdIdFilter(id);
    }

    @Override
    public NIdFilter always() {
        return new NIdFilterTrue();
    }

    @Override
    public NIdFilter not(NFilter other) {
        return new NIdFilterNone((NIdFilter)other);
    }

    @Override
    public NIdFilter never() {
        return new NIdFilterFalse();
    }

    @Override
    public NIdFilter byDefaultVersion(Boolean defaultVersion) {
        if (defaultVersion == null) {
            return this.always();
        }
        return new NDefaultVersionIdFilter(defaultVersion);
    }

    @Override
    public NIdFilter byName(String ... names) {
        if (names == null || names.length == 0) {
            return this.always();
        }
        NIdFilter f = null;
        for (String wildcardId : names) {
            f = f == null ? new NPatternIdFilter(NId.get(wildcardId).get()) : f.or(new NPatternIdFilter(NId.get(wildcardId).get()));
        }
        return f;
    }

    @Override
    public NIdFilter as(NFilter a) {
        if (a instanceof NIdFilter) {
            return (NIdFilter)a;
        }
        if (a instanceof NDefinitionFilter) {
            return new NDefinitionIdFilter((NDefinitionFilter)a);
        }
        if (a instanceof NVersionFilter) {
            return new NVersionIdFilter((NVersionFilter)a);
        }
        return null;
    }

    @Override
    public NIdFilter from(NFilter a) {
        if (a == null) {
            return null;
        }
        NIdFilter t = this.as(a);
        NAssert.requireNonNull(t, "IdFilter");
        return t;
    }

    @Override
    public NIdFilter all(NFilter ... others) {
        List<NIdFilter> all = this.convertList(others);
        for (int i = all.size() - 1; i >= 0; --i) {
            NIdFilter c = (NIdFilter)((NIdFilter)all.get(i)).simplify();
            if (c != null) {
                if (c.equals(this.always())) {
                    if (all.size() <= 1) continue;
                    all.remove(i);
                    continue;
                }
                if (!c.equals(this.never())) continue;
                return this.never();
            }
            all.remove(i);
        }
        if (all.isEmpty()) {
            return this.always();
        }
        if (all.size() == 1) {
            return (NIdFilter)all.get(0);
        }
        return new NIdFilterAnd(all.toArray(new NIdFilter[0]));
    }

    @Override
    public NIdFilter any(NFilter ... others) {
        List<NIdFilter> all = this.convertList(others);
        for (int i = all.size() - 1; i >= 0; --i) {
            NIdFilter c = (NIdFilter)((NIdFilter)all.get(i)).simplify();
            if (c != null) {
                if (c.equals(this.never())) {
                    if (all.size() <= 1) continue;
                    all.remove(i);
                    continue;
                }
                if (!c.equals(this.always())) continue;
                return this.always();
            }
            all.remove(i);
        }
        if (all.isEmpty()) {
            return this.always();
        }
        if (all.size() == 1) {
            return (NIdFilter)all.get(0);
        }
        return new NIdFilterOr(all.toArray(new NIdFilter[0]));
    }

    @Override
    public NIdFilter none(NFilter ... others) {
        List<NIdFilter> all = this.convertList(others);
        if (all.isEmpty()) {
            return this.always();
        }
        return new NIdFilterNone(all.toArray(new NIdFilter[0]));
    }

    @Override
    public NIdFilter parse(String expression) {
        return (NIdFilter)new NIdFilterParser(expression).parse();
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }
}

