/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.yaml;

import java.io.Reader;
import java.util.ArrayList;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementType;
import net.thevpc.nuts.elem.NPairElement;
import net.thevpc.nuts.runtime.standalone.format.yaml.YamlToken;
import net.thevpc.nuts.runtime.standalone.format.yaml.YamlTokenizer;

class YamlParser {
    private YamlTokenizer tokenizer;
    private YamlElement unread;

    YamlParser() {
    }

    public NElement parseElement(Reader reader) {
        YamlElement e;
        this.tokenizer = new YamlTokenizer(reader);
        ArrayList<NElement> all = new ArrayList<NElement>();
        while ((e = this.parseAny(0, AsWhat.ANY)) != null) {
            all.add(e.element);
        }
        if (all.size() == 0) {
            return NElement.ofNull();
        }
        if (all.size() == 1) {
            return (NElement)all.get(0);
        }
        return NElement.ofArray(all.toArray(new NElement[0]));
    }

    private NElement parseAnyNoIndentation() {
        YamlToken t = this.tokenizer.next();
        if (t == null) {
            return null;
        }
        switch (t.type) {
            case OPEN_BRACKET: {
                return this.parseArrayNoIndent(t);
            }
            case OPEN_BRACE: {
                return this.parseObjectNoIndent(t);
            }
            case NAME: 
            case DOUBLE_STRING: 
            case SINGLE_STRING: 
            case NULL: 
            case INTEGER: 
            case DECIMAL: 
            case TRUE: 
            case FALSE: 
            case OPEN_STRING: {
                return this.valElement(t);
            }
        }
        throw new IllegalArgumentException("unexpected token " + (Object)((Object)t.type));
    }

    private YamlElement parseAny(int indentation, AsWhat asVal) {
        if (this.unread != null) {
            if (this.unread.indentation >= indentation) {
                return this.unread;
            }
            return null;
        }
        YamlToken t = this.tokenizer.next();
        if (t == null) {
            return null;
        }
        switch (t.type) {
            case DASH: {
                if (asVal == AsWhat.KEY) {
                    throw new IllegalArgumentException("no allowed key as array element ");
                }
                YamlElement ee = this.parseArrayByDash(t);
                return this.checkIndentation(ee, indentation);
            }
            case OPEN_BRACKET: {
                if (asVal == AsWhat.KEY) {
                    throw new IllegalArgumentException("no allowed key as array element ");
                }
                NElement u = this.parseArrayNoIndent(t);
                YamlElement ee = new YamlElement(u, indentation);
                return this.checkIndentation(ee, indentation);
            }
            case OPEN_BRACE: {
                if (asVal == AsWhat.KEY) {
                    throw new IllegalArgumentException("no allowed key as array element ");
                }
                NElement u = this.parseObjectNoIndent(t);
                YamlElement ee = new YamlElement(u, indentation);
                return this.checkIndentation(ee, indentation);
            }
            case NAME: 
            case DOUBLE_STRING: 
            case SINGLE_STRING: 
            case NULL: 
            case INTEGER: 
            case DECIMAL: 
            case TRUE: 
            case FALSE: 
            case OPEN_STRING: 
            case BLOCK_SCALAR: {
                NElement key = this.valElement(t);
                if ((asVal == AsWhat.KEY || asVal == AsWhat.ANY) && t.hasIndentation() && t.indentation < indentation) {
                    this.tokenizer.pushBack(t);
                    return null;
                }
                if (asVal == AsWhat.KEY) {
                    YamlElement ee = new YamlElement(key, indentation);
                    return this.checkIndentation(ee, indentation);
                }
                if (asVal == AsWhat.VALUE && (!t.hasIndentation() || t.hasIndentation() && t.indentation <= indentation)) {
                    YamlElement ee = new YamlElement(key, indentation);
                    return this.checkIndentation(ee, indentation);
                }
                YamlToken t2 = this.tokenizer.next();
                if (t2 == null) {
                    YamlElement ee = new YamlElement(key, indentation);
                    return this.checkIndentation(ee, indentation);
                }
                if (t2.type == YamlToken.Type.COLON) {
                    YamlElement u = this.parseAny(t.hasIndentation() ? t.indentation : indentation, AsWhat.VALUE);
                    YamlElement ee = this.parseObjectByPairs(NElement.ofPair(key, u.element), t.indentation);
                    return this.checkIndentation(ee, indentation);
                }
                this.tokenizer.pushBack(t2);
                YamlElement ee = new YamlElement(key, indentation);
                return this.checkIndentation(ee, indentation);
            }
        }
        throw new IllegalArgumentException("unexpected token " + (Object)((Object)t.type));
    }

    private YamlElement checkIndentation(YamlElement u, int indentation) {
        if (u != null) {
            if (u.indentation < 0 || u.indentation >= indentation) {
                return u;
            }
            this.unread = u;
            return null;
        }
        return null;
    }

    private NElement valElement(YamlToken t) {
        switch (t.type) {
            case NAME: {
                return NElement.ofName((String)t.value);
            }
            case DOUBLE_STRING: {
                return NElement.ofString((String)t.value, NElementType.DOUBLE_QUOTED_STRING);
            }
            case BLOCK_SCALAR: {
                return NElement.ofString((String)t.value, NElementType.DOUBLE_QUOTED_STRING);
            }
            case SINGLE_STRING: {
                return NElement.ofString((String)t.value, NElementType.SINGLE_QUOTED_STRING);
            }
            case NULL: {
                return NElement.ofNull();
            }
            case INTEGER: 
            case DECIMAL: {
                return NElement.ofNumber((Number)t.value);
            }
            case TRUE: 
            case FALSE: {
                return NElement.ofBoolean((Boolean)t.value);
            }
            case OPEN_STRING: {
                return NElement.ofString((String)t.value, NElementType.DOUBLE_QUOTED_STRING);
            }
        }
        throw new IllegalArgumentException("unexpected token type: " + (Object)((Object)t.type));
    }

    private NElement parseArrayNoIndent(YamlToken t) {
        ArrayList<NElement> list = new ArrayList<NElement>();
        boolean acceptValue = true;
        boolean acceptComma = false;
        boolean acceptClose = true;
        while (true) {
            if ((t = this.tokenizer.next()) == null) {
                throw new IllegalArgumentException("missing ']'");
            }
            if (t.type == YamlToken.Type.COMMA) {
                if (!acceptComma) {
                    throw new IllegalArgumentException("unexpected ','");
                }
                acceptValue = true;
                acceptComma = false;
                acceptClose = false;
                continue;
            }
            if (t.type == YamlToken.Type.CLOSE_BRACKET) {
                if (acceptClose) break;
                throw new IllegalArgumentException("unexpected ']'");
            }
            if (!acceptValue) {
                throw new IllegalArgumentException("unexpected value");
            }
            acceptValue = false;
            acceptComma = true;
            acceptClose = true;
            this.tokenizer.pushBack(t);
            list.add(this.parseAnyNoIndentation());
        }
        return NElement.ofArray(list.toArray(new NElement[0]));
    }

    private NElement parseObjectNoIndent(YamlToken t) {
        ArrayList<NPairElement> list = new ArrayList<NPairElement>();
        boolean acceptValue = true;
        boolean acceptComma = false;
        boolean acceptClose = true;
        while (true) {
            if ((t = this.tokenizer.next()) == null) {
                throw new IllegalArgumentException("missing '}'");
            }
            if (t.type == YamlToken.Type.COMMA) {
                if (!acceptComma) {
                    throw new IllegalArgumentException("unexpected ','");
                }
                acceptValue = true;
                acceptComma = false;
                acceptClose = false;
                continue;
            }
            if (t.type == YamlToken.Type.CLOSE_BRACE) {
                if (acceptClose) break;
                throw new IllegalArgumentException("unexpected ']'");
            }
            if (!acceptValue) {
                throw new IllegalArgumentException("unexpected value");
            }
            acceptValue = false;
            acceptComma = true;
            acceptClose = true;
            this.tokenizer.pushBack(t);
            NElement key = this.parseAnyNoIndentation();
            t = this.tokenizer.next();
            if (t == null || t.type != YamlToken.Type.COLON) {
                throw new IllegalArgumentException("missing ':'");
            }
            NElement value = this.parseAnyNoIndentation();
            list.add(NElement.ofPair(key, value));
        }
        return NElement.ofObject(list.toArray(new NElement[0]));
    }

    private YamlElement parseObjectByPairs(NPairElement pair, int indentation) {
        YamlElement a;
        ArrayList<NPairElement> list = new ArrayList<NPairElement>();
        list.add(pair);
        while ((a = this.parseAny(indentation, AsWhat.KEY)) != null) {
            YamlToken t = this.tokenizer.next();
            if (t == null || t.type != YamlToken.Type.COLON) {
                throw new IllegalArgumentException("missing ':'");
            }
            YamlElement b = this.parseAny(indentation, AsWhat.VALUE);
            list.add(NElement.ofPair(a.element, b.element));
        }
        return new YamlElement(NElement.ofObject(list.toArray(new NElement[0])), indentation);
    }

    private YamlElement parseArrayByDash(YamlToken dash) {
        YamlToken t;
        ArrayList<NElement> list = new ArrayList<NElement>();
        YamlElement afterDash = this.parseAny(dash.indentation, AsWhat.ANY);
        if (afterDash == null) {
            throw new IllegalArgumentException("unexpected end of array");
        }
        list.add(afterDash.element);
        while ((t = this.tokenizer.next()) != null) {
            if (t.type == YamlToken.Type.DASH && t.indentation == dash.indentation) {
                afterDash = this.parseAny(dash.indentation, AsWhat.ANY);
                if (afterDash == null) {
                    throw new IllegalArgumentException("unexpected end of array");
                }
                list.add(afterDash.element);
                continue;
            }
            this.tokenizer.pushBack(t);
            break;
        }
        return new YamlElement(NElement.ofArray(list.toArray(new NElement[0])), dash.indentation);
    }

    private static enum AsWhat {
        KEY,
        VALUE,
        ANY;

    }

    private static class YamlElement {
        NElement element;
        int indentation;

        public YamlElement(NElement element, int indentation) {
            this.element = element;
            this.indentation = indentation;
        }
    }
}

