/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.yaml;

import java.util.Base64;
import java.util.List;
import net.thevpc.nuts.elem.NBinaryStreamElement;
import net.thevpc.nuts.elem.NCharStreamElement;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementFactoryContext;
import net.thevpc.nuts.elem.NElementType;
import net.thevpc.nuts.elem.NObjectElement;
import net.thevpc.nuts.elem.NObjectElementBuilder;
import net.thevpc.nuts.elem.NOperatorElement;
import net.thevpc.nuts.elem.NPairElement;
import net.thevpc.nuts.io.NInputSource;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NStringUtils;

public class YamlFormat {
    private NElement str(String any) {
        StringBuilder sb = new StringBuilder();
        for (char c : any.toCharArray()) {
            sb.append(NStringUtils.escapeChar(c));
        }
        return NElement.ofString(sb.toString());
    }

    private NElement ensureYaml(NElement value) {
        switch (value.type().typeGroup()) {
            case OPERATOR: {
                NOperatorElement ope = (NOperatorElement)value;
                NObjectElementBuilder value1 = NElement.ofObjectBuilder().copyFrom(value);
                value1.clearChildren();
                value1.set("op", ope.type().opSymbol());
                value1.set("mode", ope.operatorType().id());
                value1.name(null);
                if (ope.first().isPresent()) {
                    value1.set("$first", ope.first().get());
                }
                if (ope.second().isPresent()) {
                    value1.set("$second", ope.second().get());
                }
                return value1.build();
            }
        }
        switch (value.type()) {
            case BIG_COMPLEX: 
            case FLOAT_COMPLEX: 
            case DOUBLE_COMPLEX: 
            case LOCAL_DATE: 
            case LOCAL_DATETIME: 
            case LOCAL_TIME: 
            case REGEX: 
            case LINE_STRING: 
            case ANTI_QUOTED_STRING: 
            case TRIPLE_ANTI_QUOTED_STRING: 
            case TRIPLE_DOUBLE_QUOTED_STRING: 
            case TRIPLE_SINGLE_QUOTED_STRING: 
            case INSTANT: 
            case CUSTOM: {
                return this.str(value.toString());
            }
            case SINGLE_QUOTED_STRING: {
                String s = value.asStringValue().get();
                if (s.codePoints().anyMatch(codePoint -> codePoint < 32)) {
                    return this.str(value.asStringValue().get());
                }
                return value;
            }
            case DOUBLE_QUOTED_STRING: {
                return this.str(value.asStringValue().get());
            }
            case NAME: {
                return value;
            }
            case BINARY_STREAM: {
                NBinaryStreamElement value1 = (NBinaryStreamElement)value;
                String s = Base64.getEncoder().encodeToString(NInputSource.of(value1.value()).readBytes());
                return NElement.ofPrimitiveBuilder().copyFrom(value).setString(s).build();
            }
            case CHAR_STREAM: {
                NCharStreamElement value1 = (NCharStreamElement)value;
                String s = NInputSource.of(value1.value()).readString();
                return NElement.ofPrimitiveBuilder().copyFrom(value).setString(s).build();
            }
            case NAMED_OBJECT: 
            case PARAMETRIZED_OBJECT: 
            case NAMED_PARAMETRIZED_OBJECT: {
                NObjectElementBuilder value1 = ((NObjectElement)value).builder();
                if (value1.name().isPresent()) {
                    value1.set("$name", value1.name().get());
                    value1.name(null);
                }
                if (value1.params().isPresent()) {
                    value1.set("$params", (NElement)NElement.ofArray(value1.params().get().toArray(new NElement[0])));
                    value1.setParametrized(false);
                }
                return value1.build();
            }
            case NAMED_ARRAY: 
            case PARAMETRIZED_ARRAY: 
            case NAMED_PARAMETRIZED_ARRAY: {
                NObjectElementBuilder value1 = NElement.ofObjectBuilder().copyFrom(value);
                if (value1.name().isPresent()) {
                    value1.set("$name", value1.name().get());
                    value1.name(null);
                }
                if (value1.params().isPresent()) {
                    value1.set("$params", (NElement)NElement.ofArray(value1.params().get().toArray(new NElement[0])));
                    value1.setParametrized(false);
                }
                value1.set("$array", (NElement)NElement.ofArray(value1.children().toArray(new NElement[0])));
                return value1.build();
            }
            case UPLET: 
            case NAMED_UPLET: {
                NObjectElementBuilder value1 = NElement.ofObjectBuilder().copyFrom(value);
                List<NElement> children = value1.children();
                value1.clearChildren();
                if (value1.name().isPresent()) {
                    value1.set("$name", value1.name().get());
                    value1.name(null);
                }
                if (value1.params().isPresent()) {
                    value1.set("$params", (NElement)NElement.ofArray(value1.params().get().toArray(new NElement[0])));
                    value1.setParametrized(false);
                }
                value1.set("$array", (NElement)NElement.ofArray(children.toArray(new NElement[0])));
                return value1.build();
            }
            case MATRIX: {
                return NElement.ofArrayBuilder().copyFrom(value).build();
            }
            case NAMED_PARAMETRIZED_MATRIX: 
            case PARAMETRIZED_MATRIX: 
            case NAMED_MATRIX: {
                NObjectElementBuilder value1 = NElement.ofObjectBuilder().copyFrom(value);
                List<NElement> children = value1.children();
                value1.clearChildren();
                if (value1.name().isPresent()) {
                    value1.set("$name", value1.name().get());
                    value1.name(null);
                }
                if (value1.params().isPresent()) {
                    value1.set("$params", (NElement)NElement.ofArray(value1.params().get().toArray(new NElement[0])));
                    value1.setParametrized(false);
                }
                value1.set("$array", (NElement)NElement.ofArray(children.toArray(new NElement[0])));
                return value1.build();
            }
            case PAIR: {
                NObjectElementBuilder value1 = NElement.ofObjectBuilder().copyFrom(value);
                return value1.build();
            }
            case OBJECT: 
            case ARRAY: 
            case BOOLEAN: 
            case INT: 
            case FLOAT: 
            case SHORT: 
            case DOUBLE: 
            case LONG: 
            case CHAR: 
            case BYTE: 
            case BIG_INT: 
            case BIG_DECIMAL: 
            case ALIAS: 
            case NULL: {
                return value;
            }
        }
        throw new NIllegalArgumentException(NMsg.ofC("unsupported %s for yaml", value));
    }

    void formatNode(NElement value, NPrintStream out, boolean compact, NElementFactoryContext context, int indentLevel) {
        value = this.ensureYaml(value);
        String indent = NStringUtils.repeat("   ", indentLevel);
        switch (value.type()) {
            case NULL: {
                out.print("null");
                break;
            }
            case BOOLEAN: 
            case INT: 
            case FLOAT: 
            case DOUBLE: 
            case LONG: 
            case BYTE: 
            case BIG_INT: 
            case BIG_DECIMAL: {
                out.print(value.toString());
                break;
            }
            case DOUBLE_QUOTED_STRING: {
                out.print(value.asLiteral().toStringLiteral());
                break;
            }
            case ALIAS: {
                out.print(value.toString());
                break;
            }
            case OBJECT: {
                boolean first = true;
                for (NPairElement entry : value.asObject().get().pairs().toArray(new NPairElement[0])) {
                    if (!first) {
                        out.print("\n");
                    }
                    first = false;
                    NElement key = entry.key();
                    NElement val = entry.value();
                    if (this.isComplexType(key)) {
                        out.print(indent);
                        out.print("?\n");
                        this.formatNode(key, out, compact, context, indentLevel + 1);
                        out.print(indent);
                        out.print(":");
                        if (this.isComplexType(val)) {
                            out.print("\n");
                            this.formatNode(val, out, compact, context, indentLevel + 1);
                            continue;
                        }
                        out.print(" ");
                        this.formatNode(val, out, compact, context, indentLevel + 1);
                        continue;
                    }
                    out.print(indent);
                    this.formatNode(key, out, compact, context, indentLevel);
                    out.print(":");
                    if (this.isComplexType(val)) {
                        out.print("\n");
                        this.formatNode(val, out, compact, context, indentLevel + 1);
                        continue;
                    }
                    out.print(" ");
                    this.formatNode(val, out, compact, context, indentLevel);
                }
                break;
            }
            case ARRAY: {
                boolean first = true;
                for (NElement a : value.asArray().get()) {
                    if (!first) {
                        out.print("\n");
                    }
                    first = false;
                    out.print(indent);
                    out.print("- ");
                    if (a.type() == NElementType.OBJECT || a.type() == NElementType.ARRAY) {
                        out.print("\n");
                        this.formatNode(a, out, compact, context, indentLevel + 1);
                        continue;
                    }
                    this.formatNode(a, out, compact, context, indentLevel);
                }
                break;
            }
            default: {
                out.print(value.toString());
            }
        }
    }

    private boolean isComplexType(NElement value) {
        return value.type() == NElementType.ARRAY || value.type() == NElementType.OBJECT;
    }
}

