/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.xml;

import java.io.File;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;
import java.util.function.Supplier;
import net.thevpc.nuts.elem.NArrayElementBuilder;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementFactoryContext;
import net.thevpc.nuts.elem.NElementMapper;
import net.thevpc.nuts.elem.NElementType;
import net.thevpc.nuts.elem.NElements;
import net.thevpc.nuts.elem.NObjectElementBuilder;
import net.thevpc.nuts.elem.NPairElement;
import net.thevpc.nuts.runtime.standalone.format.xml.XmlUtils;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NStringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class NElementFactoryXmlElement
implements NElementMapper<Node> {
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_TYPE = "type";
    public static final String ATTRIBUTE_VALUE = "value";
    public static final String ATTRIBUTE_VALUE_TYPE = "value-type";
    public static final String ATTRIBUTE_ENTRY_VALUE = "entry-value";
    private static final String ATTRIBUTE_KEY = "key";
    private static final String ATTRIBUTE_ENTRY_KEY = "entry-key";
    public static final String TAG_OBJECT = "object";
    public static final String TAG_PATH = "path";
    public static final String TAG_FILE = "file";
    public static final String TAG_DATE = "date";
    public static final String TAG_INSTANT = "instant";
    public static final String TAG_STRING = "string";
    public static final String TAG_NULL = "null";
    public static final String TAG_CHAR = "char";
    public static final String TAG_DOUBLE = "double";
    public static final String TAG_FLOAT = "float";
    public static final String TAG_INT = "int";
    public static final String TAG_LONG = "long";
    public static final String TAG_SHORT = "short";
    public static final String TAG_BYTE = "byte";
    public static final String TAG_TRUE = "true";
    public static final String TAG_FALSE = "false";
    public static final String TAG_BOOLEAN = "boolean";
    public static final String TAG_ARRAY = "array";
    public static final String TAG_ENTRY = "entry";
    private static final String FIELD_TEXT = "content";
    private static final String FIELD_TAG_NAME = "tagName";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V> V runWithDoc(NElementFactoryContext context, Supplier<V> impl, Document doc) {
        Stack<Document> docs = (Stack<Document>)context.getProperties().get(Document.class.getName());
        if (docs == null) {
            docs = new Stack<Document>();
            context.getProperties().put(Document.class.getName(), docs);
            try {
                docs.push(doc != null ? doc : XmlUtils.createDocument());
                V v = impl.get();
                return v;
            }
            finally {
                docs.pop();
            }
        }
        if (docs.isEmpty() || doc != null) {
            try {
                docs.push(doc != null ? doc : XmlUtils.createDocument());
                V v = impl.get();
                return v;
            }
            finally {
                docs.pop();
            }
        }
        return impl.get();
    }

    @Override
    public Node createObject(NElement elem, Type typeOfResult, NElementFactoryContext context) {
        return NElementFactoryXmlElement.runWithDoc(context, () -> this.createObject0(elem, typeOfResult, context), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Node createObject0(NElement elem, Type typeOfResult, NElementFactoryContext context) {
        if (context.getProperties().get(Document.class.getName()) == null || !(context.getProperties().get(Document.class.getName()) instanceof Stack)) {
            Stack<Document> docs = new Stack<Document>();
            context.getProperties().put(Document.class.getName(), docs);
            try {
                docs.push(XmlUtils.createDocument());
                Node node = this.createObject(elem, typeOfResult, context);
                return node;
            }
            finally {
                docs.pop();
            }
        }
        Stack docs = (Stack)context.getProperties().get(Document.class.getName());
        if (docs.isEmpty()) {
            try {
                docs.push(XmlUtils.createDocument());
                Node node = this.createObject(elem, typeOfResult, context);
                return node;
            }
            finally {
                docs.pop();
            }
        }
        Document doc = (Document)((Stack)context.getProperties().get(Document.class.getName())).peek();
        switch (elem.type()) {
            case NULL: {
                Element e = doc.createElement(TAG_NULL);
                return e;
            }
            case DOUBLE_QUOTED_STRING: 
            case SINGLE_QUOTED_STRING: 
            case ANTI_QUOTED_STRING: 
            case TRIPLE_DOUBLE_QUOTED_STRING: 
            case TRIPLE_SINGLE_QUOTED_STRING: 
            case TRIPLE_ANTI_QUOTED_STRING: 
            case LINE_STRING: {
                Element e = doc.createElement(TAG_STRING);
                String s = elem.asStringValue().get();
                if (this.isComplexString(s)) {
                    e.setTextContent(s);
                } else {
                    e.setAttribute(ATTRIBUTE_VALUE, s);
                }
                return e;
            }
            case BOOLEAN: {
                return doc.createElement(elem.asBooleanValue().get() != false ? TAG_TRUE : TAG_FALSE);
            }
            case BYTE: {
                Element e = doc.createElement(TAG_BYTE);
                e.setAttribute(ATTRIBUTE_VALUE, String.valueOf(elem.asByteValue().get()));
                return e;
            }
            case SHORT: {
                Element e = doc.createElement(TAG_SHORT);
                e.setAttribute(ATTRIBUTE_VALUE, String.valueOf(elem.asShortValue().get()));
                return e;
            }
            case INT: {
                Element e = doc.createElement(TAG_INT);
                e.setAttribute(ATTRIBUTE_VALUE, String.valueOf(elem.asIntValue().get()));
                return e;
            }
            case LONG: {
                Element e = doc.createElement(TAG_LONG);
                e.setAttribute(ATTRIBUTE_VALUE, String.valueOf(elem.asLongValue().get()));
                return e;
            }
            case FLOAT: {
                Element e = doc.createElement(TAG_FLOAT);
                e.setAttribute(ATTRIBUTE_VALUE, String.valueOf(elem.asFloatValue().get()));
                return e;
            }
            case DOUBLE: {
                Element e = doc.createElement(TAG_DOUBLE);
                e.setAttribute(ATTRIBUTE_VALUE, String.valueOf(elem.asDoubleValue().get()));
                return e;
            }
            case INSTANT: {
                Element e = doc.createElement(TAG_INSTANT);
                e.setAttribute(ATTRIBUTE_VALUE, elem.asInstantValue().get().toString());
                return e;
            }
            case ARRAY: {
                Element e = doc.createElement(TAG_ARRAY);
                int count = 0;
                for (NElement attribute : elem.asArray().get().children()) {
                    Node c = this.createObject(attribute, (Type)((Object)Element.class), context);
                    if (c == null) continue;
                    e.appendChild(c);
                    ++count;
                }
                return e;
            }
            case OBJECT: {
                Element obj = doc.createElement(TAG_OBJECT);
                for (NElement nn : elem.asObject().get().children()) {
                    if (nn instanceof NPairElement) {
                        Element ev;
                        boolean complexKey;
                        NPairElement ne = (NPairElement)nn;
                        NElementType kt = ne.key().type();
                        boolean bl = complexKey = kt == NElementType.ARRAY || kt == NElementType.OBJECT || kt.isAnyString() && this.isComplexString(ne.key().asStringValue().get());
                        if (complexKey) {
                            Element entry = doc.createElement(TAG_ENTRY);
                            Element ek = (Element)this.createObject(ne.key(), (Type)((Object)NElement.class), context);
                            ek.setAttribute(ATTRIBUTE_ENTRY_KEY, null);
                            entry.appendChild(ek);
                            ev = (Element)this.createObject(ne.value(), (Type)((Object)NElement.class), context);
                            ev.setAttribute(ATTRIBUTE_ENTRY_VALUE, null);
                            entry.appendChild(ev);
                            obj.appendChild(entry);
                            continue;
                        }
                        String tagName = ne.key().type() == NElementType.BOOLEAN ? ne.key().asStringValue().get() : ne.key().type().id();
                        Element entryElem = doc.createElement(tagName);
                        if (ne.key().type() != NElementType.BOOLEAN && ne.key().type() != NElementType.NULL) {
                            entryElem.setAttribute(ATTRIBUTE_KEY, ne.key().asStringValue().get());
                        }
                        switch (ne.value().type()) {
                            case ARRAY: 
                            case OBJECT: {
                                ev = (Element)this.createObject(ne.value(), (Type)((Object)NElement.class), context);
                                ev.setAttribute(ATTRIBUTE_ENTRY_VALUE, null);
                                entryElem.appendChild(ev);
                                obj.appendChild(entryElem);
                                break;
                            }
                            case NULL: {
                                entryElem.setAttribute(ATTRIBUTE_VALUE_TYPE, ne.value().type().id());
                                obj.appendChild(entryElem);
                                break;
                            }
                            case DOUBLE_QUOTED_STRING: 
                            case SINGLE_QUOTED_STRING: 
                            case ANTI_QUOTED_STRING: 
                            case TRIPLE_DOUBLE_QUOTED_STRING: 
                            case TRIPLE_SINGLE_QUOTED_STRING: 
                            case TRIPLE_ANTI_QUOTED_STRING: 
                            case LINE_STRING: {
                                entryElem.setAttribute(ATTRIBUTE_VALUE, ne.value().asStringValue().get());
                                obj.appendChild(entryElem);
                                break;
                            }
                            default: {
                                entryElem.setAttribute(ATTRIBUTE_VALUE, ne.value().asStringValue().get());
                                entryElem.setAttribute(ATTRIBUTE_VALUE_TYPE, ne.value().type().id());
                                obj.appendChild(entryElem);
                            }
                        }
                        continue;
                    }
                    Node c = this.createObject(nn, (Type)((Object)Element.class), context);
                    if (c == null) continue;
                    obj.appendChild(c);
                }
                return obj;
            }
        }
        throw new IllegalArgumentException("Unsupported create Object for element type " + elem.type());
    }

    public NElement createElement(String type, String value, NElementFactoryContext context) {
        switch (type) {
            case "null": {
                return NElement.ofNull();
            }
            case "number": {
                return context.createElement(value, (Type)((Object)Number.class));
            }
            case "boolean": {
                return context.createElement(value, (Type)((Object)Boolean.class));
            }
            case "true": {
                return NElement.ofTrue();
            }
            case "false": {
                return NElement.ofFalse();
            }
            case "byte": {
                return context.createElement(value, (Type)((Object)Byte.class));
            }
            case "short": {
                return context.createElement(value, (Type)((Object)Short.class));
            }
            case "int": {
                return context.createElement(value, (Type)((Object)Integer.class));
            }
            case "long": {
                return context.createElement(value, (Type)((Object)Long.class));
            }
            case "float": {
                return context.createElement(value, (Type)((Object)Float.class));
            }
            case "double": {
                return context.createElement(value, (Type)((Object)Double.class));
            }
            case "char": {
                return context.createElement(value, (Type)((Object)Character.class));
            }
            case "string": {
                return context.createElement(value, (Type)((Object)String.class));
            }
            case "nuts-string": {
                return context.createElement(value, (Type)((Object)NText.class));
            }
            case "instant": {
                return context.createElement(value, (Type)((Object)Instant.class));
            }
            case "date": {
                return context.createElement(value, (Type)((Object)Date.class));
            }
            case "file": {
                return context.createElement(value, (Type)((Object)File.class));
            }
            case "path": {
                return context.createElement(value, (Type)((Object)Path.class));
            }
        }
        NElements elements = NElements.of();
        throw new IllegalArgumentException("unsupported create Xml Element for type " + type);
    }

    private boolean isComplexString(String string) {
        return string.contains("\n") || string.length() > 120;
    }

    private String resolveValue(Element e) {
        String value1 = e.getAttribute(ATTRIBUTE_VALUE);
        String value2 = e.getTextContent();
        if (NStringUtils.isEmpty(value2)) {
            return value1;
        }
        if (NStringUtils.isEmpty(value1)) {
            return value2;
        }
        return value1 + value2;
    }

    @Override
    public Object destruct(Node node, Type typeOfSrc, NElementFactoryContext context) {
        if (node instanceof Attr) {
            Attr at = (Attr)node;
            return new AbstractMap.SimpleEntry<String, Object>(at.getName(), context.destruct(at.getValue(), (Type)((Object)String.class)));
        }
        if (node instanceof CDATASection) {
            CDATASection d = (CDATASection)node;
            return d.getWholeText();
        }
        if (node instanceof Text) {
            Text d = (Text)node;
            return d.getWholeText();
        }
        Element element = (Element)node;
        NodeInfo ni = new NodeInfo(element);
        switch (ni.type) {
            case "object": {
                HashSet<String> visited = new HashSet<String>();
                boolean map = true;
                ArrayList<AbstractMap.SimpleEntry<String, String>> all = new ArrayList<AbstractMap.SimpleEntry<String, String>>();
                NamedNodeMap attrs = element.getAttributes();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    Attr n = (Attr)attrs.item(i);
                    String string = n.getName();
                    String v = n.getValue();
                    if (map && visited.contains(string)) {
                        map = false;
                    } else {
                        visited.add(string);
                    }
                    all.add(new AbstractMap.SimpleEntry<String, String>(string, v));
                }
                if (map) {
                    LinkedHashMap m = new LinkedHashMap();
                    for (Map.Entry entry : all) {
                        m.put(entry.getKey(), entry.getValue());
                    }
                    return m;
                }
                return all;
            }
            case "array": {
                ArrayList<NElement> obj = new ArrayList<NElement>();
                NodeList attrs = element.getChildNodes();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    Node n = attrs.item(i);
                    obj.add(this.createElement(n, typeOfSrc, context));
                }
                return obj;
            }
            case "boolean": {
                return context.destruct(this.resolveValue(element), (Type)((Object)Boolean.class));
            }
            case "byte": {
                return context.destruct(this.resolveValue(element), (Type)((Object)Byte.class));
            }
            case "short": {
                return context.destruct(this.resolveValue(element), (Type)((Object)Short.class));
            }
            case "int": {
                return context.destruct(this.resolveValue(element), (Type)((Object)Integer.class));
            }
            case "long": {
                return context.destruct(this.resolveValue(element), (Type)((Object)Long.class));
            }
            case "float": {
                return context.destruct(this.resolveValue(element), (Type)((Object)Float.class));
            }
            case "double": {
                return context.destruct(this.resolveValue(element), (Type)((Object)Double.class));
            }
            case "char": {
                return context.destruct(this.resolveValue(element), (Type)((Object)Character.class));
            }
            case "string": {
                return context.destruct(this.resolveValue(element), (Type)((Object)String.class));
            }
            case "instant": {
                return context.destruct(this.resolveValue(element), (Type)((Object)Instant.class));
            }
            case "date": {
                return context.destruct(this.resolveValue(element), (Type)((Object)Date.class));
            }
            case "file": {
                return context.destruct(this.resolveValue(element), (Type)((Object)File.class));
            }
            case "path": {
                return context.destruct(this.resolveValue(element), (Type)((Object)Path.class));
            }
        }
        throw new IllegalArgumentException("unsupported");
    }

    @Override
    public NElement createElement(Node node, Type typeOfSrc, NElementFactoryContext context) {
        return this.createElement(node, typeOfSrc, context, true);
    }

    public NElement createElementObject(Node node, Type typeOfSrc, NElementFactoryContext context, boolean includeTagName) {
        Element element = (Element)node;
        NodeInfo ni = new NodeInfo(element);
        String tagName = element.getTagName();
        NObjectElementBuilder obj = NElement.ofObjectBuilder();
        int content = 0;
        int nonContent = 0;
        if (includeTagName) {
            this.setObjectField(obj, FIELD_TAG_NAME, NElement.ofString(tagName));
        }
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr n = (Attr)attrs.item(i);
            this.setObjectField(obj, n.getName(), context.createElement(n.getValue()));
            ++nonContent;
        }
        NodeList children = element.getChildNodes();
        StringBuilder allContent = new StringBuilder();
        int subElements = 0;
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            if (n instanceof Element) {
                Element e = (Element)n;
                NodeInfo ni2 = new NodeInfo(e);
                this.setObjectField(obj, ni2.name, this.createElement(e, null, context, false));
                ++nonContent;
                ++subElements;
                continue;
            }
            if (!(n instanceof Text)) continue;
            String ht = ((Text)n).getWholeText();
            if (NBlankable.isBlank(ht)) {
                if (subElements > 0) continue;
                allContent.append(ht);
                continue;
            }
            allContent.append(ht);
            NElement e = this.createElement(n, (Type)((Object)Text.class), context);
            this.setObjectField(obj, FIELD_TEXT, e);
            ++content;
        }
        if (content == 0 && nonContent == 0) {
            return NElement.ofString("");
        }
        if (content >= 0 && nonContent == 0) {
            return NElement.ofString(allContent.toString());
        }
        return obj.build();
    }

    public NElement createElement(Node node, Type typeOfSrc, NElementFactoryContext context, boolean includeTagName) {
        if (node instanceof Attr) {
            Attr at = (Attr)node;
            return NElement.ofObjectBuilder().set(at.getName(), context.createElement(at.getValue(), (Type)((Object)String.class))).build();
        }
        if (node instanceof CDATASection) {
            CDATASection d = (CDATASection)node;
            return NElement.ofString(d.getWholeText());
        }
        if (node instanceof Text) {
            Text d = (Text)node;
            return NElement.ofString(d.getWholeText());
        }
        Element element = (Element)node;
        NodeInfo ni = new NodeInfo(element);
        switch (ni.type) {
            case "array": {
                if (element.getAttributes().getLength() == 0) {
                    NArrayElementBuilder obj = NElement.ofArrayBuilder();
                    NodeList nodes = element.getChildNodes();
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        Node n = nodes.item(i);
                        obj.add(this.createElement(n, typeOfSrc, context));
                    }
                    return obj.build();
                }
                return this.createElementObject(node, typeOfSrc, context, includeTagName);
            }
            case "true": {
                if (this.isEmptyXmlElement(element)) {
                    return NElement.ofTrue();
                }
                return this.createElementObject(node, typeOfSrc, context, includeTagName);
            }
            case "boolean": {
                if (this.isTextOnlyXmlElement(element)) {
                    return context.createElement(this.resolveValue(element), (Type)((Object)Boolean.class));
                }
                return this.createElementObject(node, typeOfSrc, context, includeTagName);
            }
            case "byte": {
                if (this.isTextOnlyXmlElement(element)) {
                    return context.createElement(this.resolveValue(element), (Type)((Object)Byte.class));
                }
                return this.createElementObject(node, typeOfSrc, context, includeTagName);
            }
            case "short": {
                if (this.isTextOnlyXmlElement(element)) {
                    return context.createElement(this.resolveValue(element), (Type)((Object)Short.class));
                }
                return this.createElementObject(node, typeOfSrc, context, includeTagName);
            }
            case "int": {
                if (this.isTextOnlyXmlElement(element)) {
                    return context.createElement(this.resolveValue(element), (Type)((Object)Integer.class));
                }
                return this.createElementObject(node, typeOfSrc, context, includeTagName);
            }
            case "long": {
                if (this.isTextOnlyXmlElement(element)) {
                    return context.createElement(this.resolveValue(element), (Type)((Object)Long.class));
                }
                return this.createElementObject(node, typeOfSrc, context, includeTagName);
            }
            case "float": {
                if (this.isTextOnlyXmlElement(element)) {
                    return context.createElement(this.resolveValue(element), (Type)((Object)Float.class));
                }
                return this.createElementObject(node, typeOfSrc, context, includeTagName);
            }
            case "double": {
                if (this.isTextOnlyXmlElement(element)) {
                    return context.createElement(this.resolveValue(element), (Type)((Object)Double.class));
                }
                return this.createElementObject(node, typeOfSrc, context, includeTagName);
            }
            case "char": {
                if (this.isTextOnlyXmlElement(element)) {
                    return context.createElement(this.resolveValue(element), (Type)((Object)Character.class));
                }
                return this.createElementObject(node, typeOfSrc, context, includeTagName);
            }
            case "string": {
                if (this.isTextOnlyXmlElement(element)) {
                    return context.createElement(this.resolveValue(element), (Type)((Object)String.class));
                }
                return this.createElementObject(node, typeOfSrc, context, includeTagName);
            }
            case "instant": {
                if (this.isTextOnlyXmlElement(element)) {
                    return context.createElement(this.resolveValue(element), (Type)((Object)Instant.class));
                }
                return this.createElementObject(node, typeOfSrc, context, includeTagName);
            }
            case "date": {
                if (this.isTextOnlyXmlElement(element)) {
                    return context.createElement(this.resolveValue(element), (Type)((Object)Date.class));
                }
                return this.createElementObject(node, typeOfSrc, context, includeTagName);
            }
            case "file": {
                if (this.isTextOnlyXmlElement(element)) {
                    return context.createElement(this.resolveValue(element), (Type)((Object)File.class));
                }
                return this.createElementObject(node, typeOfSrc, context, includeTagName);
            }
            case "path": {
                if (this.isTextOnlyXmlElement(element)) {
                    return context.createElement(this.resolveValue(element), (Type)((Object)Path.class));
                }
                return this.createElementObject(node, typeOfSrc, context, includeTagName);
            }
        }
        return this.createElementObject(node, typeOfSrc, context, includeTagName);
    }

    private boolean isTextOnlyXmlElement(Element element) {
        boolean hasAttrValue = false;
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr n = (Attr)attrs.item(i);
            if (!n.getName().equals(ATTRIBUTE_VALUE)) {
                return false;
            }
            hasAttrValue = true;
        }
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            if (n instanceof Text) {
                String ht = ((Text)n).getWholeText();
                if (NBlankable.isBlank(ht) || !hasAttrValue) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private boolean isEmptyXmlElement(Element element) {
        int i = 0;
        NamedNodeMap attrs = element.getAttributes();
        if (i < attrs.getLength()) {
            Attr n = (Attr)attrs.item(i);
            return false;
        }
        NodeList nodes = element.getChildNodes();
        for (int i2 = 0; i2 < nodes.getLength(); ++i2) {
            Node n = nodes.item(i2);
            if (n instanceof Text) {
                String ht = ((Text)n).getWholeText();
                if (NBlankable.isBlank(ht)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private void setObjectField(NObjectElementBuilder obj, String name, NElement e) {
        obj.add(name, e);
    }

    private static class NodeInfo {
        String type;
        String name;
        String value;

        public NodeInfo(Element e) {
            String name0 = e.getAttribute(NElementFactoryXmlElement.ATTRIBUTE_NAME);
            String type0 = e.getAttribute(NElementFactoryXmlElement.ATTRIBUTE_TYPE);
            this.name = NBlankable.isBlank(name0) ? e.getTagName() : NStringUtils.trim(name0);
            String string = this.type = NBlankable.isBlank(type0) ? e.getTagName() : NStringUtils.trim(type0);
            if (this.type.isEmpty()) {
                this.type = NElementFactoryXmlElement.TAG_STRING;
            }
            this.value = e.getAttribute(NElementFactoryXmlElement.ATTRIBUTE_VALUE);
        }
    }
}

