/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tson.bundled.util;

import java.util.Arrays;

public class Kmp {
    private char[] pattern;
    private int[] lsp;
    private int incrementalIndex = 0;
    private int len = 0;

    public static Kmp compile(char[] pattern, int offset, int count) {
        return new Kmp(Arrays.copyOfRange(pattern, offset, offset + count));
    }

    public static Kmp compile(char[] pattern) {
        return new Kmp(pattern);
    }

    public static Kmp compile(String pattern) {
        return new Kmp(pattern);
    }

    private Kmp(char[] pattern, int offset, int count) {
        this(Arrays.copyOfRange(pattern, offset, offset + count));
    }

    private Kmp(String pattern) {
        this(pattern.toCharArray());
    }

    private Kmp(char[] patternChars) {
        this.init(patternChars);
    }

    private void init(char[] patternChars) {
        int len0;
        this.pattern = patternChars;
        this.len = len0 = patternChars.length;
        int[] lsp0 = new int[len0];
        for (int i = 1; i < len0; ++i) {
            int j = lsp0[i - 1];
            while (j > 0 && patternChars[i] != patternChars[j]) {
                j = lsp0[j - 1];
            }
            if (patternChars[i] == patternChars[j]) {
                // empty if block
            }
            lsp0[i] = ++j;
        }
        this.lsp = lsp0;
    }

    public int length() {
        return this.len;
    }

    public Kmp reset() {
        this.incrementalIndex = 0;
        return this;
    }

    public boolean next(char c) {
        int j = this.incrementalIndex;
        while (j > 0 && c != this.pattern[j]) {
            j = this.lsp[j - 1];
        }
        if (c == this.pattern[j]) {
            boolean ok = ++j == this.pattern.length;
            this.incrementalIndex = j;
            return ok;
        }
        this.incrementalIndex = j;
        return false;
    }

    public int search(String text) {
        int j = 0;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            while (j > 0 && c != this.pattern[j]) {
                j = this.lsp[j - 1];
            }
            if (c != this.pattern[j] || ++j != this.pattern.length) continue;
            return i - (j - 1);
        }
        return -1;
    }
}

