/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tson.bundled.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UncheckedIOException;

public class Base64EncoderAdapter
extends Reader {
    private static final char[] BASE64_CHARS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private InputStream in;
    private char[] newline = new char[]{'\n'};
    private char[] outBuffer;
    private int outBufferWriteIndex = 0;
    private int outBufferReadIndex = 0;
    private byte[] inBuffer = new byte[3];
    private int inBufferIndex = 0;
    private int lineMax;
    private int lineLength;
    private byte[] tempBuffer;

    public Base64EncoderAdapter(InputStream in) {
        this(in, 76, -1);
    }

    public Base64EncoderAdapter(InputStream in, int lineMax) {
        this(in, lineMax, -1);
    }

    public Base64EncoderAdapter(InputStream in, int lineMax, int bufferSize) {
        this.in = in;
        this.lineMax = lineMax;
        if (bufferSize <= 0) {
            bufferSize = 1;
        }
        this.outBuffer = new char[bufferSize * 4 / 3 + 4 + 3];
        this.tempBuffer = new byte[bufferSize];
    }

    public static String toBase64(byte[] bytes) {
        return Base64EncoderAdapter.toBase64(bytes, -1);
    }

    public static String toBase64(byte[] bytes, int linemax) {
        Base64EncoderAdapter r = new Base64EncoderAdapter(new ByteArrayInputStream(bytes), linemax);
        char[] chars = new char[1024];
        StringBuilder sb = new StringBuilder();
        try {
            int i;
            while ((i = r.read(chars)) != 0) {
                sb.append(chars, 0, i);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return sb.toString();
    }

    boolean pushByte(byte b) {
        this.inBuffer[this.inBufferIndex++] = b;
        if (this.inBufferIndex == 3) {
            int bits = (this.inBuffer[0] & 0xFF) << 16 | (this.inBuffer[1] & 0xFF) << 8 | this.inBuffer[2] & 0xFF;
            this.pushChar(BASE64_CHARS[bits >>> 18 & 0x3F]);
            this.pushChar(BASE64_CHARS[bits >>> 12 & 0x3F]);
            this.pushChar(BASE64_CHARS[bits >>> 6 & 0x3F]);
            this.pushChar(BASE64_CHARS[bits & 0x3F]);
            this.inBufferIndex = 0;
            return true;
        }
        return false;
    }

    private void pushChar(char c) {
        if (this.outBufferWriteIndex >= this.outBuffer.length - 3) {
            if (this.outBufferReadIndex > 0) {
                int len = this.outBufferWriteIndex - this.outBufferReadIndex;
                System.arraycopy(this.outBuffer, this.outBufferReadIndex, this.outBuffer, 0, len);
                this.outBufferReadIndex = 0;
                this.outBufferWriteIndex = len;
            } else {
                throw new IllegalArgumentException("Buffer overflow");
            }
        }
        this.outBuffer[this.outBufferWriteIndex++] = c;
        ++this.lineLength;
        if (this.lineLength >= this.lineMax) {
            for (char b : this.newline) {
                this.outBuffer[this.outBufferWriteIndex++] = b;
            }
            this.lineLength = 0;
        }
    }

    private void finish() {
        int b0 = this.inBuffer[0] & 0xFF;
        switch (this.inBufferIndex) {
            case 1: {
                this.pushChar(BASE64_CHARS[b0 >> 2]);
                this.pushChar(BASE64_CHARS[b0 << 4 & 0x3F]);
                this.pushChar('=');
                this.pushChar('=');
                this.inBufferIndex = 0;
                break;
            }
            case 2: {
                this.pushChar(BASE64_CHARS[b0 >> 2]);
                int b1 = this.inBuffer[1] & 0xFF;
                this.pushChar(BASE64_CHARS[b0 << 4 & 0x3F | b1 >> 4]);
                this.pushChar(BASE64_CHARS[b1 << 2 & 0x3F]);
                this.pushChar('=');
                this.inBufferIndex = 0;
                break;
            }
        }
    }

    private int dataReady() {
        block5: {
            if (this.outBufferReadIndex < this.outBufferWriteIndex) break block5;
            do {
                int c = 0;
                try {
                    c = this.in.read(this.tempBuffer);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                if (c <= 0) {
                    this.finish();
                    break;
                }
                for (int i = 0; i < c; ++i) {
                    this.pushByte(this.tempBuffer[i]);
                }
            } while (this.outBufferWriteIndex - this.outBufferReadIndex <= 0);
        }
        return this.outBufferWriteIndex - this.outBufferReadIndex;
    }

    @Override
    public int read(char[] cbuf, int off, int len) {
        int r;
        if (len > 0 && (r = this.dataReady()) > 0) {
            if (r <= len) {
                len = r;
            }
            System.arraycopy(this.outBuffer, this.outBufferReadIndex, cbuf, off, len);
            this.outBufferReadIndex += len;
            return len;
        }
        return 0;
    }

    @Override
    public void close() {
        try {
            this.in.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

