/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.util;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.thevpc.nuts.util.NAssert;

public final class UnmodifiableArrayList<E>
extends AbstractList<E>
implements RandomAccess,
Serializable {
    private static final long serialVersionUID = -2764017481108945198L;
    private static final UnmodifiableArrayList EMPTY = new UnmodifiableArrayList<Object>(new Object[0]);
    private final E[] values;

    public static <E> UnmodifiableArrayList<E> empty() {
        return EMPTY;
    }

    public static <E> UnmodifiableArrayList<E> ofCopy(E[] array) {
        return new UnmodifiableArrayList(Arrays.copyOf(array, array.length, array.getClass()));
    }

    public static <E> UnmodifiableArrayList<E> ofRef(E[] array) {
        return new UnmodifiableArrayList<E>(array);
    }

    private UnmodifiableArrayList(E[] array) {
        this.values = array;
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    public Object[] toArray() {
        return (Object[])this.values.clone();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int size = this.size();
        if (a.length < size) {
            return Arrays.copyOf(this.values, size, a.getClass());
        }
        System.arraycopy(this.values, 0, a, 0, size);
        return a;
    }

    @Override
    public E get(int index) {
        return this.values[index];
    }

    @Override
    public E set(int index, E element) {
        E oldValue = this.values[index];
        this.values[index] = element;
        return oldValue;
    }

    @Override
    public int indexOf(Object o) {
        E[] a = this.values;
        if (o == null) {
            for (int i = 0; i < a.length; ++i) {
                if (a[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < a.length; ++i) {
                if (!o.equals(a[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    @Override
    public Spliterator<E> spliterator() {
        return Spliterators.spliterator(this.values, 16);
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        NAssert.requireNonNull(action);
        for (E e : this.values) {
            action.accept(e);
        }
    }

    @Override
    public void replaceAll(UnaryOperator<E> operator) {
        NAssert.requireNonNull(operator);
        E[] a = this.values;
        for (int i = 0; i < a.length; ++i) {
            a[i] = operator.apply(a[i]);
        }
    }

    @Override
    public void sort(Comparator<? super E> c) {
        Arrays.sort(this.values, c);
    }
}

