/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.util;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.CharBuffer;

public class AppendableWriter
extends Writer {
    protected Appendable sb;

    public AppendableWriter(Appendable sb) {
        this.sb = sb;
    }

    public static AppendableWriter of(StringBuilder a) {
        return new StringBuilderWriter(a);
    }

    public static AppendableWriter of(StringBuffer a) {
        return new StringBufferWriter(a);
    }

    public static AppendableWriter of(CharBuffer a) {
        return new CharBufferWriter(a);
    }

    public static AppendableWriter of(Appendable a) {
        if (a instanceof StringBuilder) {
            return new StringBuilderWriter((StringBuilder)a);
        }
        if (a instanceof StringBuffer) {
            return new StringBufferWriter((StringBuffer)a);
        }
        if (a instanceof CharBuffer) {
            return new CharBufferWriter((CharBuffer)a);
        }
        return new AppendableWriter(a);
    }

    public String toString() {
        return this.sb.toString();
    }

    @Override
    public void write(int c) {
        try {
            this.sb.append((char)c);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void write(String str) {
        try {
            this.sb.append(str);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void write(String str, int off, int len) {
        try {
            this.sb.append(str, off, off + len);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void write(char[] bytes, int offset, int count) {
        if (this.sb instanceof StringBuilder) {
            ((StringBuilder)this.sb).append(bytes, offset, count);
        } else {
            try {
                this.sb.append(new String(bytes, offset, count));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    @Override
    public AppendableWriter append(CharSequence sequence) {
        if (sequence == null) {
            this.write("null");
        } else {
            this.write(sequence.toString());
        }
        return this;
    }

    @Override
    public AppendableWriter append(CharSequence csq, int start, int end) {
        CharSequence cs = csq == null ? "null" : csq;
        this.write(cs.subSequence(start, end).toString());
        return this;
    }

    @Override
    public AppendableWriter append(char c) {
        this.write(c);
        return this;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    private static class StringBuilderWriter
    extends AppendableWriter {
        StringBuilder sb;

        public StringBuilderWriter(StringBuilder sb) {
            super(sb);
            this.sb = sb;
        }

        @Override
        public void write(char[] bytes, int offset, int count) {
            this.sb.append(bytes, offset, count);
        }
    }

    private static class StringBufferWriter
    extends AppendableWriter {
        StringBuffer sb;

        public StringBufferWriter(StringBuffer sb) {
            super(sb);
            this.sb = sb;
        }

        @Override
        public void write(char[] bytes, int offset, int count) {
            this.sb.append(bytes, offset, count);
        }
    }

    private static class CharBufferWriter
    extends AppendableWriter {
        CharBuffer sb;

        public CharBufferWriter(CharBuffer sb) {
            super(sb);
            this.sb = sb;
        }

        @Override
        public void write(char[] bytes, int offset, int count) {
            this.sb.put(bytes, offset, count);
        }
    }
}

