/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.parser;

import java.util.Arrays;

public class StrFastReader {
    private char[] all;
    private int index;

    public StrFastReader(String s) {
        this.all = s.toCharArray();
    }

    public String peek(int count) {
        int max = Math.min(this.all.length - this.index, count);
        if (max <= 0) {
            return "";
        }
        char[] chars = Arrays.copyOfRange(this.all, this.index, this.index + count);
        return new String(chars);
    }

    public String read(int count) {
        int max = Math.min(this.all.length - this.index, count);
        if (max <= 0) {
            return "";
        }
        char[] chars = Arrays.copyOfRange(this.all, this.index, this.index + count);
        this.index += count;
        return new String(chars);
    }

    public char read() {
        char c = this.all[this.index];
        ++this.index;
        return c;
    }

    public char peek() {
        return this.all[this.index];
    }

    public boolean hasNext() {
        return this.index < this.all.length;
    }

    public String readAnyIgnoreCase(String ... all) {
        for (String s : all) {
            boolean y = this.readIgnoreCase(s);
            if (!y) continue;
            return s;
        }
        return null;
    }

    public String readAny(String ... all) {
        for (String s : all) {
            boolean y = this.read(s);
            if (!y) continue;
            return s;
        }
        return null;
    }

    public String readAny(char ... s) {
        if (this.index >= this.all.length) {
            return null;
        }
        for (int i = 0; i < s.length; ++i) {
            if (s[i] != this.all[this.index]) continue;
            String ss = String.valueOf(this.all[this.index]);
            ++this.index;
            return ss;
        }
        return null;
    }

    public String peekAny(char ... s) {
        if (this.index >= this.all.length) {
            return null;
        }
        for (int i = 0; i < s.length; ++i) {
            if (s[i] != this.all[this.index]) continue;
            return String.valueOf(this.all[this.index]);
        }
        return null;
    }

    public boolean read(char s) {
        if (this.index >= this.all.length) {
            return false;
        }
        if (s == this.all[this.index]) {
            ++this.index;
            return true;
        }
        return false;
    }

    public boolean peek(char s) {
        if (this.index >= this.all.length) {
            return false;
        }
        return s == this.all[this.index];
    }

    public String readWhile(CharPredicate p) {
        char c;
        StringBuilder sb = new StringBuilder();
        while (this.hasNext() && p.test(c = this.peek())) {
            sb.append(c);
            this.read();
        }
        return sb.toString();
    }

    public String readUntil(CharPredicate p) {
        char c;
        StringBuilder sb = new StringBuilder();
        while (this.hasNext() && !p.test(c = this.peek())) {
            this.read();
            sb.append(c);
        }
        return sb.toString();
    }

    public boolean read(String s) {
        int len = s.length();
        if (this.index + len - 1 >= this.all.length) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (s.charAt(i) == this.all[this.index + i]) continue;
            return false;
        }
        this.index += len;
        return true;
    }

    public boolean readIgnoreCase(String s) {
        int len = s.length();
        if (this.index + len - 1 >= this.all.length) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            char c2;
            char c1 = Character.toUpperCase(s.charAt(i));
            if (c1 == (c2 = Character.toUpperCase(this.all[this.index + i]))) continue;
            return false;
        }
        this.index += len;
        return true;
    }

    public boolean peek(String s) {
        int len = s.length();
        if (this.index + len - 1 >= this.all.length) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (s.charAt(i) == this.all[this.index]) continue;
            return false;
        }
        return true;
    }

    public void unread() {
        --this.index;
    }

    public String toString() {
        if (this.index < this.all.length) {
            return new String(this.all, this.index, this.all.length - this.index);
        }
        return "";
    }

    static interface CharPredicate {
        public boolean test(char var1);
    }
}

