/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.parser;

import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.parser.AbstractCharStreamCodeSupport;

public class CharStreamCodeSupportDefault
extends AbstractCharStreamCodeSupport {
    private int brackets;
    private int braces;
    private int parens;
    private String state = "";

    @Override
    public void reset() {
        this.brackets = 0;
        this.braces = 0;
        this.parens = 0;
        this.state = "";
    }

    @Override
    public String getErrorMessage() {
        StringBuilder sb = new StringBuilder();
        if (this.parens < 0) {
            if (sb.length() > 0) {
                sb.append(". ");
            }
            sb.append("Too many ')'");
        }
        if (this.parens > 0) {
            if (sb.length() > 0) {
                sb.append(". ");
            }
            sb.append("missing '('");
        }
        if (this.braces < 0) {
            if (sb.length() > 0) {
                sb.append(". ");
            }
            sb.append("Too many '}'");
        }
        if (this.braces > 0) {
            if (sb.length() > 0) {
                sb.append(". ");
            }
            sb.append("missing '{'");
        }
        if (this.brackets < 0) {
            if (sb.length() > 0) {
                sb.append(". ");
            }
            sb.append("Too many ']'");
        }
        if (this.brackets > 0) {
            if (sb.length() > 0) {
                sb.append(". ");
            }
            sb.append("missing '['");
        }
        switch (this.state) {
            case "\"": {
                if (sb.length() > 0) {
                    sb.append(". ");
                }
                sb.append("missing '\"'");
            }
            case "'": {
                if (sb.length() > 0) {
                    sb.append(". ");
                }
                sb.append("missing '\\''");
            }
            case "/*": 
            case "/*_*": {
                if (sb.length() > 0) {
                    sb.append(". ");
                }
                sb.append("missing '*/'");
            }
        }
        return sb.toString();
    }

    @Override
    public boolean isValid() {
        if (this.parens == 0 && this.braces == 0 && this.brackets == 0) {
            switch (this.state) {
                case "": 
                case "/": {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public void next(char c) {
        block11 : switch (this.state) {
            case "": {
                switch (c) {
                    case '(': {
                        ++this.parens;
                        break;
                    }
                    case ')': {
                        --this.parens;
                        if (this.parens >= 0) break;
                        throw new IllegalArgumentException("Invalid char " + c);
                    }
                    case '{': {
                        ++this.braces;
                        break;
                    }
                    case '}': {
                        --this.braces;
                        if (this.braces >= 0) break;
                        throw new IllegalArgumentException("Invalid char " + c);
                    }
                    case '[': {
                        ++this.brackets;
                        break;
                    }
                    case ']': {
                        --this.brackets;
                        if (this.brackets >= 0) break;
                        throw new IllegalArgumentException("Invalid char " + c);
                    }
                    case '\"': {
                        this.state = "\"";
                        break;
                    }
                    case '\'': {
                        this.state = "'";
                        break;
                    }
                    case '\\': {
                        this.state = "\\";
                        break;
                    }
                    case '/': {
                        this.state = "/?";
                    }
                }
                break;
            }
            case "\"": {
                switch (c) {
                    case '\"': {
                        this.state = "";
                        break;
                    }
                    case '\\': {
                        this.state = "\"\\";
                    }
                }
                break;
            }
            case "\\\"": {
                this.state = "\"";
                break;
            }
            case "'": {
                switch (c) {
                    case '\'': {
                        this.state = "";
                        break;
                    }
                    case '\\': {
                        this.state = "\"\\";
                    }
                }
                break;
            }
            case "\\'": {
                this.state = "'";
                break;
            }
            case "/": {
                switch (c) {
                    case '/': {
                        this.state = "//";
                        break block11;
                    }
                    case '*': {
                        this.state = "/*";
                        break block11;
                    }
                }
                this.state = "";
                break;
            }
            case "//": {
                switch (c) {
                    case '\n': 
                    case '\r': {
                        this.state = "";
                    }
                }
                break;
            }
            case "/*": {
                switch (c) {
                    case '*': {
                        this.state = "/*_*";
                    }
                }
                break;
            }
            case "/*_*": {
                switch (c) {
                    case '/': {
                        this.state = "";
                        break block11;
                    }
                }
                this.state = "/*";
            }
        }
    }
}

