/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements;

import java.util.Objects;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.Tson;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonBoolean;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElement;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementType;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonPrimitiveBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonString;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.builders.TsonPrimitiveElementBuilderImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.AbstractPrimitiveTsonElement;

public class TsonStringImpl
extends AbstractPrimitiveTsonElement
implements TsonString {
    private String rawValue;
    private String value;

    public TsonStringImpl(TsonElementType elementType, String value, String rawValue) {
        super(elementType);
        this.value = value;
        this.rawValue = rawValue;
    }

    @Override
    public TsonBoolean toBoolean() {
        String svalue = String.valueOf(this.value).trim().toLowerCase();
        if (!svalue.isEmpty()) {
            if (svalue.matches("true|enable|enabled|yes|always|y|on|ok|t|o")) {
                return (TsonBoolean)Tson.of(true);
            }
            if (svalue.matches("false|disable|disabled|no|none|never|n|off|ko|f")) {
                return (TsonBoolean)Tson.of(false);
            }
        }
        return super.toBoolean();
    }

    @Override
    public String literalString() {
        switch (this.type()) {
            case DOUBLE_QUOTED_STRING: {
                return this.quoted("\"");
            }
            case SINGLE_QUOTED_STRING: {
                return this.quoted("'");
            }
            case ANTI_QUOTED_STRING: {
                return this.quoted("`");
            }
            case TRIPLE_DOUBLE_QUOTED_STRING: {
                return this.quoted("\"\"\"");
            }
            case TRIPLE_SINGLE_QUOTED_STRING: {
                return this.quoted("'''");
            }
            case TRIPLE_ANTI_QUOTED_STRING: {
                return this.quoted("```");
            }
            case LINE_STRING: {
                return "\u00b6" + this.raw() + "\n";
            }
        }
        throw new IllegalArgumentException("unexpected");
    }

    private String quoted(String quotes) {
        String str = this.raw();
        if (quotes.length() == 1) {
            char c0 = quotes.charAt(0);
            StringBuilder sb = new StringBuilder();
            for (char c : str.toCharArray()) {
                if (c == c0) {
                    sb.append('\\');
                    sb.append(c);
                    continue;
                }
                if (c == '\'') {
                    sb.append('\\');
                    sb.append('\\');
                    continue;
                }
                sb.append(c);
            }
            sb.insert(0, c0);
            sb.append(c0);
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder();
        char[] charArray = str.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            if (c == '\\' && i + 3 < charArray.length && charArray[i + 1] == quotes.charAt(0) && charArray[i + 2] == quotes.charAt(1) && charArray[i + 3] == quotes.charAt(2)) {
                sb.append("\\\\");
                continue;
            }
            if (i + 2 < charArray.length && charArray[i + 0] == quotes.charAt(0) && charArray[i + 1] == quotes.charAt(1) && charArray[i + 2] == quotes.charAt(2)) {
                sb.append("\\");
                sb.append(quotes);
                i += quotes.length() - 1;
                continue;
            }
            sb.append(c);
        }
        sb.insert(0, quotes);
        sb.append(quotes);
        return sb.toString();
    }

    @Override
    public TsonString toStr() {
        return this;
    }

    @Override
    public String value() {
        return this.value;
    }

    @Override
    public String raw() {
        return this.rawValue;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TsonStringImpl that = (TsonStringImpl)o;
        return Objects.equals(this.value(), that.value());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.value());
    }

    @Override
    public TsonPrimitiveBuilder builder() {
        return new TsonPrimitiveElementBuilderImpl().copyFrom(this);
    }

    @Override
    protected int compareCore(TsonElement o) {
        return this.value().compareTo(o.stringValue());
    }

    @Override
    public String stringValue() {
        return this.value();
    }
}

