/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements;

import java.util.Objects;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonDocumentVisitor;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElement;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementType;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonPair;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonPairBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonParserVisitor;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.builders.TsonPairBuilderImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.AbstractNonPrimitiveTsonElement;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.util.TsonUtils;

public class TsonPairImpl
extends AbstractNonPrimitiveTsonElement
implements TsonPair {
    private TsonElement key;
    private TsonElement value;

    public TsonPairImpl(TsonElement key, TsonElement value) {
        super(TsonElementType.PAIR);
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null. Try to use NULL Tson element");
        }
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null. Try to use NULL Tson element");
        }
        if (key.type() == TsonElementType.PAIR) {
            throw new IllegalArgumentException("Key of Key Value cannot be a key value as well");
        }
        if (value.type() == TsonElementType.PAIR) {
            throw new IllegalArgumentException("value of Key Value cannot be a key value as well");
        }
        this.key = key;
        this.value = value;
    }

    @Override
    public boolean isSimplePair() {
        return this.type() == TsonElementType.PAIR && this.key().isSimple();
    }

    @Override
    public TsonPair toPair() {
        return this;
    }

    @Override
    public TsonElement value() {
        return this.value;
    }

    @Override
    public TsonElement key() {
        return this.key;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TsonPairImpl that = (TsonPairImpl)o;
        return Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.key, this.value);
    }

    @Override
    public TsonPairBuilder builder() {
        return new TsonPairBuilderImpl().key(this.key()).value(this.value());
    }

    @Override
    public boolean visit(TsonDocumentVisitor visitor) {
        if (visitor.visit(this)) {
            if (!this.key.visit(visitor)) {
                return false;
            }
            if (!this.value.visit(visitor)) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected int compareCore(TsonElement o) {
        TsonPair oo = o.toPair();
        return TsonUtils.compareElementsArray(new TsonElement[]{this.key(), this.value()}, new TsonElement[]{oo.key(), oo.value()});
    }

    @Override
    public void visit(TsonParserVisitor visitor) {
        visitor.visitInstructionStart();
        this.key().visit(visitor);
        this.value().visit(visitor);
        visitor.visitKeyValueEnd();
    }
}

