/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements;

import java.util.Objects;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonDocumentVisitor;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElement;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementType;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonOp;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonOpBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonOpType;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonPair;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonParserVisitor;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.builders.TsonOpBuilderImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.AbstractNonPrimitiveTsonElement;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.util.TsonUtils;

public class TsonOpImpl
extends AbstractNonPrimitiveTsonElement
implements TsonOp {
    private String opName;
    private TsonElement first;
    private TsonElement second;
    private TsonOpType opType;

    public TsonOpImpl(String opName, TsonOpType opType, TsonElement first, TsonElement second) {
        super(TsonElementType.OP);
        if (opName == null) {
            throw new IllegalArgumentException("op cannot be null. Try to use NULL Tson element");
        }
        if (first == null) {
            throw new IllegalArgumentException("Key cannot be null. Try to use NULL Tson element");
        }
        if (second == null) {
            throw new IllegalArgumentException("Value cannot be null. Try to use NULL Tson element");
        }
        if (opType == null) {
            throw new IllegalArgumentException("opType cannot be null. Try to use NULL Tson element");
        }
        if (first.type() == TsonElementType.PAIR) {
            throw new IllegalArgumentException("Key of Key Value cannot be a key value as well");
        }
        if (second.type() == TsonElementType.PAIR) {
            throw new IllegalArgumentException("Key of Key Value cannot be a key value as well");
        }
        this.opName = opName;
        this.opType = opType;
        this.first = first;
        this.second = second;
    }

    @Override
    public TsonOpType opType() {
        return this.opType;
    }

    @Override
    public String opName() {
        return this.opName;
    }

    @Override
    public TsonOp toOp() {
        return this;
    }

    @Override
    public TsonElement second() {
        return this.second;
    }

    @Override
    public TsonElement first() {
        return this.first;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TsonOpImpl that = (TsonOpImpl)o;
        return Objects.equals(this.first, that.first) && Objects.equals(this.second, that.second) && Objects.equals((Object)this.opType, (Object)that.opType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.first, this.second, this.opType});
    }

    @Override
    public TsonOpBuilder builder() {
        return new TsonOpBuilderImpl().first(this.first()).second(this.second());
    }

    @Override
    public boolean visit(TsonDocumentVisitor visitor) {
        if (visitor.visit(this)) {
            if (!this.first.visit(visitor)) {
                return false;
            }
            if (!this.second.visit(visitor)) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected int compareCore(TsonElement o) {
        TsonPair oo = o.toPair();
        return TsonUtils.compareElementsArray(new TsonElement[]{this.first(), this.second()}, new TsonElement[]{oo.key(), oo.value()});
    }

    @Override
    public void visit(TsonParserVisitor visitor) {
        visitor.visitInstructionStart();
        this.first().visit(visitor);
        this.second().visit(visitor);
        visitor.visitKeyValueEnd();
    }
}

