/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.Temporal;
import java.util.Objects;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.Tson;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElement;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementType;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonLocalDate;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonLocalTime;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonPrimitiveBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonString;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.builders.TsonPrimitiveElementBuilderImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.AbstractTemporalTsonElement;

public class TsonLocalDateImpl
extends AbstractTemporalTsonElement
implements TsonLocalDate {
    private LocalDate value;

    public TsonLocalDateImpl(LocalDate value) {
        super(TsonElementType.LOCAL_DATE);
        this.value = value;
    }

    public TsonLocalDateImpl(String value) {
        super(TsonElementType.LOCAL_DATE);
        this.value = LocalDate.parse(value);
    }

    @Override
    public Temporal temporalValue() {
        return this.value;
    }

    @Override
    public TsonElement build() {
        return (TsonString)Tson.of(String.valueOf(this.value));
    }

    @Override
    public TsonString toStr() {
        return (TsonString)Tson.of(String.valueOf(this.value));
    }

    @Override
    public TsonLocalTime toLocalTime() {
        return (TsonLocalTime)Tson.ofLocalTime(this.localTimeValue());
    }

    @Override
    public LocalDate localDateValue() {
        return this.value();
    }

    @Override
    public LocalTime localTimeValue() {
        return LocalTime.from(this.value());
    }

    @Override
    public LocalDateTime localDateTimeValue() {
        return this.value().atStartOfDay();
    }

    @Override
    public TsonLocalDate toLocalDate() {
        return this;
    }

    @Override
    public LocalDate value() {
        return this.value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TsonLocalDateImpl tsonDate = (TsonLocalDateImpl)o;
        return Objects.equals(this.value, tsonDate.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.value);
    }

    @Override
    public TsonPrimitiveBuilder builder() {
        return new TsonPrimitiveElementBuilderImpl().copyFrom(this);
    }

    @Override
    protected int compareCore(TsonElement o) {
        return this.value.compareTo(o.toLocalDate().value());
    }

    @Override
    public int compareTo(TsonElement o) {
        if (o.type().isTemporal()) {
            switch (o.type()) {
                case LOCAL_DATETIME: {
                    int i = this.localDateTimeValue().compareTo(o.localDateTimeValue());
                    return i == 0 ? this.type().compareTo(o.type()) : i;
                }
                case LOCAL_DATE: {
                    int i = this.value().compareTo(o.localDateValue());
                    return i == 0 ? this.type().compareTo(o.type()) : i;
                }
                case LOCAL_TIME: {
                    int i = this.value().compareTo(o.localDateValue());
                    return i == 0 ? this.type().compareTo(o.type()) : i;
                }
            }
        }
        return super.compareTo(o);
    }
}

