/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.temporal.Temporal;
import java.util.Objects;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.Tson;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElement;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementType;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonInstant;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonLocalDate;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonLocalTime;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonPrimitiveBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonString;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.builders.TsonPrimitiveElementBuilderImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.AbstractTemporalTsonElement;

public class TsonInstantImpl
extends AbstractTemporalTsonElement
implements TsonInstant {
    private Instant value;

    public TsonInstantImpl(Instant value) {
        super(TsonElementType.INSTANT);
        this.value = value;
    }

    @Override
    public TsonString toStr() {
        return (TsonString)Tson.of(String.valueOf(this.value));
    }

    @Override
    public Temporal temporalValue() {
        return this.value;
    }

    @Override
    public TsonInstant toInstant() {
        return this;
    }

    @Override
    public LocalDateTime localDateTimeValue() {
        return this.value().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    @Override
    public TsonLocalTime toLocalTime() {
        return (TsonLocalTime)Tson.ofLocalTime(this.localTimeValue());
    }

    @Override
    public LocalDate localDateValue() {
        return this.value().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    @Override
    public LocalTime localTimeValue() {
        return this.value().atZone(ZoneId.systemDefault()).toLocalTime();
    }

    @Override
    public Instant instantValue() {
        return this.value;
    }

    @Override
    public TsonLocalDate toLocalDate() {
        return (TsonLocalDate)Tson.ofLocalDate(this.localDateValue());
    }

    @Override
    public Instant value() {
        return this.value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TsonInstantImpl tsonDate = (TsonInstantImpl)o;
        return Objects.equals(this.value, tsonDate.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.value);
    }

    @Override
    public TsonPrimitiveBuilder builder() {
        return new TsonPrimitiveElementBuilderImpl().copyFrom(this);
    }

    @Override
    protected int compareCore(TsonElement o) {
        return this.value.compareTo(o.toInstant().value());
    }
}

