/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.Tson;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonBigDecimal;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonBigInt;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonByte;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonDouble;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonDoubleComplex;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElement;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementType;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonFloat;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonFloatComplex;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonLong;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonNumberLayout;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonPrimitiveBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonShort;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.builders.TsonPrimitiveElementBuilderImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.AbstractNumberTsonElement;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonBigDecimalImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonBigIntImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonDoubleComplexImpl;

public class TsonFloatComplexImpl
extends AbstractNumberTsonElement
implements TsonFloatComplex {
    private float real;
    private float imag;

    public TsonFloatComplexImpl(float real, float imag, String unit) {
        super(TsonElementType.FLOAT_COMPLEX, TsonNumberLayout.DECIMAL, unit);
        this.real = real;
        this.imag = imag;
    }

    @Override
    public Number numberValue() {
        return new TsonComplex(this.real, this.imag);
    }

    @Override
    public TsonFloatComplex toFloatComplex() {
        return this;
    }

    @Override
    public TsonDoubleComplex toDoubleComplex() {
        return new TsonDoubleComplexImpl(this.real(), this.imag(), this.numberSuffix());
    }

    @Override
    public TsonBigDecimal toBigDecimal() {
        return new TsonBigDecimalImpl(BigDecimal.valueOf(this.real()), this.numberSuffix());
    }

    @Override
    public float real() {
        return this.real;
    }

    @Override
    public float imag() {
        return this.imag;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TsonFloatComplexImpl tsonInt = (TsonFloatComplexImpl)o;
        return this.real == tsonInt.real && this.imag == tsonInt.imag;
    }

    @Override
    public TsonByte toByte() {
        return Tson.of(this.numberValue().byteValue()).toByte();
    }

    @Override
    public TsonShort toShort() {
        return Tson.of(this.numberValue().shortValue()).toShort();
    }

    @Override
    public TsonLong toLong() {
        return Tson.of(this.numberValue().longValue()).toLong();
    }

    @Override
    public TsonFloat toFloat() {
        return Tson.of(this.numberValue().floatValue()).toFloat();
    }

    @Override
    public TsonDouble toDouble() {
        return Tson.of(this.numberValue().doubleValue()).toDouble();
    }

    @Override
    public Byte byteObject() {
        return this.numberValue().byteValue();
    }

    @Override
    public Long longObject() {
        return this.numberValue().longValue();
    }

    @Override
    public Integer intObject() {
        return this.numberValue().intValue();
    }

    @Override
    public Short shortObject() {
        return this.numberValue().shortValue();
    }

    @Override
    public Float floatObject() {
        return Float.valueOf(this.numberValue().floatValue());
    }

    @Override
    public Double doubleObject() {
        return this.numberValue().doubleValue();
    }

    @Override
    public BigDecimal bigDecimalValue() {
        return BigDecimal.valueOf(this.real());
    }

    @Override
    public BigInteger bigIntegerValue() {
        return this.bigDecimalValue().toBigInteger();
    }

    @Override
    public TsonBigInt toBigInt() {
        return new TsonBigIntImpl(this.bigIntegerValue(), this.numberLayout(), this.numberSuffix());
    }

    @Override
    public byte byteValue() {
        return this.numberValue().byteValue();
    }

    @Override
    public short shortValue() {
        return this.numberValue().shortValue();
    }

    @Override
    public int intValue() {
        return this.numberValue().intValue();
    }

    @Override
    public long longValue() {
        return this.numberValue().longValue();
    }

    @Override
    public float floatValue() {
        return this.numberValue().floatValue();
    }

    @Override
    public double doubleValue() {
        return this.numberValue().doubleValue();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), Float.valueOf(this.real), Float.valueOf(this.imag));
    }

    @Override
    public TsonPrimitiveBuilder builder() {
        return new TsonPrimitiveElementBuilderImpl().copyFrom(this);
    }

    @Override
    protected int compareCore(TsonElement o) {
        return TsonFloatComplexImpl.compare(this, o.toFloatComplex());
    }

    public static int compare(TsonFloatComplex a, TsonFloatComplex oc) {
        int c = Float.compare(a.real(), oc.real());
        if (c != 0) {
            return c;
        }
        c = Float.compare(a.imag(), oc.imag());
        if (c != 0) {
            return c;
        }
        return c;
    }

    @Override
    public int compareTo(TsonElement o) {
        if (o.type().isNumber()) {
            switch (o.type()) {
                case BYTE: 
                case SHORT: 
                case INTEGER: 
                case LONG: 
                case BIG_INTEGER: 
                case FLOAT: 
                case DOUBLE: {
                    int i = this.toDoubleComplex().compareTo(o.toDoubleComplex());
                    return i == 0 ? this.type().compareTo(o.type()) : i;
                }
                case BIG_DECIMAL: 
                case BIG_COMPLEX: {
                    int i = this.toBigComplex().compareTo(o.toBigComplex());
                    return i == 0 ? this.type().compareTo(o.type()) : i;
                }
            }
        }
        return super.compareTo(o);
    }

    private static class TsonComplex
    extends Number {
        private float real;
        private float image;

        public TsonComplex(float real, float image) {
            this.real = real;
            this.image = image;
        }

        public double getReal() {
            return this.real;
        }

        public double getImage() {
            return this.image;
        }

        @Override
        public int intValue() {
            return (int)this.real;
        }

        @Override
        public long longValue() {
            return (long)this.real;
        }

        @Override
        public float floatValue() {
            return this.real;
        }

        @Override
        public double doubleValue() {
            return this.real;
        }

        public String toString() {
            return "TsonFloatComplex{real=" + this.real + ", image=" + this.image + '}';
        }
    }
}

