/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.Tson;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElement;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementBase;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementBaseListBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementList;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonPair;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.builders.TsonElementBaseListBuilderImpl;

public class TsonElementListImpl
implements TsonElementList {
    private ArrayList<TsonElement> elements = new ArrayList();

    public TsonElementListImpl(List<TsonElementBase> elements) {
        for (TsonElementBase element : elements) {
            this.elements.add(Tson.ofElement(element));
        }
    }

    @Override
    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Override
    public TsonElement getAt(int index) {
        return this.elements.get(index);
    }

    @Override
    public TsonElement get(String name) {
        return this.get(name == null ? null : Tson.ofString(name));
    }

    @Override
    public TsonElement get(TsonElement name) {
        TsonElement vn = (name == null ? Tson.ofNull() : name).build();
        for (TsonElement element : this.elements) {
            if (element instanceof TsonPair) {
                TsonPair element1 = (TsonPair)element;
                if (!Objects.equals(element1.key().build(), vn)) continue;
                return element1.value();
            }
            if (!Objects.equals(element.build(), vn)) continue;
            return element;
        }
        return null;
    }

    @Override
    public List<TsonElement> getValues(String name) {
        return this.getValues(name == null ? null : Tson.ofString(name));
    }

    @Override
    public List<TsonElement> getValues(TsonElement name) {
        TsonElement vn = (name == null ? Tson.ofNull() : name).build();
        ArrayList<TsonElement> all = new ArrayList<TsonElement>();
        LinkedHashMap m = new LinkedHashMap();
        for (TsonElement element : this.elements) {
            if (element instanceof TsonPair) {
                TsonPair element1 = (TsonPair)element;
                if (!Objects.equals(element1.key().build(), vn)) continue;
                all.add(element1.value());
                continue;
            }
            if (!Objects.equals(element.build(), vn)) continue;
            all.add(element);
        }
        return all;
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public TsonElementBaseListBuilder builder() {
        return new TsonElementBaseListBuilderImpl(this.elements.stream().map(x -> x).collect(Collectors.toList()));
    }

    @Override
    public Iterator<TsonElement> iterator() {
        return this.elements.iterator();
    }

    @Override
    public Map<TsonElement, TsonElement> toMap() {
        LinkedHashMap<TsonElement, TsonElement> m = new LinkedHashMap<TsonElement, TsonElement>();
        for (TsonElement element : this.elements) {
            if (element instanceof TsonPair) {
                TsonPair element1 = (TsonPair)element;
                m.put(element1.key(), element1.value());
                continue;
            }
            m.put(element, element);
        }
        return m;
    }

    @Override
    public Map<TsonElement, List<TsonElement>> toMultiMap() {
        LinkedHashMap<TsonElement, List<TsonElement>> m = new LinkedHashMap<TsonElement, List<TsonElement>>();
        for (TsonElement element : this.elements) {
            if (element instanceof TsonPair) {
                TsonPair element1 = (TsonPair)element;
                m.computeIfAbsent(element1.key(), k -> new ArrayList()).add(element1.value());
                continue;
            }
            m.computeIfAbsent(element, k -> new ArrayList()).add(element);
        }
        return m;
    }

    @Override
    public List<TsonElement> toList() {
        return new ArrayList<TsonElement>(this.elements);
    }

    @Override
    public TsonElement[] toArray() {
        return this.elements.toArray(new TsonElement[0]);
    }
}

