/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements;

import java.util.List;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonDocumentHeader;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonDocumentHeaderBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElement;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.builders.TsonDocumentHeaderBuilderImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.util.TsonUtils;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.util.UnmodifiableArrayList;

public class TsonDocumentHeaderImpl
implements TsonDocumentHeader {
    private String version = null;
    private String encoding = null;
    private UnmodifiableArrayList<TsonElement> params;

    public TsonDocumentHeaderImpl() {
        this.params = UnmodifiableArrayList.empty();
    }

    public TsonDocumentHeaderImpl(String version, String encoding, TsonElement[] params) {
        this.version = version;
        this.encoding = encoding;
        this.params = UnmodifiableArrayList.ofCopy(params);
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public List<TsonElement> getAll() {
        return this.params;
    }

    @Override
    public int size() {
        return this.params.size();
    }

    @Override
    public List<TsonElement> all() {
        return this.getAll();
    }

    @Override
    public TsonDocumentHeaderBuilder builder() {
        return new TsonDocumentHeaderBuilderImpl().setVersion(this.version).setEncoding(this.encoding).addParams(this.params);
    }

    @Override
    public int compareTo(TsonDocumentHeader o) {
        int i = TsonUtils.compare(this.version, o.getVersion());
        if (i != 0) {
            return i;
        }
        i = TsonUtils.compare(this.encoding, o.getEncoding());
        if (i != 0) {
            return i;
        }
        return TsonUtils.compareElementsArray(this.params, o.getAll());
    }
}

