/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.Tson;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonBoolean;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonCustom;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonCustomBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElement;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementType;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonParserVisitor;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonString;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.builders.TsonCustomElementBuilderImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.AbstractTsonElement;

public class TsonCustomImpl
extends AbstractTsonElement
implements TsonCustom {
    private Object value;

    public static final TsonCustom valueOf(Object value) {
        return new TsonCustomImpl(value);
    }

    public TsonCustomImpl(Object value) {
        super(TsonElementType.CUSTOM);
        this.value = value;
    }

    @Override
    protected <T> T throwPrimitive(TsonElementType type) {
        throw new ClassCastException((Object)((Object)this.type()) + " Cannot cast to " + (Object)((Object)type));
    }

    @Override
    protected <T> T throwNonPrimitive(TsonElementType type) {
        throw new ClassCastException((Object)((Object)this.type()) + " cannot be cast to " + (Object)((Object)type));
    }

    @Override
    public TsonString toStr() {
        return (TsonString)Tson.of(String.valueOf(this.value));
    }

    @Override
    public TsonElement build() {
        return this;
    }

    @Override
    public void visit(TsonParserVisitor visitor) {
        visitor.visitElementStart();
        visitor.visitCustomEnd(this);
    }

    @Override
    public TsonBoolean toBoolean() {
        String svalue;
        if (this.value instanceof Boolean) {
            return (TsonBoolean)Tson.of((Boolean)this.value);
        }
        if (this.value instanceof TsonElement) {
            return ((TsonElement)this.value).toBoolean();
        }
        if (this.value instanceof Number) {
            Number value = (Number)this.value;
            if (value instanceof Number) {
                if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof BigInteger) {
                    return (TsonBoolean)Tson.of(value.longValue() != 0L);
                }
                if (value instanceof Float || value instanceof Double || value instanceof BigDecimal) {
                    double d = value.doubleValue();
                    return (TsonBoolean)Tson.of(d != 0.0 && !Double.isNaN(d));
                }
            }
        } else if (this.value instanceof String && !(svalue = ((String)this.value).trim().toLowerCase()).isEmpty()) {
            if (svalue.matches("true|enable|enabled|yes|always|y|on|ok|t|o")) {
                return (TsonBoolean)Tson.of(true);
            }
            if (svalue.matches("false|disable|disabled|no|none|never|n|off|ko|f")) {
                return (TsonBoolean)Tson.of(false);
            }
        }
        return (TsonBoolean)this.throwPrimitive(TsonElementType.BOOLEAN);
    }

    @Override
    public Object value() {
        return this.value;
    }

    @Override
    public boolean booleanValue() {
        return this.toBoolean().booleanValue();
    }

    @Override
    public Boolean booleanObject() {
        return this.booleanValue();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TsonCustomImpl that = (TsonCustomImpl)o;
        return Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.value);
    }

    @Override
    public TsonCustomBuilder builder() {
        return new TsonCustomElementBuilderImpl().setCustom(this);
    }

    @Override
    protected int compareCore(TsonElement o) {
        if (o instanceof TsonCustom) {
            Object tval = this.value;
            Object oval = ((TsonCustom)o).value();
            if (tval == null && oval == null) {
                return 0;
            }
            if (tval == null) {
                return -1;
            }
            if (oval == null) {
                return 1;
            }
            if (Objects.equals(tval, oval)) {
                return 0;
            }
            if (tval instanceof Comparable) {
                Comparable ctval = (Comparable)tval;
                return ctval.compareTo(oval);
            }
            if (oval instanceof Comparable) {
                Comparable coval = (Comparable)oval;
                return -coval.compareTo(tval);
            }
            return -1;
        }
        return 1;
    }
}

